/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Component;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.ServoPortValueListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.ServoPortTableModel;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.model.listener.ServoPortModelListener;
import org.bidib.wizard.client.common.table.AbstractHierarchicalEmptyTable;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.table.ServoPortTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.mvc.main.controller.ServoPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServoPortListPanel
extends SimpleHierarchicalPortListPanel<ServoPortTableModel, ServoPortStatus, ServoPort, ServoPortValueListener, ServoPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoPortListPanel.class);
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;
    private final SettingsService settingsService;

    public ServoPortListPanel(ServoPortPanelController controller, ServoPortTableModel tableModel, MainModel mainModel, SettingsService settingsService, TabVisibilityListener tabVisibilityListener, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super((SimpleHierarchicalPortTableModel)tableModel, Resources.getString(ServoPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, (NodeSelectionProvider)mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        this.settingsService = settingsService;
        TableColumnChooser.hideColumn((JTable)this.table, (int)5);
    }

    protected AbstractPortHierarchicalTable<ServoPort> createPortTable(ServoPortTableModel tableModel, String emptyTableText) {
        return new ServoPortTable(tableModel, emptyTableText);
    }

    protected void createTable(ServoPortTableModel tableModel, String emptyTableText, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable((SimpleHierarchicalPortTableModel)tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof ServoPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected AbstractHierarchicalEmptyTable.PackLastColumnEnum isPackLastColumn() {
        return AbstractHierarchicalEmptyTable.PackLastColumnEnum.VARIABLE;
    }

    public void listChanged() {
        LOGGER.info("Update model has started, call clearTable.");
        super.listChanged();
        this.tabVisibilityListener.setTabVisible((Component)this, this.isTabVisible());
    }

    public Class<?> getPortClass() {
        return ServoPort.class;
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasServoPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    protected List<ServoPort> getPorts() {
        LOGGER.info("Get servo ports.");
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LinkedList<ServoPort> ports = new LinkedList<ServoPort>();
            ports.addAll(node.getServoPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

