/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jidesoft.grid.SortableTableModel;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.bidib.wizard.mvc.main.view.table.Reorderable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroTableRowTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroTableRowTransferHandler.class);
    private final DataFlavor localObjectFlavor = new ActivationDataFlavor(Integer.class, "application/x-java-jvm-local-objectref", "Integer Row Index");
    private JTable table = null;

    public MacroTableRowTransferHandler(JTable table) {
        this.table = table;
    }

    protected Transferable createTransferable(JComponent c) {
        assert (c == this.table);
        return new DataHandler((Object)this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        JTable target = (JTable)info.getComponent();
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        int max = this.table.getModel().getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Integer rowFrom = (Integer)info.getTransferable().getTransferData(this.localObjectFlavor);
            if (rowFrom != -1 && rowFrom != index) {
                int numSelectedRows = target.getSelectedRowCount();
                SortableTableModel tableModel = (SortableTableModel)this.table.getModel();
                ((Reorderable)tableModel.getActualModel()).reorder(rowFrom.intValue(), index, numSelectedRows);
                if (index > rowFrom) {
                    --index;
                    index -= numSelectedRows - 1;
                }
                target.getSelectionModel().setSelectionInterval(index, index + (numSelectedRows - 1));
                Rectangle rect = this.table.getCellRect(index, 0, false);
                if (rect != null) {
                    this.table.scrollRectToVisible(rect);
                }
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Reorder rows failed.", (Throwable)ex);
        }
        return false;
    }

    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

