/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.mvc.main.view.panel.MotorPortListPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorPortTable
extends PortTable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortTable.class);

    public MotorPortTable(TableModel motorPortTableModel, String emptyTableText) {
        super(motorPortTableModel, emptyTableText);
    }

    public String getToolTipText(MouseEvent e) {
        MotorPort port;
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        if (rowIndex == -1 || colIndex == -1) {
            return tip;
        }
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        tip = realColumnIndex == 1 ? ((port = (MotorPort)this.getModel().getValueAt(rowIndex, 4)).isEnabled() ? this.prepareTooltip(port, port.getValue().intValue()) : super.getToolTipText()) : super.getToolTipText();
        return tip;
    }

    private String prepareTooltip(MotorPort port, int value) {
        LOGGER.trace("Set the new value: {}", (Object)value);
        StringBuffer tip = new StringBuffer(Resources.getString(MotorPortListPanel.class, (String)"absolutevalue"));
        tip.append(value);
        return tip.toString();
    }

    public void clearTable() {
        LOGGER.debug("clearTable, remove all rows and remove all slider editors");
    }
}

