/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortComboBoxWithButtonRenderer<E extends BidibStatus>
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortComboBoxWithButtonRenderer.class);
    protected final JComboBox<E> comboBox;
    private final JButton button;
    private final Integer instanceColumn;

    public PortComboBoxWithButtonRenderer(E[] items, String buttonText, Class<?> resourceClazz, Integer instanceColumn) {
        this(items, buttonText, Resources.trimWizardPackage((String)resourceClazz.getName()), instanceColumn);
    }

    public PortComboBoxWithButtonRenderer(E[] items, String buttonText, String resourceClazz, Integer instanceColumn) {
        this.comboBox = new JComboBox<BidibStatus>((BidibStatus[])items.clone());
        this.comboBox.setRenderer(new BidibStatusListRenderer(resourceClazz));
        this.button = new JButton(buttonText);
        this.instanceColumn = instanceColumn;
        this.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 2, 2);
        c.weightx = 1.0;
        this.add((Component)this.comboBox, (Object)c);
        c.anchor = 24;
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.button, (Object)c);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ConfigurablePort) {
            ConfigurablePort port = (ConfigurablePort)value;
            boolean isPortEnabled = this.isPortEnabled(port);
            LOGGER.debug("Port is enabled: {}, port: {}", (Object)isPortEnabled, (Object)port);
            this.setEnabled(isPortEnabled);
            this.comboBox.setEnabled(isPortEnabled);
            this.button.setEnabled(isPortEnabled);
            this.setSelectedValue((Port)port);
        } else if (value instanceof BidibStatus) {
            boolean isPortEnabled = true;
            if (this.instanceColumn != null) {
                ConfigurablePort port = (ConfigurablePort)table.getModel().getValueAt(row, this.instanceColumn);
                isPortEnabled = this.isPortEnabled(port);
            }
            this.setEnabled(isPortEnabled);
            this.comboBox.setEnabled(isPortEnabled);
            this.button.setEnabled(isPortEnabled);
            this.setSelectedValue((BidibStatus)value);
        } else {
            if (value != null) {
                LOGGER.warn("Invalid value: {}", value);
            }
            this.setEnabled(false);
            this.comboBox.setEnabled(false);
            this.button.setEnabled(false);
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
            this.comboBox.setForeground(table.getSelectionForeground());
            this.comboBox.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            this.comboBox.setForeground(table.getForeground());
            this.comboBox.setBackground(table.getBackground());
        }
        return this;
    }

    protected void setSelectedValue(Port<? extends BidibStatus> port) {
        this.comboBox.setSelectedItem(port != null ? port.getStatus() : null);
    }

    protected void setSelectedValue(E status) {
        this.comboBox.setSelectedItem(status);
    }

    protected boolean isPortEnabled(ConfigurablePort<?> port) {
        return port.isEnabled();
    }
}

