/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.rxjava2.SwingScheduler;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.SwitchPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.IoBehaviourSwitchCellRenderer;
import org.bidib.wizard.mvc.main.view.panel.renderer.LoadTypeCellRenderer;
import org.bidib.wizard.mvc.main.view.table.converter.PortStatusToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortEditorPanel
extends AbstractPortEditorPanel<SwitchPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final int TIME_BETWEEN_STATUS_EVENTS_MILLIS = 80;
    private ValueModel switchOffTimeConverterModel;
    private ValueModel selectionHolderIoBehaviour;
    private ValueModel selectionHolderLoadType;
    private JTextField portName;
    private JTextField switchOffTimeText;
    private JComboBox<IoBehaviourSwitchEnum> comboIoBehaviour;
    private JComboBox<LoadTypeEnum> comboLoadType;
    private JComboBox<SwitchPortStatus> comboPortStatus;
    private JButton btnPortStatus;
    private PublishSubject<SwitchPortStatus> statusEventSubject = PublishSubject.create();

    public SwitchPortEditorPanel(SwitchPort port, Consumer<SwitchPort> saveCallback, Consumer<SwitchPort> valueCallback, Consumer<SwitchPort> refreshCallback, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, valueCallback, refreshCallback, nodeSelectionProvider);
    }

    protected SwitchPort clonePort(SwitchPort port) {
        SwitchPort clone = (SwitchPort)SwitchPort.builder().withOutputBehaviour(port.getOutputBehaviour()).withLoadType(port.getLoadType()).withSwitchOffTime(port.getSwitchOffTime()).withStatus((BidibStatus)((SwitchPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        return clone;
    }

    protected JPanel doCreateComponent(SwitchPort port) {
        AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
        int row = 1;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(SwitchPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, row);
        this.portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        this.portName.setEnabled(port.isEnabled());
        dialogBuilder.add((Component)this.portName).xyw(3, row, 7);
        row += 2;
        this.switchOffTimeConverterModel = new ConverterValueModel((ValueModel)this.getPresentationModel().getBufferedModel("switchOffTime"), (BindingConverter)new StringToIntegerConverter());
        if (this.isPortConfigKeySupported((byte)11)) {
            this.switchOffTimeText = new JTextField();
            IntegerInputValidationDocument switchOffTimeDocument = new IntegerInputValidationDocument(5, "0123456789");
            switchOffTimeDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255));
            this.switchOffTimeText.setDocument((Document)switchOffTimeDocument);
            this.switchOffTimeText.setColumns(2);
            this.switchOffTimeText.setHorizontalAlignment(4);
            Bindings.bind((JTextField)this.switchOffTimeText, (ValueModel)this.switchOffTimeConverterModel, (boolean)false);
            dialogBuilder.add(Resources.getString(SwitchPortTableModel.class, (String)"switchOffTime"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.switchOffTimeText).xy(3, row);
            this.switchOffTimeText.setEnabled(port.isEnabled());
            ValidationComponentUtils.setMandatory((JComponent)this.switchOffTimeText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.switchOffTimeText, (Object[])new Object[]{"validation.switchOffTime_key"});
            row += 2;
        }
        this.selectionHolderIoBehaviour = this.getPresentationModel().getBufferedModel("outputBehaviour");
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL)) {
            ArrayListModel ioBehaviourList = new ArrayListModel();
            IoBehaviourSwitchEnum[] ioBehaviourSwitchEnumArray = IoBehaviourSwitchEnum.values();
            int n = ioBehaviourSwitchEnumArray.length;
            for (int i = 0; i < n; ++i) {
                IoBehaviourSwitchEnum value = ioBehaviourSwitchEnumArray[i];
                ioBehaviourList.add((Object)value);
            }
            SelectionInList ioBehaviourSelection = new SelectionInList((ListModel)ioBehaviourList);
            ComboBoxAdapter comboBoxAdapterIoBehaviour = new ComboBoxAdapter((ListModel)ioBehaviourSelection, this.selectionHolderIoBehaviour);
            this.comboIoBehaviour = new JComboBox();
            this.comboIoBehaviour.setModel(comboBoxAdapterIoBehaviour);
            this.comboIoBehaviour.setRenderer(new IoBehaviourSwitchCellRenderer());
            this.comboIoBehaviour.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(SwitchPortTableModel.class, (String)"ioBehaviour") + ":", new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.comboIoBehaviour).xy(3, row);
            row += 2;
        }
        this.selectionHolderLoadType = this.getPresentationModel().getBufferedModel("loadType");
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_LOAD_TYPE)) {
            ArrayListModel loadTypeList = new ArrayListModel();
            for (IoBehaviourSwitchEnum value : LoadTypeEnum.values()) {
                loadTypeList.add((Object)value);
            }
            SelectionInList loadTypeSelection = new SelectionInList((ListModel)loadTypeList);
            ComboBoxAdapter comboBoxAdapterLoadType = new ComboBoxAdapter((ListModel)loadTypeSelection, this.selectionHolderLoadType);
            this.comboLoadType = new JComboBox();
            this.comboLoadType.setModel(comboBoxAdapterLoadType);
            this.comboLoadType.setRenderer(new LoadTypeCellRenderer());
            this.comboLoadType.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(SwitchPortTableModel.class, (String)"loadType") + ":", new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.comboLoadType).xy(3, row);
            row += 2;
        }
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        ConverterValueModel portStatusConverterModel = new ConverterValueModel((ValueModel)selectionHolderPortStatus, (BindingConverter)new PortStatusToStringConverter(SwitchPortStatus.class));
        JLabel statusLabel = WizardComponentFactory.createLabel((ValueModel)portStatusConverterModel);
        SelectionInList portStatusSelection = new SelectionInList((Object[])SwitchPortStatus.ON.getValues());
        ValueHolder portStatusHolder = new ValueHolder(selectionHolderPortStatus.getValue());
        ComboBoxAdapter comboBoxAdapterPortStatus = new ComboBoxAdapter((ListModel)portStatusSelection, (ValueModel)portStatusHolder);
        this.comboPortStatus = new JComboBox();
        this.comboPortStatus.setRenderer(new BidibStatusListRenderer(SwitchPortStatus.class));
        this.comboPortStatus.setModel(comboBoxAdapterPortStatus);
        SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)selectionHolderPortStatus.getValue()));
        LOGGER.debug("Set the opposite status in the port status selection: {}", (Object)oppositeStatus);
        this.comboPortStatus.setSelectedItem(oppositeStatus);
        this.btnPortStatus = new JButton(Resources.getString(SwitchPortTableModel.class, (String)"test"));
        this.btnPortStatus.addActionListener(arg_0 -> this.lambda$doCreateComponent$0((ValueModel)portStatusHolder, arg_0));
        Disposable disp = this.statusEventSubject.throttleLatest(80L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance(), true).subscribe(portStatus -> this.sendStatusToPort(port, portStatus));
        this.getCompDisp().add(disp);
        dialogBuilder.add(Resources.getString(SwitchPortTableModel.class, (String)"status") + ":", new Object[0]).xy(1, row);
        dialogBuilder.add((Component)statusLabel).xy(3, row);
        dialogBuilder.add((Component)this.comboPortStatus).xy(5, row);
        dialogBuilder.add((Component)this.btnPortStatus).xy(7, row);
        this.comboPortStatus.setEnabled(port.isEnabled());
        this.btnPortStatus.setEnabled(port.isEnabled());
        JPanel buttonPanel = this.createButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row += 2, 5);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogBuilder.build());
            AbstractPortEditorPanel.PortEditorPanelContainer panel2 = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel2);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.setPanel(feedbackBuilder.build());
        } else {
            this.setPanel(dialogBuilder.build());
        }
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        this.switchOffTimeConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        this.selectionHolderIoBehaviour.addValueChangeListener(evt -> this.triggerValidation());
        this.selectionHolderLoadType.addValueChangeListener(evt -> this.triggerValidation());
        this.enableComponents();
        return this.getPanel();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        super.propertyChanged(evt);
        SwingUtilities.invokeLater(() -> {
            try {
                switch (evt.getPropertyName()) {
                    case "status": 
                    case "portStatus": {
                        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
                        SwitchPortStatus status = (SwitchPortStatus)((SwitchPort)this.getOriginalPort()).getStatus();
                        LOGGER.info("Current status of original port: {}", (Object)status);
                        selectionHolderPortStatus.setValue((Object)status);
                        if (this.comboPortStatus == null) break;
                        SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)selectionHolderPortStatus.getValue()));
                        LOGGER.info("Set the opposite status in the port status selection: {}", (Object)oppositeStatus);
                        this.comboPortStatus.setSelectedItem(oppositeStatus);
                        break;
                    }
                    case "portConfigChanged": {
                        break;
                    }
                    case "portTypeChanged": {
                        LOGGER.info("The port type has changed: {}", evt.getNewValue());
                        this.enableComponents();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Update the status failed.", (Throwable)ex);
            }
        });
    }

    protected ValidationResult validate(SwitchPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.switchOffTimeConverterModel.getValue() == null && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_TICKS)) {
            support.addError("switchOffTime_key", "not_empty_for_write");
        }
        if (this.selectionHolderIoBehaviour.getValue() == null && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_SWITCH_CTRL)) {
            support.addError("ioBehaviour_key", "not_empty_for_write");
        }
        if (this.selectionHolderLoadType.getValue() == null && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_LOAD_TYPE)) {
            support.addError("loadType_key", "not_empty_for_write");
        }
        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    private void sendStatusToPort(SwitchPort port, SwitchPortStatus portStatus) {
        LOGGER.info("Send the new portStatus to the port: {}", (Object)portStatus);
        this.triggerValidation();
        SwitchPort switchPort = (SwitchPort)SwitchPort.builder().withStatus((BidibStatus)portStatus).withId(port.getId()).build();
        this.getValueCallback().accept(switchPort);
    }

    protected void doEnableComponents(SwitchPort port) {
        boolean enabled = port.isEnabled();
        this.portName.setEnabled(enabled);
        if (this.comboIoBehaviour != null) {
            this.comboIoBehaviour.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_SWITCH_CTRL));
        }
        if (this.comboLoadType != null) {
            this.comboLoadType.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_LOAD_TYPE));
        }
        if (this.switchOffTimeText != null) {
            this.switchOffTimeText.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_TICKS));
        }
        this.comboPortStatus.setEnabled(enabled);
        this.btnPortStatus.setEnabled(enabled);
    }

    private /* synthetic */ void lambda$doCreateComponent$0(ValueModel portStatusHolder, ActionEvent evt) {
        SwitchPortStatus portStatus = (SwitchPortStatus)portStatusHolder.getValue();
        LOGGER.info("The port status has been changed: {}", (Object)portStatus);
        this.statusEventSubject.onNext((Object)portStatus);
    }
}

