/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionTableModel
extends SimplePortTableModel<FeedbackPortStatus, PositionFeedbackPort, PortModelListener<PositionFeedbackPort>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionTableModel.class);
    private static final int COLUMNS = 8;
    private final Map<Port<?>, Integer> portIndexes = new HashMap();

    public FeedbackPositionTableModel() {
        this.setColumnIdentifiers((Object[])new String[8]);
    }

    public int getColumnPortInstance() {
        return 2;
    }

    public Class<?> getColumnClass(int column) {
        return PositionFeedbackPort.class;
    }

    public void setRowCount(int rowCount) {
        if (rowCount == 0) {
            this.portIndexes.clear();
        }
        super.setRowCount(rowCount);
    }

    public void addRows(List<PositionFeedbackPort> ports) {
        LOGGER.trace("Current ports: {}", ports);
        if (ports != null) {
            LinkedList<Object> rowData = new LinkedList<Object>();
            int index = 0;
            for (Port port : ports) {
                this.portIndexes.put(port, index++);
                rowData.add(port);
                if (index <= 0 || index % 8 != 0) continue;
                rowData.add("");
                this.addRow(rowData.toArray());
                rowData.clear();
            }
            if (rowData.size() > 0) {
                for (index = rowData.size(); index < 9; ++index) {
                    if (index > 0 && index % 8 == 0) {
                        rowData.add("");
                        this.addRow(rowData.toArray());
                        rowData.clear();
                        break;
                    }
                    rowData.add(null);
                }
            }
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setValueAt(Object value, int row, int column) {
        Object o = this.getValueAt(row, column);
        if (o instanceof PositionFeedbackPort) {
            PositionFeedbackPort port = (PositionFeedbackPort)o;
            LOGGER.debug("Set value, current port: {}, value: {}", (Object)port, value);
            if (value instanceof String) {
                port.setLabel((String)value);
                super.setValueAt((Object)port, row, column);
                this.fireLabelChanged((Port)port, port.getLabel());
            } else if (value instanceof PositionFeedbackPort) {
                super.setValueAt(value, row, column);
            }
        }
    }

    public void updatePort(Port<?> port) {
        if (port != null) {
            Integer index = (Integer)this.portIndexes.get(port);
            if (index != null) {
                int row = index / 8;
                int column = index % 8;
                this.setValueAt(port, row, column);
            } else {
                LOGGER.warn("Feedback port is not registered: {}", port);
            }
        }
    }

    public void notifyPortStatusChanged(PositionFeedbackPort port) {
    }

    public void notifyPortConfigChanged(PositionFeedbackPort port) {
    }

    public void validatePositions(List<PositionFeedbackPort> outdatedPorts) {
        for (PositionFeedbackPort port : outdatedPorts) {
            this.updatePort((Port)port);
        }
    }

    public void notifyPortLabelChanged(PositionFeedbackPort port) {
    }

    public void refreshRow(PositionFeedbackPort port, IntConsumer rowConsumer) {
    }
}

