/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.value.BindingConverter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class StringToNetBidibUniqueIdConverter
implements BindingConverter<Long, String> {
    private final byte vid;
    private final byte pidLow;
    private final byte pidHigh;

    public StringToNetBidibUniqueIdConverter(int vid, int pid) {
        this.vid = ByteUtils.getLowByte((int)vid);
        this.pidLow = ByteUtils.getLowByte((int)pid);
        this.pidHigh = ByteUtils.getHighByte((int)pid);
    }

    public String targetValue(Long sourceValue) {
        if (sourceValue != null) {
            String uniqueIdValue = Long.toString(sourceValue, 16);
            return StringUtils.leftPad((String)StringUtils.right((String)uniqueIdValue, (int)4), (int)4, (char)'0').toUpperCase();
        }
        return null;
    }

    public Long sourceValue(String targetValue) {
        if (targetValue != null) {
            Long value = Long.valueOf(StringUtils.leftPad((String)targetValue, (int)4, (char)'0'), 16);
            byte[] uniqueId = new byte[]{0, 0, this.vid, this.pidLow, this.pidHigh, 0, 0};
            long basicUniqueId = ByteUtils.convertUniqueIdToLong((byte[])uniqueId);
            value = basicUniqueId | value;
            return value;
        }
        return null;
    }
}

