/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view.excel;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.mvc.stepcontrol.view.excel.DataImportException;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ImportAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAspectReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelAspectReader.class);
    private static final Color EXCEL_COLOR_GREEN = new Color(0, 176, 80);
    private static final Color EXCEL_COLOR_RED = new Color(255, 0, 0);

    public List<ImportAspect> readAspects(InputStream excelFile) {
        LinkedList<ImportAspect> importAspects = new LinkedList<ImportAspect>();
        XSSFWorkbook wb = null;
        try {
            int rowNum;
            wb = new XSSFWorkbook(excelFile);
            Sheet firstSheet = wb.getSheetAt(0);
            LOGGER.info("First row num: {}", (Object)rowNum);
            for (rowNum = firstSheet.getFirstRowNum(); rowNum < 20; ++rowNum) {
                Row row = firstSheet.getRow(rowNum);
                if (row == null) {
                    LOGGER.info("Emtpy row: {}", (Object)rowNum);
                    continue;
                }
                short firstCellNum = row.getFirstCellNum();
                if (firstCellNum == -1) {
                    LOGGER.info("Emtpy row: {}", (Object)rowNum);
                    continue;
                }
                Cell firstCell = row.getCell((int)firstCellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                if (firstCell == null || !"Gleisanschluss".equals(firstCell.getStringCellValue())) continue;
                LOGGER.info("Found 'Gleisanschluss' in row: {}", (Object)rowNum);
                this.parseAspects(importAspects, firstSheet, ++rowNum, (int)firstCellNum);
                break;
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Import aspects from Excel file failed.", (Throwable)ex);
            throw new DataImportException("Import aspects from Excel file failed.", (Throwable)ex);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Close Excel workbook failed.", (Throwable)ex);
                }
            }
        }
        return importAspects;
    }

    private void parseAspects(List<ImportAspect> importAspects, Sheet firstSheet, int rowNumStart, int firstCellNum) {
        for (int rowNum = rowNumStart; rowNum < rowNumStart + 48; ++rowNum) {
            Row row = firstSheet.getRow(rowNum);
            Cell indexCell = row.getCell(firstCellNum, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
            Cell positionCell = row.getCell(firstCellNum + 1, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
            LOGGER.debug("Current cell, index: {}, position: {}", (Object)indexCell, (Object)positionCell);
            double index = indexCell.getNumericCellValue();
            double position = positionCell.getNumericCellValue();
            int intIndex = (int)index;
            int roundedPos = (int)Math.round(position);
            LOGGER.info("Current cell values, index: {}, position: {}", (Object)intIndex, (Object)roundedPos);
            if (indexCell.getCellStyle() == null || indexCell.getCellStyle().getFillBackgroundColorColor() == null) continue;
            XSSFCellStyle cellStyle = (XSSFCellStyle)indexCell.getCellStyle();
            XSSFColor bgColor = cellStyle.getFillForegroundXSSFColor();
            LOGGER.debug("Current bgColor: {}, val: {}", (Object)bgColor, (Object)ByteUtils.bytesToHex((byte[])bgColor.getRGB()));
            if ((EXCEL_COLOR_GREEN.getRGB() & 0xFFFFFF) == ByteUtils.getRGB((byte[])bgColor.getRGB())) {
                LOGGER.info("Current color is green.");
                importAspects.add(new ImportAspect(intIndex, roundedPos, false));
                continue;
            }
            if ((EXCEL_COLOR_RED.getRGB() & 0xFFFFFF) != ByteUtils.getRGB((byte[])bgColor.getRGB())) continue;
            LOGGER.info("Current color is red.");
            importAspects.add(new ImportAspect(intIndex, roundedPos, true));
        }
    }
}

