/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareUtils.class);
    private static final String REGEX_FILENAME = "(\\-|\\.)[0-9]+";
    private static final String REGEX_CV_FILENAME = "BiDiBCV-([0-9]{1,3})-([0-9]{1,3})(-.+)?\\.xml";

    public static boolean hasVersionInFilename(String filename) {
        Matcher m = Pattern.compile(REGEX_FILENAME).matcher(filename);
        int start = m.regionStart();
        int end = m.regionEnd();
        LOGGER.info("Region start: {}, end: {}", (Object)start, (Object)end);
        int totalFound = 0;
        while (m.find()) {
            String text;
            LOGGER.info("groupCount: {}", (Object)m.groupCount());
            if (m.groupCount() > 0 && m.group(1) != null) {
                text = m.group(0);
                LOGGER.info("1. Found text: [{}]", (Object)text);
                ++totalFound;
                continue;
            }
            text = m.group(0);
            LOGGER.info("Plain [{}]", (Object)text);
        }
        return totalFound > 2;
    }

    public static String getVidAndPid(String filename) {
        Matcher m = Pattern.compile(REGEX_CV_FILENAME).matcher(filename);
        if (m.matches() && m.groupCount() >= 2) {
            String vid = m.group(1);
            String pid = m.group(2);
            return vid + "-" + pid;
        }
        return null;
    }

    public static boolean hasVersionInDefaultLablesFilename(String filename) {
        Matcher m = Pattern.compile(REGEX_FILENAME).matcher(filename);
        int start = m.regionStart();
        int end = m.regionEnd();
        LOGGER.info("Region start: {}, end: {}", (Object)start, (Object)end);
        int totalFound = 0;
        while (m.find()) {
            String text;
            LOGGER.info("groupCount: {}", (Object)m.groupCount());
            if (m.groupCount() > 0 && m.group(1) != null) {
                text = m.group(0);
                LOGGER.info("1. Found text: [{}]", (Object)text);
                ++totalFound;
                continue;
            }
            text = m.group(0);
            LOGGER.info("Plain [{}]", (Object)text);
        }
        return totalFound > 2;
    }
}

