/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.utils;

import com.jidesoft.grid.TreeTableModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.Accessories;
import org.bidib.jbidibc.core.schema.bidib2.Accessory;
import org.bidib.jbidibc.core.schema.bidib2.Aspect;
import org.bidib.jbidibc.core.schema.bidib2.Aspects;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.bidib2.ConfigurationVariables;
import org.bidib.jbidibc.core.schema.bidib2.Feature;
import org.bidib.jbidibc.core.schema.bidib2.Features;
import org.bidib.jbidibc.core.schema.bidib2.FeedbackPorts;
import org.bidib.jbidibc.core.schema.bidib2.Flags;
import org.bidib.jbidibc.core.schema.bidib2.HourExtension;
import org.bidib.jbidibc.core.schema.bidib2.IOInputBehaviour;
import org.bidib.jbidibc.core.schema.bidib2.IOSwitchBehaviour;
import org.bidib.jbidibc.core.schema.bidib2.InputKey;
import org.bidib.jbidibc.core.schema.bidib2.LoadType;
import org.bidib.jbidibc.core.schema.bidib2.Macro;
import org.bidib.jbidibc.core.schema.bidib2.MacroParameter;
import org.bidib.jbidibc.core.schema.bidib2.MacroParameterClockStart;
import org.bidib.jbidibc.core.schema.bidib2.MacroParameterRepeat;
import org.bidib.jbidibc.core.schema.bidib2.MacroParameterSlowdown;
import org.bidib.jbidibc.core.schema.bidib2.MacroParameters;
import org.bidib.jbidibc.core.schema.bidib2.MacroPoint;
import org.bidib.jbidibc.core.schema.bidib2.MacroPoints;
import org.bidib.jbidibc.core.schema.bidib2.Macros;
import org.bidib.jbidibc.core.schema.bidib2.MinuteExtension;
import org.bidib.jbidibc.core.schema.bidib2.Nodes;
import org.bidib.jbidibc.core.schema.bidib2.OutputBacklight;
import org.bidib.jbidibc.core.schema.bidib2.OutputLight;
import org.bidib.jbidibc.core.schema.bidib2.OutputServo;
import org.bidib.jbidibc.core.schema.bidib2.OutputSwitch;
import org.bidib.jbidibc.core.schema.bidib2.OutputSwitchPair;
import org.bidib.jbidibc.core.schema.bidib2.Ports;
import org.bidib.jbidibc.core.schema.bidib2.Weekday;
import org.bidib.jbidibc.core.schema.bidib2.WeekdayExtension;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.jbidibc.exchange.vendorcv.ModeType;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.MacroRepeatDay;
import org.bidib.wizard.api.model.MacroRepeatTime;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.TimeStartCondition;
import org.bidib.wizard.api.model.function.EmptyFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.AccessoryListUtils;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.utils.FlagListUtils;
import org.bidib.wizard.common.utils.MacroListUtils;
import org.bidib.wizard.core.labels.AccessoryLabelUtils;
import org.bidib.wizard.core.labels.BidibLabelUtils;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.utils.FunctionConversionFactory;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NodeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeUtils.class);
    public static final String IMPORT_ERRORS = "importErrors";

    public static NodeInterface findNodeByUuid(Iterable<NodeInterface> nodes, long uuid) {
        NodeInterface node = (NodeInterface)IterableUtils.find(nodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return node;
    }

    public static String prepareLabel(NodeInterface node) {
        String nodeLabel = null;
        if (node != null) {
            String userString;
            if (node.getNode().hasStoredStrings() && StringUtils.isNotBlank((CharSequence)(userString = node.getNode().getStoredString(1)))) {
                String label = node.toString();
                nodeLabel = label.startsWith(userString) ? label : userString;
            }
            if (StringUtils.isBlank(nodeLabel)) {
                nodeLabel = node.toString();
            }
        }
        return nodeLabel;
    }

    public static NodeInterface configureFromBiDiB(String connectionId, NodeService nodeService, SwitchingNodeService switchingNodeService, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, NodeInterface node, Map<String, Object> importParams, BiDiB bidib, WizardLabelWrapper wizardLabelWrapper, boolean restoreCVs, boolean restoreFeatures, boolean restoreNodeString, boolean restoreMacroContent, boolean restoreAccessoryContent) {
        if (bidib == null) {
            throw new IllegalArgumentException("A bidib must be provided.");
        }
        Nodes nodes = bidib.getNodes();
        if (nodes != null && CollectionUtils.isNotEmpty((Collection)nodes.getNode())) {
            List schemaNodes = nodes.getNode();
            for (org.bidib.jbidibc.core.schema.bidib2.Node schemaNode : schemaNodes) {
                NodeLabels nodeLabels = wizardLabelWrapper.getWizardLabelFactory().loadLabels(Long.valueOf(node.getUniqueId()), new String[0]);
                if (restoreNodeString && StringUtils.isNotBlank((CharSequence)schemaNode.getUserName())) {
                    LOGGER.info("Restore the userName of the node: {}", (Object)schemaNode.getUserName());
                    String label = schemaNode.getUserName();
                    node.setLabel(label);
                    node.getNode().setStoredString(1, label);
                    nodeLabels.getNodeLabel().setUserName(label);
                    wizardLabelWrapper.saveNodeLabels(Long.valueOf(node.getUniqueId()));
                }
                Node coreNode = node.getNode();
                if (restoreCVs && schemaNode.getConfigurationVariables() != null && CollectionUtils.isNotEmpty((Collection)schemaNode.getConfigurationVariables().getConfigurationVariable())) {
                    List schemaCvs = schemaNode.getConfigurationVariables().getConfigurationVariable();
                    CollectionUtils.filter((Iterable)schemaCvs, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                    LOGGER.info("filtered CVs: {}", (Object)schemaCvs);
                    CvContainer cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(node.getUniqueId());
                    if (cvContainer != null) {
                        Map map = cvContainer.getCvNumberToNodeMap();
                        for (ConfigurationVariable cv : schemaCvs) {
                            CvNode cvNode = (CvNode)map.get(cv.getName());
                            if (cvNode == null || ModeType.RO.equals((Object)cvNode.getCV().getMode()) || ModeType.H.equals((Object)cvNode.getCV().getMode())) continue;
                            try {
                                cvNode.setNewValue((Object)cv.getValue());
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Set the CV value failed: {}", (Object)cv, (Object)ex);
                                NodeUtils.addImportError(importParams, (String)("Set the CV value failed: " + cv));
                            }
                        }
                        CvDefinitionTreeTableModel treeModel = cvContainer.getCvTreeModel();
                        if (treeModel != null) {
                            boolean hasPendingCVChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)treeModel);
                            LOGGER.info("After import of CV values from file, hasPendingCVChanges: {}", (Object)hasPendingCVChanges);
                        }
                    }
                    importParams.put("cvValuesRestored", Boolean.TRUE);
                }
                if (restoreFeatures && schemaNode.getFeatures() != null && CollectionUtils.isNotEmpty((Collection)schemaNode.getFeatures().getFeature())) {
                    List schemaFeatures = schemaNode.getFeatures().getFeature();
                    List features = coreNode.getFeatures();
                    for (Feature schemaFeature : schemaFeatures) {
                        org.bidib.jbidibc.messages.Feature feature = org.bidib.jbidibc.messages.Feature.findFeature((Collection)features, (int)schemaFeature.getFeatureCodeId());
                        if (feature != null) {
                            feature.setValue(schemaFeature.getValue());
                            continue;
                        }
                        LOGGER.warn("Skip set unknown feature: {}", (Object)schemaFeature);
                    }
                    importParams.put("featuresRestored", Boolean.TRUE);
                }
                if (schemaNode.getFeedbackPorts() != null && CollectionUtils.isNotEmpty((Collection)schemaNode.getFeedbackPorts().getFeedbackPort())) {
                    LOGGER.info("Restore the feedback ports.");
                    ArrayList feedbackPorts = new ArrayList(node.getFeedbackPorts());
                    List schemaFeedbackPorts = schemaNode.getFeedbackPorts().getFeedbackPort();
                    for (Object schemaFeedbackPort : schemaFeedbackPorts) {
                        FeedbackPort feedbackPort = (FeedbackPort)PortListUtils.findPortByPortNumber(feedbackPorts, (int)schemaFeedbackPort.getNumber());
                        if (feedbackPort == null) continue;
                        feedbackPort.setLabel(schemaFeedbackPort.getName());
                        BidibLabelUtils.replaceFeedbackPortLabel((NodeLabels)nodeLabels, (int)feedbackPort.getId(), (String)feedbackPort.getLabel());
                    }
                    node.setFeedbackPorts(feedbackPorts);
                }
                if (CollectionUtils.isNotEmpty((Collection)schemaNode.getPorts().getPort())) {
                    List schemaOutputSwitchPairPorts;
                    List schemaOutputSwitchPorts;
                    List schemaSoundPorts;
                    List schemaServoPorts;
                    List schemaMotorPorts;
                    List schemaLightPorts;
                    List schemaInputPorts;
                    LOGGER.info("Restore the ports.");
                    List schemaPorts = schemaNode.getPorts().getPort();
                    List schemaBacklightPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.BACKLIGHTPORT);
                    if (CollectionUtils.isNotEmpty((Collection)schemaBacklightPorts)) {
                        Object schemaFeedbackPort;
                        ArrayList backlightPorts = new ArrayList(node.getBacklightPorts());
                        schemaFeedbackPort = schemaBacklightPorts.iterator();
                        while (schemaFeedbackPort.hasNext()) {
                            OutputBacklight schemaBacklight = (OutputBacklight)schemaFeedbackPort.next();
                            BacklightPort backlightPort = (BacklightPort)PortListUtils.findPortByPortNumber(backlightPorts, (int)schemaBacklight.getNumber());
                            if (backlightPort != null) {
                                if (schemaBacklight.getDimmingDownSpeed() != null) {
                                    backlightPort.setDimSlopeDown(schemaBacklight.getDimmingDownSpeed().intValue());
                                }
                                if (schemaBacklight.getDimmingUpSpeed() != null) {
                                    backlightPort.setDimSlopeUp(schemaBacklight.getDimmingUpSpeed().intValue());
                                }
                                if (schemaBacklight.getDmxChannel() != null) {
                                    backlightPort.setDmxMapping(schemaBacklight.getDmxChannel());
                                }
                                backlightPort.setLabel(schemaBacklight.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.backlightPort, (int)backlightPort.getId(), (String)backlightPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No backlight port available for schemaBacklight: {}", (Object)schemaBacklight);
                        }
                        node.setBacklightPorts(backlightPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaInputPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.INPUTPORT)))) {
                        ArrayList inputPorts = new ArrayList(node.getInputPorts());
                        for (Object schemaInput : schemaInputPorts) {
                            InputPort inputPort = (InputPort)PortListUtils.findPortByPortNumber(inputPorts, (int)schemaInput.getNumber());
                            if (inputPort != null && !schemaInput.isDisabled().booleanValue()) {
                                if (inputPort.getGenericPort() != null && !inputPort.getGenericPort().isMatchingPortType(LcOutputType.INPUTPORT)) {
                                    NodeUtils.setCurrentPortType((GenericPort)inputPort.getGenericPort(), (LcOutputType)LcOutputType.INPUTPORT);
                                }
                                inputPort.setEnabled(schemaInput.isDisabled() == false);
                                if (schemaInput.getSwitchOffTime() != null) {
                                    inputPort.setSwitchOffTime(schemaInput.getSwitchOffTime());
                                }
                                if (schemaInput.getIoInputBehaviour() != null) {
                                    inputPort.setInputBehaviour(IoBehaviourInputEnum.valueOf((String)schemaInput.getIoInputBehaviour().name()));
                                }
                                inputPort.setLabel(schemaInput.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.inputPort, (int)inputPort.getId(), (String)inputPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No input port available for schemaInput: {}", schemaInput);
                        }
                        node.setInputPorts(inputPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaLightPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.LIGHTPORT)))) {
                        Object schemaInput;
                        ArrayList lightPorts = new ArrayList(node.getLightPorts());
                        schemaInput = schemaLightPorts.iterator();
                        while (schemaInput.hasNext()) {
                            OutputLight schemaLight = (OutputLight)schemaInput.next();
                            LightPort lightPort = (LightPort)PortListUtils.findPortByPortNumber(lightPorts, (int)schemaLight.getNumber());
                            if (lightPort != null) {
                                if (schemaLight.getBrightnessOff() != null) {
                                    lightPort.setPwmMin(schemaLight.getBrightnessOff().intValue());
                                }
                                if (schemaLight.getBrightnessOn() != null) {
                                    lightPort.setPwmMax(schemaLight.getBrightnessOn().intValue());
                                }
                                if (schemaLight.getDimmingDownSpeed() != null) {
                                    lightPort.setDimMin(schemaLight.getDimmingDownSpeed().intValue());
                                }
                                if (schemaLight.getDimmingUpSpeed() != null) {
                                    lightPort.setDimMax(schemaLight.getDimmingUpSpeed().intValue());
                                }
                                if (schemaLight.getRgbValue() != null) {
                                    lightPort.setRgbValue(schemaLight.getRgbValue());
                                }
                                if (schemaLight.getTransitionTime() != null) {
                                    lightPort.setTransitionTime(schemaLight.getTransitionTime());
                                }
                                lightPort.setLabel(schemaLight.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.lightPort, (int)lightPort.getId(), (String)lightPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No light port available for schemaLight: {}", (Object)schemaLight);
                        }
                        node.setLightPorts(lightPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaMotorPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.MOTORPORT)))) {
                        ArrayList motorPorts = new ArrayList(node.getMotorPorts());
                        for (Object schemaMotor : schemaMotorPorts) {
                            MotorPort motorPort = (MotorPort)PortListUtils.findPortByPortNumber(motorPorts, (int)schemaMotor.getNumber());
                            if (motorPort != null) {
                                motorPort.setLabel(schemaMotor.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.motorPort, (int)motorPort.getId(), (String)motorPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No motor port available for schemaMotor: {}", schemaMotor);
                        }
                        node.setMotorPorts(motorPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaServoPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.SERVOPORT)))) {
                        Object schemaMotor;
                        ArrayList servoPorts = new ArrayList(node.getServoPorts());
                        schemaMotor = schemaServoPorts.iterator();
                        while (schemaMotor.hasNext()) {
                            OutputServo schemaServo = (OutputServo)schemaMotor.next();
                            ServoPort servoPort = (ServoPort)PortListUtils.findPortByPortNumber(servoPorts, (int)schemaServo.getNumber());
                            if (servoPort != null) {
                                if (schemaServo.getLowerLimit() != null) {
                                    servoPort.setTrimDown(schemaServo.getLowerLimit().intValue());
                                }
                                if (schemaServo.getUpperLimit() != null) {
                                    servoPort.setTrimUp(schemaServo.getUpperLimit().intValue());
                                }
                                if (schemaServo.getMovingTime() != null) {
                                    servoPort.setSpeed(schemaServo.getMovingTime().intValue());
                                }
                                servoPort.setLabel(schemaServo.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.servoPort, (int)servoPort.getId(), (String)servoPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No servo port available for schemaServo: {}", (Object)schemaServo);
                        }
                        node.setServoPorts(servoPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaSoundPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.SOUNDPORT)))) {
                        ArrayList soundPorts = new ArrayList(node.getSoundPorts());
                        for (Object schemaSound : schemaSoundPorts) {
                            SoundPort soundPort = (SoundPort)PortListUtils.findPortByPortNumber(soundPorts, (int)schemaSound.getNumber());
                            if (soundPort != null) {
                                soundPort.setLabel(schemaSound.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.soundPort, (int)soundPort.getId(), (String)soundPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No sound port available for schemaSound: {}", schemaSound);
                        }
                        node.setSoundPorts(soundPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaOutputSwitchPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.SWITCHPORT)))) {
                        Object schemaSound;
                        ArrayList switchPorts = new ArrayList(node.getSwitchPorts());
                        schemaSound = schemaOutputSwitchPorts.iterator();
                        while (schemaSound.hasNext()) {
                            OutputSwitch schemaOutputSwitch = (OutputSwitch)schemaSound.next();
                            SwitchPort switchPort = (SwitchPort)PortListUtils.findPortByPortNumber(switchPorts, (int)schemaOutputSwitch.getNumber());
                            if (switchPort != null && !schemaOutputSwitch.isDisabled().booleanValue()) {
                                if (switchPort.getGenericPort() != null && !switchPort.getGenericPort().isMatchingPortType(LcOutputType.SWITCHPORT)) {
                                    NodeUtils.setCurrentPortType((GenericPort)switchPort.getGenericPort(), (LcOutputType)LcOutputType.SWITCHPORT);
                                }
                                switchPort.setEnabled(schemaOutputSwitch.isDisabled() == false);
                                if (schemaOutputSwitch.getSwitchOffTime() != null) {
                                    switchPort.setSwitchOffTime(schemaOutputSwitch.getSwitchOffTime());
                                }
                                if (schemaOutputSwitch.getIoSwitchBehaviour() != null) {
                                    switchPort.setOutputBehaviour(IoBehaviourSwitchEnum.valueOf((String)schemaOutputSwitch.getIoSwitchBehaviour().name()));
                                }
                                if (schemaOutputSwitch.getLoadType() != null) {
                                    switchPort.setLoadType(LoadTypeEnum.valueOf((String)schemaOutputSwitch.getLoadType().name()));
                                }
                                switchPort.setLabel(schemaOutputSwitch.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.switchPort, (int)switchPort.getId(), (String)switchPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No switch port available for schemaOutputSwitch: {}", (Object)schemaOutputSwitch);
                        }
                        node.setSwitchPorts(switchPorts);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(schemaOutputSwitchPairPorts = BidibFactory.getPortsOfType((List)schemaPorts, (LcOutputType)LcOutputType.SWITCHPAIRPORT)))) {
                        ArrayList switchPairPorts = new ArrayList(node.getSwitchPairPorts());
                        for (OutputSwitchPair schemaOutputSwitchPair : schemaOutputSwitchPairPorts) {
                            SwitchPairPort switchPairPort = (SwitchPairPort)PortListUtils.findPortByPortNumber(switchPairPorts, (int)schemaOutputSwitchPair.getNumber());
                            if (switchPairPort != null && !schemaOutputSwitchPair.isDisabled().booleanValue()) {
                                if (switchPairPort.getGenericPort() != null && !switchPairPort.getGenericPort().isMatchingPortType(LcOutputType.SWITCHPAIRPORT)) {
                                    NodeUtils.setCurrentPortType((GenericPort)switchPairPort.getGenericPort(), (LcOutputType)LcOutputType.SWITCHPAIRPORT);
                                }
                                switchPairPort.setEnabled(schemaOutputSwitchPair.isDisabled() == false);
                                if (schemaOutputSwitchPair.getSwitchOffTime() != null) {
                                    switchPairPort.setSwitchOffTime(schemaOutputSwitchPair.getSwitchOffTime());
                                }
                                if (schemaOutputSwitchPair.getLoadType() != null) {
                                    switchPairPort.setLoadType(LoadTypeEnum.valueOf((String)schemaOutputSwitchPair.getLoadType().name()));
                                }
                                switchPairPort.setLabel(schemaOutputSwitchPair.getName());
                                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.switchPairPort, (int)switchPairPort.getId(), (String)switchPairPort.getLabel());
                                continue;
                            }
                            LOGGER.warn("No switchPair port available for schemaOutputSwitchPair: {}", (Object)schemaOutputSwitchPair);
                        }
                        node.setSwitchPairPorts(switchPairPorts);
                    }
                }
                if (schemaNode.getFlags() != null && CollectionUtils.isNotEmpty((Collection)schemaNode.getFlags().getFlag())) {
                    LOGGER.info("Restore the flag names.");
                    ArrayList flags = new ArrayList(node.getFlags());
                    for (org.bidib.jbidibc.core.schema.bidib2.Flag schemaFlag : schemaNode.getFlags().getFlag()) {
                        Flag flag = FlagListUtils.findFlagByNumber(flags, (int)schemaFlag.getNumber());
                        if (flag == null) continue;
                        flag.setLabel(schemaFlag.getName());
                        BidibLabelUtils.replaceFlagLabel((NodeLabels)nodeLabels, (int)flag.getId(), (String)flag.getLabel());
                    }
                    node.setFlags(flags);
                }
                if (restoreMacroContent && schemaNode.getMacros() != null && CollectionUtils.isNotEmpty((Collection)schemaNode.getMacros().getMacro())) {
                    LOGGER.info("Restore the macro content.");
                    int maxMacroLength = org.bidib.jbidibc.messages.Feature.getIntFeatureValue((Collection)node.getNode().getFeatures(), (int)63);
                    ArrayList macros = new ArrayList(node.getMacros());
                    List schemaMacros = schemaNode.getMacros().getMacro();
                    for (Macro schemaMacro : schemaMacros) {
                        MacroParameterClockStart clockStart;
                        MacroParameterRepeat repeat;
                        org.bidib.wizard.api.model.Macro macro = MacroListUtils.findMacroByMacroNumber(macros, (int)schemaMacro.getNumber());
                        if (macro == null) {
                            LOGGER.warn("No macro available on node with macro number: {}. The macro is not imported!", (Object)schemaMacro.getNumber());
                            NodeUtils.addImportError(importParams, (String)("No macro available on node with macro number: " + schemaMacro.getNumber()));
                            continue;
                        }
                        macro.initialize();
                        macro.setFunctionSize(maxMacroLength);
                        MacroParameterSlowdown slowdown = (MacroParameterSlowdown)NodeUtils.findMacroParameter((List)schemaMacro.getMacroParameters().getMacroParameter(), MacroParameterSlowdown.class);
                        if (slowdown != null) {
                            macro.setSpeed(slowdown.getSpeed());
                        }
                        if ((repeat = (MacroParameterRepeat)NodeUtils.findMacroParameter((List)schemaMacro.getMacroParameters().getMacroParameter(), MacroParameterRepeat.class)) != null) {
                            macro.setCycles(repeat.getRepetitions());
                        }
                        if ((clockStart = (MacroParameterClockStart)NodeUtils.findMacroParameter((List)schemaMacro.getMacroParameters().getMacroParameter(), MacroParameterClockStart.class)) != null) {
                            LinkedList<TimeStartCondition> startConditions = new LinkedList<TimeStartCondition>();
                            if (clockStart.isIsEnabled()) {
                                TimeStartCondition timeStartCondition = new TimeStartCondition();
                                LOGGER.info("Apply start condition: {}", (Object)clockStart);
                                if (StringUtils.isNotBlank((CharSequence)clockStart.getPeriodicalRepetition())) {
                                    try {
                                        MinuteExtension minuteExtension = MinuteExtension.fromValue((String)clockStart.getPeriodicalRepetition());
                                        switch (3.$SwitchMap$org$bidib$jbidibc$core$schema$bidib2$MinuteExtension[minuteExtension.ordinal()]) {
                                            case 1: {
                                                break;
                                            }
                                            case 2: {
                                                timeStartCondition.setRepeatTime(MacroRepeatTime.MINUTELY);
                                                timeStartCondition.setMinutely(true);
                                                break;
                                            }
                                            case 3: {
                                                timeStartCondition.setRepeatTime(MacroRepeatTime.QUARTER_HOURLY);
                                                break;
                                            }
                                            case 4: {
                                                timeStartCondition.setRepeatTime(MacroRepeatTime.HALF_HOURLY);
                                                break;
                                            }
                                            default: {
                                                LOGGER.warn("Unsupported repeat period: {}", (Object)minuteExtension);
                                                break;
                                            }
                                        }
                                    }
                                    catch (IllegalArgumentException ex) {
                                        try {
                                            HourExtension hourExtension = HourExtension.fromValue((String)clockStart.getPeriodicalRepetition());
                                            switch (3.$SwitchMap$org$bidib$jbidibc$core$schema$bidib2$HourExtension[hourExtension.ordinal()]) {
                                                case 1: {
                                                    timeStartCondition.setRepeatTime(MacroRepeatTime.HOURLY);
                                                    timeStartCondition.setHourly(true);
                                                    break;
                                                }
                                                case 2: {
                                                    timeStartCondition.setRepeatTime(MacroRepeatTime.WORKING_HOURLY);
                                                    timeStartCondition.setHourly(true);
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.warn("Unsupported repeat period: {}", (Object)hourExtension);
                                                    break;
                                                }
                                            }
                                        }
                                        catch (IllegalArgumentException ex1) {
                                            LOGGER.warn("Set the repeat period failed: {}", (Object)clockStart.getPeriodicalRepetition(), (Object)ex1);
                                            NodeUtils.addImportError(importParams, (String)("Set the repeat period failed for macro num: " + macro.getId() + ",  repeat: " + clockStart.getPeriodicalRepetition()));
                                        }
                                    }
                                }
                                if (StringUtils.isNotBlank((CharSequence)clockStart.getWeekday())) {
                                    try {
                                        WeekdayExtension weekdayExtension = WeekdayExtension.fromValue((String)clockStart.getWeekday());
                                        switch (3.$SwitchMap$org$bidib$jbidibc$core$schema$bidib2$WeekdayExtension[weekdayExtension.ordinal()]) {
                                            case 1: {
                                                timeStartCondition.setRepeatDay(MacroRepeatDay.ALL);
                                                break;
                                            }
                                            default: {
                                                LOGGER.warn("Unsupported weekdayExtension: {}", (Object)weekdayExtension);
                                                break;
                                            }
                                        }
                                    }
                                    catch (IllegalArgumentException ex) {
                                        try {
                                            Weekday weekday = Weekday.fromValue((String)clockStart.getWeekday());
                                            switch (3.$SwitchMap$org$bidib$jbidibc$core$schema$bidib2$Weekday[weekday.ordinal()]) {
                                                case 1: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.MONDAY);
                                                    break;
                                                }
                                                case 2: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.TUESDAY);
                                                    break;
                                                }
                                                case 3: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.WEDNESDAY);
                                                    break;
                                                }
                                                case 4: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.THURSDAY);
                                                    break;
                                                }
                                                case 5: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.FRIDAY);
                                                    break;
                                                }
                                                case 6: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.SATURDAY);
                                                    break;
                                                }
                                                case 7: {
                                                    timeStartCondition.setRepeatDay(MacroRepeatDay.SUNDAY);
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.warn("Unsupported weekday: {}", (Object)weekday);
                                                    break;
                                                }
                                            }
                                        }
                                        catch (IllegalArgumentException ex1) {
                                            LOGGER.warn("Set the repeat weekday failed: {}", (Object)clockStart.getWeekday(), (Object)ex1);
                                            NodeUtils.addImportError(importParams, (String)("Set the repeat weekday failed for macro num: " + macro.getId() + ",  weekday: " + clockStart.getWeekday()));
                                        }
                                    }
                                }
                                Calendar cal = GregorianCalendar.getInstance();
                                cal.set(11, clockStart.getHour());
                                cal.set(12, clockStart.getMinute());
                                timeStartCondition.setTime(cal);
                                startConditions.add(timeStartCondition);
                                macro.setStartConditions(startConditions);
                            } else {
                                macro.setStartConditions(startConditions);
                            }
                        }
                        if (schemaMacro.getMacroPoints() != null && CollectionUtils.isNotEmpty((Collection)schemaMacro.getMacroPoints().getMacroPoint())) {
                            FunctionConversionFactory functionConversionFactory = new FunctionConversionFactory();
                            ArrayList<Object> functions = new ArrayList<Object>();
                            for (MacroPoint schemaMacroPoint : schemaMacro.getMacroPoints().getMacroPoint()) {
                                Function function = functionConversionFactory.convert(schemaMacroPoint, node);
                                if (function != null) {
                                    functions.add(function);
                                    continue;
                                }
                                LOGGER.warn("Conver macroPoint to function failed: {}", (Object)schemaMacroPoint);
                                functions.add(new EmptyFunction());
                            }
                            LOGGER.info("Set the functions: {}", functions);
                            macro.setFunctions(functions);
                        }
                        macro.setLabel(schemaMacro.getName());
                        BidibLabelUtils.replaceMacroLabel((NodeLabels)nodeLabels, (int)macro.getId(), (String)macro.getLabel());
                        macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
                    }
                    node.setMacros(macros);
                    LOGGER.info("Restore the macro content has finished.");
                }
                if (!restoreAccessoryContent || schemaNode.getAccessories() == null || !CollectionUtils.isNotEmpty((Collection)schemaNode.getAccessories().getAccessory())) continue;
                LOGGER.info("Restore the accessory content.");
                int maxAccessoryLength = org.bidib.jbidibc.messages.Feature.getIntFeatureValue((Collection)node.getNode().getFeatures(), (int)42);
                ArrayList accessories = new ArrayList(node.getAccessories());
                List schemaAccessories = schemaNode.getAccessories().getAccessory();
                for (Accessory schemaAccessory : schemaAccessories) {
                    org.bidib.wizard.api.model.Accessory accessory = AccessoryListUtils.findAccessoryByAccessoryNumber(accessories, (int)schemaAccessory.getNumber());
                    if (accessory != null) {
                        accessory.initialize();
                        accessory.setMaximumMacroMappedAspects(maxAccessoryLength);
                        accessory.setLabel(schemaAccessory.getName());
                        AccessoryLabelUtils.replaceAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (String)schemaAccessory.getName());
                        if (schemaAccessory.getAspects() != null && CollectionUtils.isNotEmpty((Collection)schemaAccessory.getAspects().getAspect())) {
                            ArrayList<MacroRef> aspects = new ArrayList<MacroRef>();
                            int aspectNumber = 0;
                            for (Aspect schemaAspect : schemaAccessory.getAspects().getAspect()) {
                                MacroRef aspect = new MacroRef();
                                aspect.setId(schemaAspect.getMacroNumber());
                                aspects.add(aspect);
                                String aspectName = schemaAspect.getName();
                                AccessoryLabelUtils.replaceAspectLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (int)aspectNumber, (String)aspectName);
                                ++aspectNumber;
                            }
                            accessory.setAspects(aspects);
                        } else {
                            LOGGER.info("No aspects in accessory: {}", (Object)schemaAccessory);
                        }
                        accessory.setStartupState(schemaAccessory.getStartupState());
                        continue;
                    }
                    LOGGER.info("No matching accessory found for schemaAccessory: {}", (Object)schemaAccessory);
                }
                LOGGER.info("Set the accessories: {}", accessories);
                node.setAccessories(accessories);
                importParams.put("macroAndAccessoriesRestored", Boolean.TRUE);
                LOGGER.info("Restore the accessories has finished.");
            }
        }
        return node;
    }

    public static void setCurrentPortType(GenericPort genericPort, LcOutputType portType) {
        Map portConfigX = genericPort.getPortConfig();
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)portConfigX.get((byte)-127);
        ReconfigPortConfigValue newReconfig = new ReconfigPortConfigValue(ByteUtils.getInt((byte)portType.getType()), reconfig.getPortMap());
        LOGGER.info("Set the new BIDIB_PCFG_RECONFIG: {}", (Object)newReconfig);
        portConfigX.put((byte)-127, newReconfig);
        genericPort.setPortConfigX(portConfigX);
        genericPort.getKnownPortConfigKeys().add((byte)-127);
    }

    public static void addImportError(Map<String, Object> params, String message) {
        LinkedList<String> saveErrors = (LinkedList<String>)params.get("importErrors");
        if (saveErrors == null) {
            saveErrors = new LinkedList<String>();
            params.put("importErrors", saveErrors);
        }
        saveErrors.add(message);
    }

    private static <T extends MacroParameter> T findMacroParameter(List<MacroParameter> macroParameters, Class<?> paramClazz) {
        for (MacroParameter param : macroParameters) {
            if (!paramClazz.isInstance(param)) continue;
            return (T)param;
        }
        return null;
    }

    public static BiDiB convertToBiDiB(NodeInterface node, Map<String, CvNode> cvNumberToNodeMap, String lang, boolean skipCvValues, WizardLabelWrapper wizardLabelWrapper) {
        List macros;
        List switchPairPorts;
        List switchPorts;
        List servoPorts;
        List lightPorts;
        List backlightPorts;
        List inputPorts;
        LOGGER.info("Convert node to BiDiB: {}", (Object)node);
        if (node == null) {
            throw new IllegalArgumentException("A node must be provided.");
        }
        NodeLabels nodeLabels = wizardLabelWrapper.getWizardLabelFactory().loadLabels(Long.valueOf(node.getUniqueId()), new String[0]);
        Node coreNode = node.getNode();
        long uniqueId = coreNode.getUniqueId();
        BiDiB bidib = new BiDiB();
        bidib.withSchemaVersion("1.0");
        org.bidib.jbidibc.core.schema.bidib2.Node schemaNode = new org.bidib.jbidibc.core.schema.bidib2.Node();
        schemaNode.withUserName(coreNode.getStoredString(1)).withProductName(coreNode.getStoredString(0)).withManufacturerId(Integer.valueOf(org.bidib.jbidibc.messages.utils.NodeUtils.getVendorId((long)uniqueId))).withProductId(Integer.valueOf(org.bidib.jbidibc.messages.utils.NodeUtils.getPid((long)uniqueId, (int)coreNode.getRelevantPidBits()))).withUniqueId(uniqueId).withFirmwareRelease(coreNode.getSoftwareVersion().toString()).withProtocol(coreNode.getProtocolVersion().toString());
        List nodes = bidib.withNodes(new Nodes()).getNodes().getNode();
        nodes.add(schemaNode);
        List features = coreNode.getFeatures();
        if (CollectionUtils.isNotEmpty((Collection)features)) {
            Collections.sort(features, (f1, f2) -> f1.getType() - f2.getType());
            schemaNode.withFeatures(new Features());
            List schemaFeatures = schemaNode.getFeatures().getFeature();
            for (Object feature : features) {
                Feature schemaFeature = new Feature();
                schemaFeature.withFeatureCodeId(feature.getType()).withValue(feature.getValue());
                schemaFeatures.add(schemaFeature);
            }
        }
        if (!skipCvValues) {
            List cvs = node.getConfigVariables().values().stream().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cvs)) {
                org.bidib.jbidibc.core.node.ConfigurationVariable.sortCvVariables(cvs);
                schemaNode.withConfigurationVariables(new ConfigurationVariables());
                List schemaCvs = schemaNode.getConfigurationVariables().getConfigurationVariable();
                for (org.bidib.jbidibc.core.node.ConfigurationVariable cv : cvs) {
                    if (cv.isTimeout()) {
                        LOGGER.debug("Skip CV with timeout: {}", (Object)cv);
                        continue;
                    }
                    ConfigurationVariable schemaCv = new ConfigurationVariable();
                    schemaCv.withName(cv.getName()).withDefaultValue(cv.getDefaultValue()).withValue(cv.getValue());
                    CvNode cvNode = cvNumberToNodeMap.get(cv.getName());
                    if (cvNode != null) {
                        String description = CvNode.getDescription((List)cvNode.getCV().getDescription(), (String)lang);
                        schemaCv.withDescription(description);
                    }
                    schemaCvs.add(schemaCv);
                }
            }
        } else {
            LOGGER.info("Add CV values to export data is skipped.");
        }
        List feedbackPorts = node.getFeedbackPorts();
        if (CollectionUtils.isNotEmpty((Collection)feedbackPorts)) {
            schemaNode.withFeedbackPorts(new FeedbackPorts());
            List schemaFeedbackPorts = schemaNode.getFeedbackPorts().getFeedbackPort();
            for (FeedbackPort feedbackPort : feedbackPorts) {
                org.bidib.jbidibc.core.schema.bidib2.FeedbackPort port = new org.bidib.jbidibc.core.schema.bidib2.FeedbackPort();
                port.setNumber(feedbackPort.getId());
                BaseLabel label = BidibLabelUtils.getFeedbackPortLabel((NodeLabels)nodeLabels, (int)feedbackPort.getId());
                if (label != null) {
                    port.setName(label.getLabel());
                } else {
                    port.setName(feedbackPort.toString());
                }
                schemaFeedbackPorts.add(port);
            }
        }
        schemaNode.withPorts(new Ports());
        List ports = schemaNode.getPorts().getPort();
        List analogPorts = node.getAnalogPorts();
        if (CollectionUtils.isNotEmpty((Collection)analogPorts)) {
            // empty if block
        }
        if (CollectionUtils.isNotEmpty((Collection)(inputPorts = node.getInputPorts()))) {
            for (InputPort inputPort : inputPorts) {
                InputKey inputKey = new InputKey();
                inputKey.setNumber(inputPort.getId());
                inputKey.setDisabled(Boolean.valueOf(!inputPort.isEnabled()));
                try {
                    if (inputPort.getInputBehaviour() != IoBehaviourInputEnum.UNKNOWN) {
                        inputKey.setIoInputBehaviour(IOInputBehaviour.valueOf((String)inputPort.getInputBehaviour().name()));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the ioBehaviour for inputKey failed.", (Throwable)ex);
                }
                inputKey.setSwitchOffTime(inputPort.getSwitchOffTime());
                BaseLabel label = BidibLabelUtils.getLabel((PortLabels)nodeLabels.getPortLabels(), (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.inputPort, (int)inputPort.getId());
                if (label != null) {
                    inputKey.setName(label.getLabel());
                } else {
                    inputKey.setName(inputPort.toString());
                }
                ports.add(inputKey);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(backlightPorts = node.getBacklightPorts()))) {
            for (BacklightPort backlightPort : backlightPorts) {
                OutputBacklight backlight = new OutputBacklight();
                backlight.setNumber(backlightPort.getId());
                backlight.setDisabled(Boolean.valueOf(!backlightPort.isEnabled()));
                backlight.setDimmingDownSpeed(Integer.valueOf(backlightPort.getDimSlopeDown()));
                backlight.setDimmingUpSpeed(Integer.valueOf(backlightPort.getDimSlopeUp()));
                backlight.setDmxChannel(backlightPort.getDmxMapping());
                BaseLabel label = BidibLabelUtils.getLabel((PortLabels)nodeLabels.getPortLabels(), (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.backlightPort, (int)backlightPort.getId());
                if (label != null) {
                    backlight.setName(label.getLabel());
                } else {
                    backlight.setName(backlightPort.toString());
                }
                ports.add(backlight);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(lightPorts = node.getLightPorts()))) {
            for (LightPort lightPort : lightPorts) {
                OutputLight light = new OutputLight();
                light.setNumber(lightPort.getId());
                light.setDisabled(Boolean.valueOf(!lightPort.isEnabled()));
                light.setBrightnessOff(Integer.valueOf(lightPort.getPwmMin()));
                light.setBrightnessOn(Integer.valueOf(lightPort.getPwmMax()));
                light.setDimmingDownSpeed(Integer.valueOf(lightPort.getDimMin()));
                light.setDimmingUpSpeed(Integer.valueOf(lightPort.getDimMax()));
                light.setRgbValue(lightPort.getRgbValue());
                light.setTransitionTime(lightPort.getTransitionTime());
                light.setOutputMap(lightPort.getDmxMapping());
                BaseLabel label = BidibLabelUtils.getLabel((PortLabels)nodeLabels.getPortLabels(), (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.lightPort, (int)lightPort.getId());
                if (label != null) {
                    light.setName(label.getLabel());
                } else {
                    light.setName(lightPort.toString());
                }
                ports.add(light);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(servoPorts = node.getServoPorts()))) {
            for (ServoPort servoPort : servoPorts) {
                OutputServo servo = new OutputServo();
                servo.setDisabled(Boolean.valueOf(!servoPort.isEnabled()));
                servo.setLowerLimit(Integer.valueOf(servoPort.getTrimDown()));
                servo.setUpperLimit(Integer.valueOf(servoPort.getTrimUp()));
                servo.setMovingTime(Integer.valueOf(servoPort.getSpeed()));
                servo.setNumber(servoPort.getId());
                BaseLabel label = BidibLabelUtils.getLabel((PortLabels)nodeLabels.getPortLabels(), (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.servoPort, (int)servoPort.getId());
                if (label != null) {
                    servo.setName(label.getLabel());
                } else {
                    servo.setName(servoPort.toString());
                }
                ports.add(servo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(switchPorts = node.getSwitchPorts()))) {
            for (SwitchPort switchPort : switchPorts) {
                OutputSwitch outputSwitch = new OutputSwitch();
                outputSwitch.setNumber(switchPort.getId());
                outputSwitch.setDisabled(Boolean.valueOf(!switchPort.isEnabled()));
                try {
                    if (switchPort.getOutputBehaviour() != IoBehaviourSwitchEnum.UNKNOWN) {
                        outputSwitch.setIoSwitchBehaviour(IOSwitchBehaviour.valueOf((String)switchPort.getOutputBehaviour().name()));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the ioBehaviour for outputSwitch failed.", (Throwable)ex);
                }
                try {
                    if (switchPort.getLoadType() != LoadTypeEnum.UNKNOWN) {
                        outputSwitch.setLoadType(LoadType.valueOf((String)switchPort.getLoadType().name()));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the loadType for outputSwitch failed.", (Throwable)ex);
                }
                outputSwitch.setSwitchOffTime(switchPort.getSwitchOffTime());
                BaseLabel label = BidibLabelUtils.getLabel((PortLabels)nodeLabels.getPortLabels(), (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.switchPort, (int)switchPort.getId());
                if (label != null) {
                    outputSwitch.setName(label.getLabel());
                } else {
                    outputSwitch.setName(switchPort.toString());
                }
                ports.add(outputSwitch);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(switchPairPorts = node.getSwitchPairPorts()))) {
            for (SwitchPairPort switchPairPort : switchPairPorts) {
                OutputSwitchPair outputSwitchPair = new OutputSwitchPair();
                outputSwitchPair.setNumber(switchPairPort.getId());
                outputSwitchPair.setDisabled(Boolean.valueOf(!switchPairPort.isEnabled()));
                try {
                    if (switchPairPort.getLoadType() != LoadTypeEnum.UNKNOWN) {
                        outputSwitchPair.setLoadType(LoadType.valueOf((String)switchPairPort.getLoadType().name()));
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the loadType for outputSwitchPair failed.", (Throwable)ex);
                }
                outputSwitchPair.setSwitchOffTime(switchPairPort.getSwitchOffTime());
                BaseLabel label = BidibLabelUtils.getLabel((PortLabels)nodeLabels.getPortLabels(), (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.switchPairPort, (int)switchPairPort.getId());
                if (label != null) {
                    outputSwitchPair.setName(label.getLabel());
                } else {
                    outputSwitchPair.setName(switchPairPort.toString());
                }
                ports.add(outputSwitchPair);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(macros = node.getMacros()))) {
            FunctionConversionFactory functionConversionFactory = new FunctionConversionFactory();
            Macros schemaMacros = new Macros();
            for (Object macro : macros) {
                Macro schemaMacro = new Macro();
                schemaMacro.setNumber(macro.getId());
                schemaMacro.setName(macro.getLabel());
                MacroParameters macroParameters = NodeUtils.createMacroParameters((org.bidib.wizard.api.model.Macro)macro);
                schemaMacro.setMacroParameters(macroParameters);
                List functions = macro.getFunctions();
                if (CollectionUtils.isNotEmpty((Collection)functions)) {
                    MacroPoints macroPoints = new MacroPoints();
                    schemaMacro.withMacroPoints(macroPoints);
                    for (Function function : functions) {
                        LOGGER.info("Convert function: {}", (Object)function);
                        MacroPoint macroPoint = functionConversionFactory.convert(function);
                        macroPoints.withMacroPoint(new MacroPoint[]{macroPoint});
                    }
                }
                schemaMacros.withMacro(new Macro[]{schemaMacro});
            }
            schemaNode.setMacros(schemaMacros);
            if (CollectionUtils.isNotEmpty((Collection)node.getFlags())) {
                Flags schemaFlags = new Flags();
                for (Flag flag : node.getFlags()) {
                    if (!StringUtils.isNotBlank((CharSequence)flag.getLabel())) continue;
                    org.bidib.jbidibc.core.schema.bidib2.Flag schemaFlag = new org.bidib.jbidibc.core.schema.bidib2.Flag().withNumber(flag.getId()).withName(flag.getLabel());
                    schemaFlags.getFlag().add(schemaFlag);
                }
                if (CollectionUtils.isNotEmpty((Collection)schemaFlags.getFlag())) {
                    schemaNode.setFlags(schemaFlags);
                } else {
                    LOGGER.info("No flags with labels.");
                }
            }
        } else {
            LOGGER.info("No macros available.");
        }
        List accessories = node.getAccessories();
        if (CollectionUtils.isNotEmpty((Collection)accessories)) {
            Accessories schemaAccessories = new Accessories();
            for (org.bidib.wizard.api.model.Accessory accessory : accessories) {
                List aspects;
                Accessory schemaAccessory = new Accessory();
                schemaAccessory.setNumber(accessory.getId().intValue());
                AccessoryLabel accessoryLabel = AccessoryLabelUtils.getAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId());
                if (accessoryLabel != null) {
                    schemaAccessory.setName(accessoryLabel.getLabel());
                }
                if (CollectionUtils.isNotEmpty((Collection)(aspects = accessory.getAspects()))) {
                    Aspects schemaAspects = new Aspects();
                    schemaAccessory.withAspects(schemaAspects);
                    int aspectNumber = 0;
                    for (MacroRef macroRef : aspects) {
                        Aspect aspect = new Aspect();
                        aspect.setMacroNumber(macroRef.getId());
                        aspect.setNumber(Integer.valueOf(aspectNumber));
                        schemaAspects.withAspect(new Aspect[]{aspect});
                        BaseLabel aspectLabel = AccessoryLabelUtils.getAccessoryAspectLabel((AccessoryLabel)accessoryLabel, (int)aspectNumber);
                        if (aspectLabel != null) {
                            aspect.setName(aspectLabel.getLabel());
                        }
                        ++aspectNumber;
                    }
                }
                if (accessory.getStartupState() != null) {
                    schemaAccessory.setStartupState(accessory.getStartupState());
                }
                schemaAccessories.withAccessory(new Accessory[]{schemaAccessory});
            }
            schemaNode.setAccessories(schemaAccessories);
        } else {
            LOGGER.info("No accessories available.");
        }
        return bidib;
    }

    private static MacroParameters createMacroParameters(org.bidib.wizard.api.model.Macro macro) {
        MacroParameters macroParameters = new MacroParameters();
        MacroParameterSlowdown macroParameterSlowdown = new MacroParameterSlowdown();
        macroParameterSlowdown.setSpeed(macro.getSpeed());
        macroParameters.withMacroParameter(new MacroParameter[]{macroParameterSlowdown});
        MacroParameterRepeat macroParameterRepeat = new MacroParameterRepeat();
        macroParameterRepeat.setRepetitions(macro.getCycles());
        macroParameters.withMacroParameter(new MacroParameter[]{macroParameterRepeat});
        MacroParameterClockStart macroParameterClockStart = new MacroParameterClockStart();
        if (CollectionUtils.isNotEmpty((Collection)macro.getStartConditions())) {
            LinkedList startConditions = new LinkedList(macro.getStartConditions());
            if (startConditions.get(0) instanceof TimeStartCondition) {
                TimeStartCondition timeStartCondition = (TimeStartCondition)startConditions.get(0);
                macroParameterClockStart.setHour(Integer.valueOf(timeStartCondition.getTime().get(11)));
                macroParameterClockStart.setMinute(Integer.valueOf(timeStartCondition.getTime().get(12)));
                macroParameterClockStart.setIsEnabled(true);
                if (timeStartCondition.getRepeatDay() != null) {
                    switch (3.$SwitchMap$org$bidib$wizard$api$model$MacroRepeatDay[timeStartCondition.getRepeatDay().ordinal()]) {
                        case 1: {
                            macroParameterClockStart.setWeekday(WeekdayExtension.EVERY_DAY.value());
                            break;
                        }
                        case 2: {
                            macroParameterClockStart.setWeekday(Weekday.MONDAY.value());
                            break;
                        }
                        case 3: {
                            macroParameterClockStart.setWeekday(Weekday.TUESDAY.value());
                            break;
                        }
                        case 4: {
                            macroParameterClockStart.setWeekday(Weekday.WEDNESDAY.value());
                            break;
                        }
                        case 5: {
                            macroParameterClockStart.setWeekday(Weekday.THURSDAY.value());
                            break;
                        }
                        case 6: {
                            macroParameterClockStart.setWeekday(Weekday.FRIDAY.value());
                            break;
                        }
                        case 7: {
                            macroParameterClockStart.setWeekday(Weekday.SATURDAY.value());
                            break;
                        }
                        case 8: {
                            macroParameterClockStart.setWeekday(Weekday.SUNDAY.value());
                            break;
                        }
                        default: {
                            LOGGER.warn("Unknown repeat day: {}", (Object)timeStartCondition.getRepeatDay());
                            break;
                        }
                    }
                } else {
                    LOGGER.info("No repeat day specified for macro: {}", (Object)macro.getLabel());
                }
                if (timeStartCondition.getRepeatTime() != null) {
                    switch (3.$SwitchMap$org$bidib$wizard$api$model$MacroRepeatTime[timeStartCondition.getRepeatTime().ordinal()]) {
                        case 1: {
                            macroParameterClockStart.setPeriodicalRepetition(HourExtension.EVERY_HOUR.value());
                            break;
                        }
                        case 2: {
                            macroParameterClockStart.setPeriodicalRepetition(HourExtension.EVERY_HOUR_IN_DAYTIME.value());
                            break;
                        }
                        case 3: {
                            macroParameterClockStart.setPeriodicalRepetition(MinuteExtension.EVERY_30_MINUTES.value());
                            break;
                        }
                        case 4: {
                            macroParameterClockStart.setPeriodicalRepetition(MinuteExtension.EVERY_15_MINUTES.value());
                            break;
                        }
                        case 5: {
                            macroParameterClockStart.setPeriodicalRepetition(MinuteExtension.EVERY_MINUTE.value());
                            break;
                        }
                    }
                } else {
                    LOGGER.info("No repeat time specified for macro: {}", (Object)macro.getLabel());
                }
            }
        } else {
            macroParameterClockStart.setIsEnabled(false);
        }
        macroParameters.withMacroParameter(new MacroParameter[]{macroParameterClockStart});
        return macroParameters;
    }

    public static <P extends Port<?>> P getPort(List<P> ports, int portNumber, boolean sourceIsFlatPortModel, boolean targetIsFlatPortModel) {
        LOGGER.info("Get port with portNumber: {}, sourceIsFlatPortModel: {}, targetIsFlatPortModel: {}", new Object[]{portNumber, sourceIsFlatPortModel, targetIsFlatPortModel});
        if (sourceIsFlatPortModel != targetIsFlatPortModel) {
            if (!sourceIsFlatPortModel) {
                try {
                    Port port = (Port)ports.get(portNumber);
                    if (!port.isEnabled()) {
                        LOGGER.warn("Found disabled port at index: {}, port: {}", (Object)portNumber, (Object)port);
                        return null;
                    }
                    LOGGER.info("Searched port at index: {}, return found port: {}", (Object)portNumber, (Object)port);
                    return (P)port;
                }
                catch (IndexOutOfBoundsException ex) {
                    LOGGER.warn("Port not available, portNumber: {}, message: {}", (Object)portNumber, (Object)ex.getMessage());
                }
            } else {
                LOGGER.warn("Cannot calculate port from flat to type-oriented model.");
            }
        } else {
            LOGGER.info("Get the port from the portNumber: {}", (Object)portNumber);
            for (Port port : ports) {
                if (port.getId() != portNumber) continue;
                LOGGER.info("Return found port: {}", (Object)port);
                return (P)port;
            }
        }
        return null;
    }

    public static Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node, ApplicationContext context) {
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)context.get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        Map cvNumberToNodeMap = cvDefinitionPanelController.getCvNumberToNodeMap(node);
        return cvNumberToNodeMap;
    }

    public static CvDefinitionTreeTableModel getCvDefinitionTreeTableModel(NodeInterface node, ApplicationContext context) {
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)context.get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        CvDefinitionTreeTableModel cvDefinitionTreeTableModel = cvDefinitionPanelController.getCvDefinitionTreeTableModel(node);
        return cvDefinitionTreeTableModel;
    }

    public static void loadDataFromNode(String connectionId, NodeService nodeService, SwitchingNodeService switchingNodeService, NodeInterface node, boolean loadMacroContent, boolean loadCvs) {
        if (loadCvs) {
            LOGGER.info("Load the CVs of the node before export: {}", (Object)node);
            List configurationVariables = node.getConfigVariables().values().stream().distinct().collect(Collectors.toList());
            org.bidib.jbidibc.core.node.ConfigurationVariable.sortCvVariables(configurationVariables);
            configurationVariables = nodeService.queryConfigVariables(connectionId, node, configurationVariables);
            LOGGER.info("Current configurationVariables: {}", (Object)configurationVariables);
            node.setConfigVariables(configurationVariables);
        } else {
            LOGGER.warn("The CV values of the node are not exported!");
        }
        boolean nodeHasFlatPortModel = node.getNode().isPortFlatModelAvailable();
        LOGGER.info("Prepare the nodeState, nodeHasFlatPortModel: {}", (Object)nodeHasFlatPortModel);
        if (loadMacroContent) {
            LOGGER.info("Load the macro content of the node before export: {}", (Object)node);
            LinkedList<org.bidib.wizard.api.model.Macro> macroList = new LinkedList<org.bidib.wizard.api.model.Macro>();
            for (org.bidib.wizard.api.model.Macro macro : node.getMacros()) {
                if (!node.getNode().isRegistered()) break;
                org.bidib.wizard.api.model.Macro macroWithContent = switchingNodeService.getMacroContent(connectionId, node.getSwitchingNode(), macro);
                LOGGER.info("Load macro content: {}", (Object)macroWithContent);
                macroWithContent.setMacroSaveState(MacroSaveState.PERMANENTLY_STORED_ON_NODE);
                macroWithContent.setFlatPortModel(nodeHasFlatPortModel);
                macroList.add(macroWithContent);
            }
            LOGGER.info("Set the new macros for the node: {}", macroList);
            node.setMacros(macroList);
        }
    }
}

