package org.bidib.wizard.mvc.main.view.component;

import java.text.DecimalFormat;
import java.util.function.Supplier;

import org.bidib.wizard.client.common.component.SliderAndValuePanel;
import org.bidib.wizard.model.ports.BacklightPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightSliderAndValuePanel extends SliderAndValuePanel {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightSliderAndValuePanel.class);

    private final DecimalFormat format = new DecimalFormat("##0");

    private final Supplier<BacklightPort> backlightPortSupplier;

    public BacklightSliderAndValuePanel(int min, int max, int value,
        final Supplier<BacklightPort> backlightPortSupplier) {
        super(min, max, value);

        this.backlightPortSupplier = backlightPortSupplier;
    }

    @Override
    protected void updateSliderTextValue(int value) {
        LOGGER.trace("updateSliderTextValue, value: {}, isSelected: {}", value);

        String newValue = format.format(value);
        LOGGER.trace("Set the new value: {}", newValue);

        Integer targetAbsolute = null;

        final BacklightPort port = this.backlightPortSupplier.get();

        int range = port.getDimSlopeUp() - port.getDimSlopeDown();
        float factor = (float) range / 100;
        float targetValue = (factor * value) + port.getDimSlopeDown();
        LOGGER.trace("Calculated range: {}, factor: {}, targetValue: {}", range, factor, targetValue);
        targetAbsolute = Integer.valueOf(Math.round(targetValue));

        StringBuffer sb = new StringBuffer("<html>");
        sb.append(newValue).append("% ");
        if (targetAbsolute != null) {
            sb.append("<FONT COLOR=");
            // if (isSelected) {
            // sb.append("WHITE");
            // }
            // else {
            sb.append("GRAY");
            // }
            sb.append(">(").append(targetAbsolute.intValue()).append(")</FONT>");
        }
        sb.append("</html>");

        sliderValue.setText(sb.toString());
    }
}
