package org.bidib.wizard.mvc.main.view.table;

import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.renderer.PortIdentifierTableCellRenderer;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.IoBehaviourInputComboBoxRenderer;

import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class InputPortTable extends AbstractPortHierarchicalTable<InputPort> {
    private static final long serialVersionUID = 1L;

    private final InputPortTableModel inputPortTableModel;

    public InputPortTable(final InputPortTableModel inputPortTableModel, String emptyTableText) {
        super(inputPortTableModel, emptyTableText);

        this.inputPortTableModel = inputPortTableModel;
    }

    @Override
    protected InputPortEditorPanel createPortEditorPanel(
        final InputPort port, int row, final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, final NodeSelectionProvider nodeSelectionProvider) {
        InputPortEditorPanel editorPanel =
            new InputPortEditorPanel(port, inputPort -> this.inputPortTableModel.updatePortConfig(inputPort),
                    inputPort -> this.inputPortTableModel.refreshRow(inputPort, changedRow -> repaint(getCellRect(changedRow, InputPortTableModel.COLUMN_LABEL, true))) , nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void clearTable() {

    }

    @Override
    public void prepareTableColumns() {

        // initialize the table columns with an identifier to allow show/hide later ...
        TableColumn tcLabel = getColumnModel().getColumn(InputPortTableModel.COLUMN_LABEL);
        tcLabel.setCellRenderer(new LocalPortConfigErrorAwareRenderer(InputPortTableModel.COLUMN_LABEL));
        tcLabel.setIdentifier(Integer.valueOf(InputPortTableModel.COLUMN_LABEL));

        TableCellRenderer tableCellRenderer =
            new IoBehaviourInputComboBoxRenderer(IoBehaviourInputEnum.getValues(), BidibLibrary.BIDIB_PCFG_INPUT_CTRL);
        TableColumn tc = getColumnModel().getColumn(InputPortTableModel.COLUMN_IO_BEHAVIOUR);
        tc.setCellRenderer(tableCellRenderer);
        tc.setIdentifier(Integer.valueOf(InputPortTableModel.COLUMN_IO_BEHAVIOUR));

        tc = getColumnModel().getColumn(InputPortTableModel.COLUMN_SWITCH_OFF_TIME);
        tc.setCellRenderer(new PortTicksRenderer(InputPortTableModel.COLUMN_SWITCH_OFF_TIME));
        tc.setIdentifier(Integer.valueOf(InputPortTableModel.COLUMN_SWITCH_OFF_TIME));

        tc = getColumnModel().getColumn(InputPortTableModel.COLUMN_PORT_IDENTIFIER);
        tc.setCellRenderer(new PortIdentifierTableCellRenderer());
        tc.setMaxWidth(80);
        tc.setIdentifier(Integer.valueOf(InputPortTableModel.COLUMN_PORT_IDENTIFIER));

        tc = getColumnModel().getColumn(InputPortTableModel.COLUMN_STATUS);
        tc.setCellRenderer(new InputPortTableStatusCellRenderer());
        tc.setIdentifier(Integer.valueOf(InputPortTableModel.COLUMN_STATUS));

        TableColumnChooser.hideColumn(this, InputPortTableModel.COLUMN_PORT_INSTANCE);
    }
}
