package org.bidib.wizard.mvc.position.model;

import java.util.Objects;

import org.bidib.wizard.api.model.NodeInterface;

public class RfBasisNode {
    private final NodeInterface node;

    public RfBasisNode(final NodeInterface node) {
        this.node = node;
    }

    /**
     * @return the node
     */
    public NodeInterface getNode() {
        return node;
    }

    @Override
    public int hashCode() {
        return Objects.hash(node);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof RfBasisNode))
            return false;
        RfBasisNode other = (RfBasisNode) obj;
        return Objects.equals(node, other.node);
    }

    @Override
    public String toString() {
        return node.toString();
    }
}
