package org.bidib.wizard.mvc.preferences.view.panel;

import java.awt.BorderLayout;
import java.util.function.Consumer;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.types.LookAndFeel;
import org.bidib.wizard.core.model.settings.ExperimentalSettings;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class ExperimentalSettingsPanel extends AbstractSettingsPanel<ExperimentalSettingsInterface> {

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";

    private static final String ENCODED_DIALOG_ROW_SPECS =
        "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";

    private final ExperimentalSettingsInterface experimentalSettings;

    private JPanel contentPanel;

    public ExperimentalSettingsPanel(final ExperimentalSettingsInterface experimentalSettings,
        final Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.experimentalSettings = experimentalSettings;
    }

    public JPanel createPanel() {

        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            JPanel panel = new FormDebugPanel();
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        else {
            JPanel panel = new JPanel(new BorderLayout());
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        // use value model here and only update settings on focus lost

        preparePresentationModel(this.experimentalSettings);

        // speedometer timeout
        final ValueModel speedometerTimeoutConverterModel =
            new ConverterValueModel(
                presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_SPEEDOMETER_TIMEOUT),
                new StringToIntegerConverter(Integer.valueOf(300)));

        dialogBuilder.add(Resources.getString(getClass(), "speedometerTimeout") + ":").xy(1, 1);
        final JTextField speedometerTimeout = new JTextField();
        speedometerTimeout.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(speedometerTimeout, speedometerTimeoutConverterModel, false);

        dialogBuilder.add(speedometerTimeout).xyw(3, 1, 3);

        // dcca decoder timeout
        final ValueModel dccaDecoderTimeoutConverterModel =
            new ConverterValueModel(
                presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_DCCA_DECODER_TIMEOUT),
                new StringToIntegerConverter(Integer.valueOf(3)));

        dialogBuilder.add(Resources.getString(getClass(), "dccaDecoderTimeout") + ":").xy(1, 3);
        final JTextField dccaDecoderTimeout = new JTextField();
        dccaDecoderTimeout.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(dccaDecoderTimeout, dccaDecoderTimeoutConverterModel, false);

        dialogBuilder.add(dccaDecoderTimeout).xyw(3, 3, 3);

        // dcca maxAnswerRetryCount
        final ValueModel dccaMaxAnswerRetryCountConverterModel =
            new ConverterValueModel(
                presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_DCCA_MAX_ANSWER_RETRY_COUNT),
                new StringToIntegerConverter(Integer.valueOf(3)));

        dialogBuilder.add(Resources.getString(getClass(), "dccaMaxAnswerRetryCount") + ":").xy(1, 5);
        final JTextField dccaMaxAnswerRetryCount = new JTextField();
        dccaMaxAnswerRetryCount.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(dccaMaxAnswerRetryCount, dccaMaxAnswerRetryCountConverterModel, false);

        dialogBuilder.add(dccaMaxAnswerRetryCount).xyw(3, 5, 3);

        // dcca logon assign ackn timeout
        final ValueModel dccaLogonAssignAcknConverterModel =
            new ConverterValueModel(
                presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_DCCA_LOGONASSIGN_ACKN_TIMEOUT),
                new StringToIntegerConverter(Integer.valueOf(3)));

        dialogBuilder.add(Resources.getString(getClass(), "dccaLogonAssignAcknTimeout") + ":").xy(1, 7);
        final JTextField dccaLogonAssignAcknTimeout = new JTextField();
        dccaLogonAssignAcknTimeout.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(dccaLogonAssignAcknTimeout, dccaLogonAssignAcknConverterModel, false);

        dialogBuilder.add(dccaLogonAssignAcknTimeout).xyw(3, 7, 3);

        // dcca maxAnswerRetryCount
        final ValueModel dccaMaxLogonAssignRetryCountConverterModel =
            new ConverterValueModel(
                presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_DCCA_MAX_LOGONASSIGN_RETRY_COUNT),
                new StringToIntegerConverter(Integer.valueOf(3)));

        dialogBuilder.add(Resources.getString(getClass(), "dccaMaxLogonAssignRetryCount") + ":").xy(1, 9);
        final JTextField dccaMaxLogonAssignRetryCount = new JTextField();
        dccaMaxLogonAssignRetryCount.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(dccaMaxLogonAssignRetryCount, dccaMaxLogonAssignRetryCountConverterModel, false);

        dialogBuilder.add(dccaMaxLogonAssignRetryCount).xyw(3, 9, 3);

        // dcca logonEnableInterval
        final ValueModel dccaLogonEnableIntervalConverterModel =
            new ConverterValueModel(
                presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_DCCA_LOGONENABLE_INTERVAL),
                new StringToIntegerConverter(Integer.valueOf(3)));

        dialogBuilder.add(Resources.getString(getClass(), "dccaLogonEnableInterval") + ":").xy(1, 11);
        final JTextField dccaLogonEnableInterval = new JTextField();
        dccaLogonEnableInterval.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(dccaLogonEnableInterval, dccaLogonEnableIntervalConverterModel, false);

        dialogBuilder.add(dccaLogonEnableInterval).xyw(3, 11, 3);

        // loco video
        final BufferedValueModel locoVideoEnabledModel =
            presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_LOCOVIDEO_ENABLED);

        JCheckBox locoVideoEnabled =
            WizardComponentFactory
                .createCheckBox(locoVideoEnabledModel, Resources.getString(getClass(), "locoVideoEnabled"));
        dialogBuilder.add(locoVideoEnabled).xyw(1, 13, 5);

        Boolean vlcDetected =
            DefaultApplicationContext.getInstance().get(DefaultApplicationContext.KEY_VLC_DETECTED, Boolean.class);
        if (vlcDetected == null || !vlcDetected.booleanValue()) {
            locoVideoEnabled.setEnabled(false);
        }

        // loco video uri
        final BufferedValueModel bufferedLocoVideoUriModel =
            presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_LOCOVIDEO_URI);

        dialogBuilder.add(Resources.getString(getClass(), "locoVideoUri") + ":").xy(1, 15);
        final JTextField locoVideoUri = WizardComponentFactory.createTextField(bufferedLocoVideoUriModel, false);
        dialogBuilder.add(locoVideoUri).xyw(3, 15, 3);

        // Look and feel
        final BufferedValueModel selectionHolderLookAndFeel =
            presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_LOOK_AND_FEEL);

        final ArrayListModel<LookAndFeel> lookAndFeelList = new ArrayListModel<>();

        for (LookAndFeel value : LookAndFeel.values()) {
            lookAndFeelList.add(value);
        }

        SelectionInList<LookAndFeel> lookAndFeelSelection =
            new SelectionInList<>((ListModel<LookAndFeel>) lookAndFeelList);

        ComboBoxAdapter<String> comboBoxAdapterLookAndFeel =
            new ComboBoxAdapter<String>(lookAndFeelSelection, selectionHolderLookAndFeel);
        final JComboBox<String> comboLookAndFeel = new JComboBox<>();
        comboLookAndFeel.setModel(comboBoxAdapterLookAndFeel);

        dialogBuilder.add(Resources.getString(ExperimentalSettingsPanel.class, "lookAndFeel") + ":").xy(1, 17);
        dialogBuilder.add(comboLookAndFeel).xy(3, 17);

        // bidib-distributed
        final BufferedValueModel bidibDistributedEnabledModel =
            presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_BIDIB_DISTRIBUTED_ENABLED);

        JCheckBox bidibDistributedEnabled =
            WizardComponentFactory
                .createCheckBox(bidibDistributedEnabledModel,
                    Resources.getString(getClass(), "bidibDistributedEnabled"));
        dialogBuilder.add(bidibDistributedEnabled).xyw(1, 19, 5);

        // localhost
        final BufferedValueModel localhostEnabledModel =
            presentationModel.getBufferedModel(ExperimentalSettings.PROPERTY_LOCALHOST_ENABLED);

        JCheckBox localhostEnabled =
            WizardComponentFactory
                .createCheckBox(localhostEnabledModel, Resources.getString(getClass(), "localHostEnabled"));
        dialogBuilder.add(localhostEnabled).xyw(1, 21, 5);

        contentPanel = dialogBuilder.build();
        contentPanel.setOpaque(false);
        return contentPanel;
    }

}
