/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.scenery;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.BoundedRangeAdapter;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.renderer.MacroRenderer;
import org.bidib.wizard.client.common.view.slider.LabeledSlider;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.DmxLightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.dmx.controller.listener.DmxModelerControllerListener;
import org.bidib.wizard.mvc.dmx.model.DmxScenery;
import org.bidib.wizard.mvc.dmx.model.DmxSceneryModel;
import org.bidib.wizard.mvc.dmx.model.DmxSceneryPoint;
import org.bidib.wizard.mvc.dmx.view.scenery.ApplyButtonEnabledModel;
import org.bidib.wizard.mvc.dmx.view.scenery.DmxChannelNode;
import org.bidib.wizard.mvc.dmx.view.scenery.DmxChannelNodeTreeRenderer;
import org.bidib.wizard.mvc.dmx.view.scenery.PortNode;
import org.bidib.wizard.mvc.dmx.view.scenery.SceneryPanel;
import org.bidib.wizard.mvc.dmx.view.scenery.SceneryValidationResultModel;
import org.bidib.wizard.mvc.dmx.view.utils.SceneryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneryPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneryPanel.class);
    private static final String ENCODED_COLUMN_SPECS_TOP = "pref, 3dlu, fill:30dlu:grow";
    private static final String ENCODED_ROW_SPECS_TOP = "pref, 3dlu, fill:pref:grow";
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref";
    private static final String SCENERIES_EXTENSION = "sceneries";
    private static String sceneriesDescription;
    private static FileFilter sceneriesFilter;
    private final DmxSceneryModel dmxSceneryModel;
    private final NodeInterface node;
    private DmxModelerControllerListener dmxModelerControllerListener;
    private JList<DmxScenery> sceneryList;
    private SelectionInList<DmxScenery> scenerySelection;
    private DmxScenery editedScenery;
    private PresentationModel<DmxScenery> detailsModel;
    private JPanel bottomDetailsPanel;
    private JTextField sceneryName;
    private JTree usedChannelsTree;
    private JButton applyButton;
    private JButton resetButton;
    private JPopupMenu sceneryMenu;
    private BufferedValueModel sceneryNameModel;
    private DefaultTreeModel usedChannelsTreeModel;
    private DefaultMutableTreeNode root;
    private SceneryValidationResultModel validationResultModel;
    private ApplyButtonEnabledModel applyButtonEnabled;
    private JMenuItem openViewer;
    private JMenuItem addDmxChannel;
    private ValueModel dimmStretchUpModel;
    private ValueModel dimmStretchDownModel;
    private final SettingsService settingsService;
    private static final String WORKING_DIR_DMX_SCENERY_KEY = "dmxScenery";
    private static final int DMX_MAPPING_OFFSET = 1;

    public SceneryPanel(NodeInterface node, DmxSceneryModel dmxSceneryModel, SettingsService settingsService) {
        this.dmxSceneryModel = dmxSceneryModel;
        this.node = node;
        this.settingsService = settingsService;
        sceneriesDescription = Resources.getString(SceneryPanel.class, (String)"sceneriesDescription");
        sceneriesFilter = new FileNameExtensionFilter(sceneriesDescription, SCENERIES_EXTENSION);
    }

    public void setDmxModelerControllerListener(DmxModelerControllerListener dmxModelerControllerListener) {
        this.dmxModelerControllerListener = dmxModelerControllerListener;
    }

    public JComponent createPanel() {
        this.detailsModel = new PresentationModel((ValueModel)new ValueHolder(null, true));
        this.dimmStretchUpModel = new ValueHolder((Object)1);
        this.dimmStretchDownModel = new ValueHolder((Object)1);
        this.applyButtonEnabled = new ApplyButtonEnabledModel();
        this.sceneryList = new JList();
        this.sceneryList.addListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu = new JPopupMenu(Resources.getString(SceneryPanel.class, (String)"scenery"));
        this.openViewer = this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu.addSeparator();
        this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryMenu.addSeparator();
        this.addDmxChannel = this.sceneryMenu.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.sceneryList.addMouseListener((MouseListener)new PopupListener(this));
        this.sceneryList.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        FormBuilder builderTop = null;
        boolean debugTop = false;
        builderTop = debugTop ? FormBuilder.create().columns(ENCODED_COLUMN_SPECS_TOP, new Object[0]).rows(ENCODED_ROW_SPECS_TOP, new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns(ENCODED_COLUMN_SPECS_TOP, new Object[0]).rows(ENCODED_ROW_SPECS_TOP, new Object[0]).panel(new JPanel());
        builderTop.border((Border)Paddings.TABBED_DIALOG);
        ValueHolder nodeNameModel = new ValueHolder((Object)this.node.getLabel());
        JTextField nodeName = WizardComponentFactory.createTextField((ValueModel)nodeNameModel, (boolean)false);
        nodeName.setEditable(false);
        builderTop.add(Resources.getString(this.getClass(), (String)"node-name"), new Object[0]).xy(1, 1);
        builderTop.add((Component)nodeName).xy(3, 1);
        this.scenerySelection = new SelectionInList(this.dmxSceneryModel.getSceneries());
        Bindings.bind((JList)this.sceneryList, (SelectionInList)this.scenerySelection);
        builderTop.add((Component)new JScrollPane(this.sceneryList)).xyw(1, 3, 3);
        JPanel topPanel = builderTop.build();
        FormBuilder builder = null;
        boolean debug = false;
        builder = debug ? FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.TABBED_DIALOG);
        this.sceneryNameModel = this.detailsModel.getBufferedModel("name");
        this.sceneryName = WizardComponentFactory.createTextField((ValueModel)this.sceneryNameModel, (boolean)false);
        this.sceneryNameModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        builder.add(Resources.getString(this.getClass(), (String)"scenery-name"), new Object[0]).xy(1, 1);
        builder.add((Component)this.sceneryName).xy(3, 1);
        BufferedValueModel sceneryMacroModel = this.detailsModel.getBufferedModel("macroNumber");
        ConverterValueModel converterMacroValueModel = new ConverterValueModel((ValueModel)sceneryMacroModel, (BindingConverter)new MacroNumberConverter(this));
        JComboBox macroNumberComboBox = new JComboBox(new ComboBoxAdapter(this.dmxSceneryModel.getMacros(), (ValueModel)converterMacroValueModel));
        macroNumberComboBox.setRenderer(new MacroRenderer());
        builder.add(Resources.getString(this.getClass(), (String)"macro-number"), new Object[0]).xy(1, 3);
        builder.add(macroNumberComboBox).xy(3, 3);
        ValidationComponentUtils.setMandatory((JComponent)this.sceneryName, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.sceneryName, (Object)"validation.sceneryname_key");
        this.validationResultModel = new SceneryValidationResultModel();
        this.root = new DefaultMutableTreeNode();
        this.usedChannelsTreeModel = new DefaultTreeModel(this.root);
        this.usedChannelsTree = new JTree(this.usedChannelsTreeModel);
        this.usedChannelsTree.setCellRenderer((TreeCellRenderer)new DmxChannelNodeTreeRenderer());
        this.usedChannelsTree.setRootVisible(false);
        BufferedValueModel channelModel = this.detailsModel.getBufferedModel("usedChannels");
        channelModel.addPropertyChangeListener("value", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.usedChannelsTree.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        builder.appendRows("5dlu, fill:200px:grow", new Object[0]);
        JScrollPane scrollChannels = new JScrollPane(this.usedChannelsTree);
        scrollChannels.setPreferredSize(new Dimension(100, 100));
        builder.add((Component)scrollChannels).xyw(1, 5, 3);
        LabeledSlider dimmStretchUpSlider = new LabeledSlider((BoundedRangeModel)new BoundedRangeAdapter(this.dimmStretchUpModel, 0, 1, 65535), null);
        dimmStretchUpSlider.createComponent();
        builder.appendRows("3dlu, pref", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"dimm-stretch-up"), new Object[0]).xy(1, 7);
        builder.add((Component)dimmStretchUpSlider).xy(3, 7);
        this.dimmStretchUpModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        LabeledSlider dimmStretchDownSlider = new LabeledSlider((BoundedRangeModel)new BoundedRangeAdapter(this.dimmStretchDownModel, 0, 1, 65535), null);
        dimmStretchDownSlider.createComponent();
        builder.appendRows("3dlu, pref", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"dimm-stretch-down"), new Object[0]).xy(1, 9);
        builder.add((Component)dimmStretchDownSlider).xy(3, 9);
        this.dimmStretchDownModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.applyButton = new JButton((Action)new ApplyAction(this));
        this.resetButton = new JButton((Action)new ResetAction(this));
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        builder.appendRows("3dlu, pref", new Object[0]);
        builder.add((Component)this.buildButtonBar()).xyw(1, 11, 3);
        PropertyConnector.connect((Object)this.detailsModel, (String)"buffering", (Object)this.applyButtonEnabled, (String)"modelBuffering");
        PropertyConnector.connect((Object)this.detailsModel, (String)"buffering", (Object)this.resetButton, (String)"enabled");
        PropertyConnector.connect((Object)this.applyButtonEnabled, (String)"buttonEnabled", (Object)this.applyButton, (String)"enabled");
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.getValidationResultModel(), (JComponent)builder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel(new JPanel());
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.bottomDetailsPanel = feedbackBuilder.build();
            this.triggerValidation();
        } else {
            this.bottomDetailsPanel = builder.build();
        }
        JSplitPane splitPane = new JSplitPane(0, topPanel, new JScrollPane(this.bottomDetailsPanel));
        splitPane.setDividerLocation(125);
        this.disableInputElements();
        this.detailsModel.getBeanChannel().addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.usedChannelsTree.addTreeSelectionListener((TreeSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return splitPane;
    }

    private Port<?> getSelectedPort() {
        Port selectedPort = null;
        TreePath path = this.usedChannelsTree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            LOGGER.info("Currently selected node: {}", (Object)node);
            if (node instanceof PortNode) {
                PortNode portNode = (PortNode)node;
                selectedPort = portNode.getPort();
            }
        }
        return selectedPort;
    }

    public void enableComponents(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (component instanceof JComboBox) {
                LOGGER.info("Current comp is a JComboBox: {}, enable: {}", (Object)component, (Object)enable);
                component.setEnabled(enable);
            } else if (!(component instanceof JSlider || component instanceof JButton || component instanceof Container)) {
                component.setEnabled(enable);
            }
            if (!(component instanceof Container)) continue;
            this.enableComponents((Container)component, enable);
        }
    }

    private void disableInputElements() {
        LOGGER.info("+++ disableInputElements");
        this.enableComponents((Container)this.bottomDetailsPanel, false);
    }

    private void enableInputElements() {
        LOGGER.info("+++ enableInputElements");
        this.enableComponents((Container)this.bottomDetailsPanel, true);
        this.triggerValidation();
    }

    private void expandAllNodes(JTree tree, DefaultMutableTreeNode treeTop, int maxLevel) {
        for (DefaultMutableTreeNode currentNode = treeTop.getNextNode(); currentNode != null; currentNode = currentNode.getNextNode()) {
            if (currentNode.getLevel() > maxLevel) continue;
            tree.expandPath(new TreePath(currentNode.getPath()));
        }
    }

    private void expandNode(JTree tree, DefaultMutableTreeNode currentNode) {
        tree.expandPath(new TreePath(currentNode.getPath()));
    }

    private void addNewScenery() {
        DmxScenery dmxScenery = new DmxScenery("Scenery-" + System.currentTimeMillis());
        dmxScenery.setName(dmxScenery.getId());
        LOGGER.info("Add new DMX scenery: {}", (Object)dmxScenery);
        this.dmxSceneryModel.addScenery(dmxScenery);
        this.scenerySelection.setList(this.dmxSceneryModel.getSceneries());
    }

    private void loadScenery() {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DMX_SCENERY_KEY);
        17 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void setWaitCursor() {
    }

    private void setDefaultCursor() {
    }

    private void saveScenery() {
        DmxScenery dmxScenery = (DmxScenery)this.sceneryList.getSelectedValue();
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DMX_SCENERY_KEY);
        18 dialog = new /* Unavailable Anonymous Inner Class!! */;
        if (dmxScenery != null) {
            String sceneryName = dmxScenery.getName();
            dialog.updateFileFilter(sceneriesFilter, sceneryName + ".sceneries");
        }
        dialog.showDialog();
    }

    private void saveAllSceneries() {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DMX_SCENERY_KEY);
        19 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.setApproveButtonText(Resources.getString(SceneryPanel.class, (String)"save_to_directory"));
        dialog.showDialog();
    }

    private void transformScenery() {
        DmxScenery dmxScenery;
        int result;
        if (this.detailsModel.isBuffering() && (result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.bottomDetailsPanel), Resources.getString(SceneryPanel.class, (String)"dialog.pending_changes"), Resources.getString(SceneryPanel.class, (String)"dialog.warn"), 0, 2)) == 0) {
            LOGGER.info("Save the scenery");
            this.detailsModel.triggerCommit();
        }
        if ((dmxScenery = (DmxScenery)this.sceneryList.getSelectedValue()) == null || dmxScenery.getSceneryPoints().size() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.bottomDetailsPanel), Resources.getString(SceneryPanel.class, (String)"dialog.no_scenery_or_points"), Resources.getString(SceneryPanel.class, (String)"dialog.export_error"), 0);
            return;
        }
        if (dmxScenery.getMacroNumber() == null) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.bottomDetailsPanel), Resources.getString(SceneryPanel.class, (String)"dialog.no_scenery_selected"), Resources.getString(SceneryPanel.class, (String)"dialog.export_error"), 0);
            return;
        }
        LOGGER.info("Transform selected scenery: {}", (Object)dmxScenery);
        Macro selectedMacro = null;
        for (Macro currentMacro : this.dmxSceneryModel.getMacros()) {
            if (currentMacro == null || currentMacro.getId() != dmxScenery.getMacroNumber().intValue()) continue;
            selectedMacro = currentMacro;
            break;
        }
        if (selectedMacro == null) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.bottomDetailsPanel), Resources.getString(SceneryPanel.class, (String)"dialog.selected_macro_not_available", (Object[])new Object[]{dmxScenery.getMacroNumber()}), Resources.getString(SceneryPanel.class, (String)"dialog.export_error"), 0);
            return;
        }
        selectedMacro.initialize();
        Collections.sort(dmxScenery.getSceneryPoints(), new /* Unavailable Anonymous Inner Class!! */);
        int currentDelay = 0;
        int prevTimeOffset = 0;
        ArrayList<String> pointsWithErrors = new ArrayList<String>();
        String errorToAdd = null;
        ArrayList<Object> functions = new ArrayList<Object>();
        TreeSet<Integer> delaySet = new TreeSet<Integer>();
        Object prevDmxSceneryPoint = null;
        for (Object dmxSceneryPoint : dmxScenery.getSceneryPoints()) {
            LOGGER.debug("Current point: {}", dmxSceneryPoint);
            if (prevDmxSceneryPoint != null && prevDmxSceneryPoint.getPort() != null) {
                if (prevDmxSceneryPoint.getPort() instanceof DmxLightPort) {
                    if (prevDmxSceneryPoint.getAction() == null || prevDmxSceneryPoint.getAction().equals(LightPortStatus.UP) || prevDmxSceneryPoint.getAction().equals(LightPortStatus.DOWN)) {
                        LOGGER.info("Adjust the action for lightport: {}", (Object)prevDmxSceneryPoint.getPort());
                        if (dmxSceneryPoint.getBrightness() >= prevDmxSceneryPoint.getBrightness()) {
                            prevDmxSceneryPoint.setAction((BidibStatus)LightPortStatus.UP);
                        } else {
                            prevDmxSceneryPoint.setAction((BidibStatus)LightPortStatus.DOWN);
                        }
                    }
                } else if (prevDmxSceneryPoint.getPort() instanceof BacklightPort && prevDmxSceneryPoint.getAction() == null) {
                    prevDmxSceneryPoint.setAction((BidibStatus)BacklightPortStatus.START);
                }
            }
            prevDmxSceneryPoint = dmxSceneryPoint;
        }
        int currentIndex = 0;
        for (Object dmxSceneryPoint : dmxScenery.getSceneryPoints()) {
            LOGGER.debug("Current point: {}", dmxSceneryPoint);
            if (errorToAdd != null) {
                pointsWithErrors.add(errorToAdd);
                errorToAdd = null;
            }
            if (dmxSceneryPoint.getPort() != null && dmxSceneryPoint.getAction() == null) {
                if (dmxSceneryPoint.getPort() instanceof BacklightPort && currentIndex == dmxScenery.getSceneryPoints().size() - 1) {
                    LOGGER.info("The last point has a backlight port assigned but no action. Set the start action and ignore this error.");
                    dmxSceneryPoint.setAction((BidibStatus)BacklightPortStatus.START);
                } else {
                    LOGGER.warn("The scenery point has no action assigned. Remove port or set an action, point: {}", dmxSceneryPoint);
                    pointsWithErrors.add(Resources.getString(SceneryPanel.class, (String)"error-port-without-action", (Object[])new Object[]{dmxSceneryPoint.getTimeOffset(), dmxSceneryPoint.getDmxChannelNumber()}));
                }
            } else if (dmxSceneryPoint.getMacro() == null && dmxSceneryPoint.getPort() == null) {
                LOGGER.warn("The scenery point has no port and no macro assigned: {}", dmxSceneryPoint);
                errorToAdd = Resources.getString(SceneryPanel.class, (String)"error-port-without-port-or-macro", (Object[])new Object[]{dmxSceneryPoint.getTimeOffset(), dmxSceneryPoint.getDmxChannelNumber()});
            }
            int timeOffset = dmxSceneryPoint.getTimeOffset();
            if (timeOffset > 0) {
                currentDelay = timeOffset - prevTimeOffset;
                LOGGER.info("Add a delay: {}", (Object)currentDelay);
                delaySet.add(currentDelay);
            }
            prevTimeOffset = timeOffset;
            ++currentIndex;
        }
        if (CollectionUtils.isNotEmpty(pointsWithErrors)) {
            StringBuffer sb = new StringBuffer(Resources.getString(SceneryPanel.class, (String)"message.errors_detected"));
            for (String errorMessage : pointsWithErrors) {
                sb.append(errorMessage).append("\n");
            }
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.bottomDetailsPanel), sb.toString(), Resources.getString(SceneryPanel.class, (String)"dialog.export_error"), 0);
            return;
        }
        Integer minDelay = (Integer)delaySet.first();
        Integer maxDelay = (Integer)delaySet.last();
        int slowdown = SceneryUtils.calculateSlowdown(delaySet);
        LOGGER.info("minDelay: {}, maxDelay: {}, slowdown: {}", new Object[]{minDelay, maxDelay, slowdown});
        currentDelay = 0;
        prevTimeOffset = 0;
        int delay = 0;
        for (DmxSceneryPoint dmxSceneryPoint : dmxScenery.getSceneryPoints()) {
            LOGGER.info("Current point: {}", (Object)dmxSceneryPoint);
            int timeOffset = dmxSceneryPoint.getTimeOffset();
            if (timeOffset > 0) {
                currentDelay = timeOffset - prevTimeOffset;
                LOGGER.info("Current timeoffset: {}, prevTimeOffset: {}, current delay: {}, slowdown: {}", new Object[]{timeOffset, prevTimeOffset, currentDelay, slowdown});
                int remaining = currentDelay % (slowdown * 20);
                LOGGER.info("Current delay: {}, calculated delay: {}, remaining: {}", new Object[]{currentDelay, delay, remaining});
                for (delay = currentDelay / (slowdown * 20); delay > 255; delay -= 255) {
                    LOGGER.info("Add a current delay: {}, with slowdown corrected: {}", (Object)currentDelay, (Object)delay);
                    functions.add(((DelayFunction.DelayFunctionBuilder)DelayFunction.DelayFunctionBuilder.delayFunction().withDelay(delay > 255 ? 255 : delay)).build());
                }
            }
            prevTimeOffset = timeOffset;
            if (dmxSceneryPoint.getPort() != null) {
                Port port = dmxSceneryPoint.getPort();
                LOGGER.info("Current port: {}, remaining delay: {}, brightness: {}", new Object[]{port, delay, dmxSceneryPoint.getBrightness()});
                if (port instanceof DmxLightPort) {
                    DmxLightPort dmxLightPort = (DmxLightPort)port;
                    LightPortAction action = ((LightPortAction.LightPortActionBuilder)((LightPortAction.LightPortActionBuilder)((LightPortAction.LightPortActionBuilder)LightPortAction.LightPortActionBuilder.lightPortAction().withAction(dmxSceneryPoint.getAction())).withDelay(delay)).withPort(dmxLightPort.getLightPort())).build();
                    functions.add(action);
                    continue;
                }
                if (!(port instanceof BacklightPort)) continue;
                List seriesPoints = (List)CollectionUtils.select((Iterable)dmxScenery.getSceneryPoints(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                Collections.sort(seriesPoints, new /* Unavailable Anonymous Inner Class!! */);
                int targetBrightness = 100;
                if (seriesPoints.size() > 0) {
                    DmxSceneryPoint nextDmxSceneryPoint = (DmxSceneryPoint)seriesPoints.get(0);
                    targetBrightness = nextDmxSceneryPoint.getBrightness();
                } else {
                    LOGGER.info("No further scenery points available, use the brightness of the current point.");
                    targetBrightness = dmxSceneryPoint.getBrightness();
                }
                BacklightPortAction action = ((BacklightPortAction.BacklightPortActionBuilder)((BacklightPortAction.BacklightPortActionBuilder)((BacklightPortAction.BacklightPortActionBuilder)((BacklightPortAction.BacklightPortActionBuilder)BacklightPortAction.BacklightPortActionBuilder.backlightPortAction().withAction(BacklightPortStatus.START)).withDelay(delay)).withPort((BacklightPort)port)).withBrightness(targetBrightness)).build();
                functions.add(action);
                continue;
            }
            if (dmxSceneryPoint.getMacro() == null) continue;
            MacroFunction macro = dmxSceneryPoint.getMacro();
            LOGGER.info("Current point contains a macro: {}", (Object)macro);
            functions.add(macro);
        }
        selectedMacro.setSpeed(slowdown);
        selectedMacro.setFunctions(functions);
    }

    private void potentiallyShowPopup(MouseEvent e) {
        JPopupMenu popupMenu = null;
        if (e.isPopupTrigger()) {
            TreePath selPath = this.usedChannelsTree.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                this.usedChannelsTree.getSelectionModel().addSelectionPath(selPath);
            }
            Object selectedComponent = null;
            if (this.usedChannelsTree.getSelectionModel().getLeadSelectionPath() != null) {
                selectedComponent = this.usedChannelsTree.getSelectionModel().getLeadSelectionPath().getLastPathComponent();
            }
            if ((popupMenu = this.buildPopup(selectedComponent)).getComponentCount() > 0) {
                popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    private JPopupMenu buildPopup(Object selectedComponent) {
        JPopupMenu pm = new JPopupMenu();
        if (selectedComponent instanceof DmxChannelNode) {
            LOGGER.info("A DmxChannelNode is selected: {}", selectedComponent);
            JMenuItem removeChannel = new JMenuItem((Action)new RemoveChannelAction(this, Resources.getString(this.getClass(), (String)"menu.remove-dmx-channel"), (DmxChannelNode)selectedComponent));
            if (this.detailsModel.isBuffering()) {
                removeChannel.setEnabled(false);
            }
            pm.add(removeChannel);
            pm.add((Action)new /* Unavailable Anonymous Inner Class!! */);
            pm.add((Action)new /* Unavailable Anonymous Inner Class!! */);
            pm.addSeparator();
            pm.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        } else if (selectedComponent instanceof PortNode) {
            LOGGER.info("A PortNode is selected: {}", selectedComponent);
            PortNode portNode = (PortNode)selectedComponent;
            pm.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        } else if (selectedComponent == null && this.detailsModel.getBean() != null) {
            pm.add((Action)new /* Unavailable Anonymous Inner Class!! */);
        }
        return pm;
    }

    private JComponent buildButtonBar() {
        return new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.applyButton, this.resetButton}).build();
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.detailsModel, "validation");
        LOGGER.info("Current name: '{}'", (Object)this.sceneryNameModel.getString());
        if (StringUtils.isBlank((CharSequence)this.sceneryNameModel.getString())) {
            support.addError("sceneryname_key", "not_empty");
        }
        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        if (this.detailsModel.getBean() == null) {
            this.validationResultModel.setResult(new ValidationResult());
        } else {
            ValidationResult validationResult = this.validate();
            this.validationResultModel.setResult(validationResult);
            LOGGER.debug("Set the writeButtonEnabled, validStateNoWarnOrErrors: {}, validState: {}", (Object)this.validationResultModel.getValidStateNoWarnOrErrors(), (Object)this.validationResultModel.getValidState());
        }
        this.applyButtonEnabled.setModelValid(this.validationResultModel.getValidStateNoWarnOrErrors());
    }

    protected ValidationResultModel getValidationResultModel() {
        return this.validationResultModel;
    }

    private void updateView(DmxScenery dmxScenery) {
        LOGGER.info("Set the dmxScenery: {}", (Object)dmxScenery);
        if (this.detailsModel.isBuffering()) {
            LOGGER.warn("The details model is buffering.");
        }
        this.detailsModel.triggerFlush();
        this.detailsModel.setBean((Object)dmxScenery);
        this.detailsModel.resetChanged();
    }

    private void setUsedDmxChannels(List<DmxChannel> dmxChannels) {
        this.root.removeAllChildren();
        for (DmxChannel dmxChannel : dmxChannels) {
            LOGGER.info("Add new dmxChannel as node: {}", (Object)dmxChannel);
            DmxChannelNode channelNode = new DmxChannelNode(dmxChannel);
            boolean inserted = false;
            for (int index = 0; index < this.root.getChildCount(); ++index) {
                DmxChannelNode childNode = (DmxChannelNode)this.root.getChildAt(index);
                DmxChannel currentChannel = childNode.getDmxChannel();
                if (currentChannel.getChannelId() <= dmxChannel.getChannelId()) continue;
                LOGGER.info("Found index to insert new node: {}", (Object)index);
                this.root.insert((MutableTreeNode)channelNode, index);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.root.add((MutableTreeNode)channelNode);
            }
            if (!CollectionUtils.isNotEmpty((Collection)dmxChannel.getAssignedPorts())) continue;
            LinkedList sortedPorts = new LinkedList(dmxChannel.getAssignedPorts());
            Collections.sort(sortedPorts, new /* Unavailable Anonymous Inner Class!! */);
            for (Port port : sortedPorts) {
                LOGGER.info("Add new port as node: {}", (Object)port);
                PortNode portNode = new PortNode(port);
                channelNode.add((MutableTreeNode)portNode);
            }
        }
        this.usedChannelsTreeModel.reload();
        this.expandAllNodes(this.usedChannelsTree, this.root, 2);
    }

    private void refreshPortsOfDmxChannel(DmxChannel dmxChannel) {
        LOGGER.info("Refresh ports of DMX channel: {}", (Object)dmxChannel);
        DmxChannelNode nodeToRefresh = null;
        for (int index = 0; index < this.root.getChildCount(); ++index) {
            DmxChannelNode childNode = (DmxChannelNode)this.root.getChildAt(index);
            DmxChannel currentChannel = childNode.getDmxChannel();
            LOGGER.debug("Check current dmx channel: {}", (Object)currentChannel);
            if (currentChannel.getChannelId() != dmxChannel.getChannelId()) continue;
            LOGGER.info("Found node to refresh: {}", (Object)childNode);
            nodeToRefresh = childNode;
            childNode.removeAllChildren();
            if (!CollectionUtils.isNotEmpty((Collection)dmxChannel.getAssignedPorts())) break;
            LinkedList sortedPorts = new LinkedList(dmxChannel.getAssignedPorts());
            Collections.sort(sortedPorts, new /* Unavailable Anonymous Inner Class!! */);
            for (Port port : sortedPorts) {
                LOGGER.info("Add new port as node: {}", (Object)port);
                PortNode portNode = new PortNode(port);
                childNode.add((MutableTreeNode)portNode);
            }
            break;
        }
        this.usedChannelsTreeModel.reload((TreeNode)nodeToRefresh);
        this.expandNode(this.usedChannelsTree, nodeToRefresh);
    }
}

