/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.util.Map;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvData;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.ReverserPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabStatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReverserPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReverserPanelController.class);
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;
    private ReverserPanel reverserPanel;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;

    public ReverserPanelController(MainModel mainModel, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, TabVisibilityListener tabVisibilityListener) {
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
    }

    public void start(TabStatusListener tabStatusListener) {
        this.reverserPanel = new ReverserPanel(this, this.feedbackPortStatusChangeProvider, this.mainModel, tabStatusListener);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ReverserPanel getReverserPanel() {
        return this.reverserPanel;
    }

    public Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node) {
        LOGGER.info("Get the cvNumberToNodeMap for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
        if (cvContainer != null) {
            return cvContainer.getCvNumberToNodeMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvDefinitionTreeTableModel getCvDefinitionTreeTableModel(NodeInterface node) {
        LOGGER.info("Get the cvDefinitionTreeTableModel for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = null;
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            if (cvContainer == null && node.getVendorCV() != null) {
                LOGGER.info("No cvContainer found but vendorCV available. Prepare the vendorCV tree for node: {}", (Object)node);
                VendorCvData vendorCV = node.getVendorCV();
                this.cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, vendorCV, false);
                cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            }
        }
        if (cvContainer != null) {
            return cvContainer.getCvTreeModel();
        }
        return null;
    }
}

