/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.menu;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.listener.MacroListener;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroTableMenuListener;

public class MacroTableMenu
extends BasicPopupMenu
implements MacroListener {
    private static final long serialVersionUID = 1L;
    public static final KeyStroke KEYSTROKE_CUT = KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    public static final KeyStroke KEYSTROKE_COPY = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    public static final KeyStroke KEYSTROKE_PASTE = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    public static final KeyStroke KEYSTROKE_DELETE = KeyStroke.getKeyStroke(127, 0);
    private final Collection<MacroTableMenuListener> menuListeners = new LinkedList();
    private final JMenuItem cut = new JMenuItem(Resources.getString(this.getClass(), (String)"cut"));
    private final JMenuItem copy = new JMenuItem(Resources.getString(this.getClass(), (String)"copy"));
    private final JMenuItem pasteBefore = new JMenuItem(Resources.getString(this.getClass(), (String)"pasteBefore"));
    private final JMenuItem pasteAfter = new JMenuItem(Resources.getString(this.getClass(), (String)"pasteAfter"));
    private final JMenuItem pasteInvertedAfter = new JMenuItem(Resources.getString(this.getClass(), (String)"pasteInvertedAfter"));
    private final JMenuItem insertEmptyBefore = new JMenuItem(Resources.getString(this.getClass(), (String)"insertEmptyBefore"));
    private final JMenuItem insertEmptyAfter = new JMenuItem(Resources.getString(this.getClass(), (String)"insertEmptyAfter"));
    private final JMenuItem delete = new JMenuItem(Resources.getString(this.getClass(), (String)"delete"));
    private final JMenuItem selectAll = new JMenuItem(Resources.getString(this.getClass(), (String)"selectAll"));
    private Macro macro = null;

    public MacroTableMenu(MainModel model) {
        this.cut.setAccelerator(KEYSTROKE_CUT);
        this.cut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.cut);
        this.copy.setAccelerator(KEYSTROKE_COPY);
        this.copy.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.copy);
        this.pasteBefore.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.pasteBefore);
        this.pasteAfter.setAccelerator(KEYSTROKE_PASTE);
        this.pasteAfter.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.pasteAfter);
        this.pasteInvertedAfter.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.pasteInvertedAfter);
        this.insertEmptyBefore.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.insertEmptyBefore);
        this.insertEmptyAfter.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.insertEmptyAfter);
        this.delete.setAccelerator(KEYSTROKE_DELETE);
        this.delete.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.delete);
        this.addSeparator();
        this.selectAll.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.selectAll.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectAll.setEnabled(false);
        this.add(this.selectAll);
        model.addMacroSelectionListener((MacroSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addMenuListener(MacroTableMenuListener l) {
        this.menuListeners.add(l);
    }

    private void enableMenuItems(Macro macro) {
        if (macro != null) {
            boolean macroEmpty = macro.getFunctionCount() == 0;
            boolean macroFull = macro.getFunctionCount() >= macro.getFunctionSize();
            this.cut.setEnabled(!macroEmpty);
            this.copy.setEnabled(!macroEmpty);
            this.pasteBefore.setEnabled(!macroFull);
            this.pasteAfter.setEnabled(!macroFull);
            this.insertEmptyBefore.setEnabled(!macroFull);
            this.insertEmptyAfter.setEnabled(!macroFull);
            this.delete.setEnabled(!macroEmpty);
            this.selectAll.setEnabled(!macroEmpty);
        } else {
            this.cut.setEnabled(false);
            this.copy.setEnabled(false);
            this.pasteBefore.setEnabled(true);
            this.pasteAfter.setEnabled(true);
            this.insertEmptyBefore.setEnabled(true);
            this.insertEmptyAfter.setEnabled(true);
            this.delete.setEnabled(false);
            this.selectAll.setEnabled(false);
        }
    }

    public void fireCopy() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.copy();
        }
    }

    public void fireCut() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.cut();
        }
    }

    public void fireDelete() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.delete();
        }
    }

    private void fireInsertEmptyAfter() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.insertEmptyAfter();
        }
    }

    private void fireInsertEmptyBefore() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.insertEmptyBefore();
        }
    }

    public void firePasteAfter() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.pasteAfter();
        }
    }

    public void firePasteInvertedAfter() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.pasteInvertedAfter();
        }
    }

    private void firePasteBefore() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.pasteBefore();
        }
    }

    private void fireSelectAll() {
        for (MacroTableMenuListener l : this.menuListeners) {
            l.selectAll();
        }
    }

    private Macro getMacro() {
        return this.macro;
    }

    private void setMacro(Macro macro) {
        this.macro = macro;
    }

    public void functionsAdded(int row, Function<? extends BidibStatus>[] functions) {
        this.enableMenuItems(this.macro);
    }

    public void functionRemoved(int row) {
        this.enableMenuItems(this.macro);
    }

    public void functionsRemoved() {
        this.enableMenuItems(this.macro);
    }

    public void labelChanged(String label) {
    }

    public void functionMoved(int fromIndex, int toIndex, Function<? extends BidibStatus> fromFunction) {
    }

    public void startConditionChanged() {
    }

    public void slowdownFactorChanged() {
    }

    public void cyclesChanged() {
    }
}

