/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.IoBehaviourInputCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortEditorPanel
extends AbstractPortEditorPanel<InputPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private ValueModel switchOffTimeConverterModel;
    private ValueModel selectionHolderIoBehaviour;
    private JTextField portName;
    private JTextField switchOffTimeText;
    private JComboBox<IoBehaviourInputEnum> comboIoBehaviour;

    public InputPortEditorPanel(InputPort port, Consumer<InputPort> saveCallback, Consumer<InputPort> refreshCallback, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, null, refreshCallback, nodeSelectionProvider);
    }

    protected InputPort clonePort(InputPort port) {
        InputPort clone = (InputPort)InputPort.builder().withInputBehaviour(port.getInputBehaviour()).withSwitchOffTime(port.getSwitchOffTime()).withStatus((BidibStatus)((InputPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        return clone;
    }

    protected JPanel doCreateComponent(InputPort port) {
        AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        int row = 1;
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, 1);
        this.portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        this.portName.setEnabled(port.isEnabled());
        dialogBuilder.add((Component)this.portName).xyw(3, row, 3);
        row += 2;
        this.switchOffTimeConverterModel = new ConverterValueModel((ValueModel)this.getPresentationModel().getBufferedModel("switchOffTime"), (BindingConverter)new StringToIntegerConverter());
        if (this.isPortConfigKeySupported((byte)11)) {
            this.switchOffTimeText = new JTextField();
            IntegerInputValidationDocument switchOffTimeDocument = new IntegerInputValidationDocument(5, "0123456789");
            switchOffTimeDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255));
            this.switchOffTimeText.setDocument((Document)switchOffTimeDocument);
            this.switchOffTimeText.setColumns(2);
            this.switchOffTimeText.setHorizontalAlignment(4);
            Bindings.bind((JTextField)this.switchOffTimeText, (ValueModel)this.switchOffTimeConverterModel, (boolean)false);
            dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"switchOffTime"), new Object[0]).xy(1, 3);
            dialogBuilder.add((Component)this.switchOffTimeText).xy(3, row);
            ValidationComponentUtils.setMandatory((JComponent)this.switchOffTimeText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.switchOffTimeText, (Object[])new Object[]{"validation.switchOffTime_key"});
            row += 2;
        }
        this.selectionHolderIoBehaviour = this.getPresentationModel().getBufferedModel("inputBehaviour");
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_INPUT_CTRL)) {
            ArrayListModel ioBehaviourList = new ArrayListModel();
            for (IoBehaviourInputEnum value : IoBehaviourInputEnum.values()) {
                ioBehaviourList.add((Object)value);
            }
            SelectionInList ioBehaviourSelection = new SelectionInList((ListModel)ioBehaviourList);
            ComboBoxAdapter comboBoxAdapterIoBehaviour = new ComboBoxAdapter((ListModel)ioBehaviourSelection, this.selectionHolderIoBehaviour);
            this.comboIoBehaviour = new JComboBox();
            this.comboIoBehaviour.setModel(comboBoxAdapterIoBehaviour);
            this.comboIoBehaviour.setRenderer(new IoBehaviourInputCellRenderer());
            dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"ioBehaviour") + ":", new Object[0]).xy(1, 5);
            dialogBuilder.add((Component)this.comboIoBehaviour).xy(3, row);
            row += 2;
        }
        JPanel buttonPanel = this.createButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row, 5);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogBuilder.build());
            AbstractPortEditorPanel.PortEditorPanelContainer panel2 = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel2);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.setPanel(feedbackBuilder.build());
        } else {
            this.setPanel(dialogBuilder.build());
        }
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        this.switchOffTimeConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        this.selectionHolderIoBehaviour.addValueChangeListener(evt -> this.triggerValidation());
        this.enableComponents();
        this.triggerValidation();
        return this.getPanel();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        SwingUtilities.invokeLater(() -> {
            try {
                switch (evt.getPropertyName()) {
                    case "status": {
                        LOGGER.info("The port status has changed: {}", evt.getNewValue());
                        break;
                    }
                    case "portConfigChanged": {
                        break;
                    }
                    case "portTypeChanged": {
                        LOGGER.info("The port type has changed: {}", evt.getNewValue());
                        this.enableComponents();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Update the status failed.", (Throwable)ex);
            }
        });
    }

    protected ValidationResult validate(InputPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.switchOffTimeText != null && this.switchOffTimeConverterModel.getValue() == null) {
            support.addError("switchOffTime_key", "not_empty_for_write");
        }
        if (this.comboIoBehaviour != null && this.selectionHolderIoBehaviour.getValue() == null) {
            support.addError("ioBehaviour_key", "not_empty_for_write");
        }
        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void doEnableComponents(InputPort port) {
        boolean enabled = port.isEnabled();
        this.portName.setEnabled(enabled);
        if (this.comboIoBehaviour != null) {
            this.comboIoBehaviour.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_INPUT_CTRL));
        }
        if (this.switchOffTimeText != null) {
            this.switchOffTimeText.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_TICKS));
        }
    }
}

