package org.bidib.wizard.mvc.common.view.converter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.value.BindingConverter;

public class StringToLocalDateTimeConverter implements BindingConverter<LocalDateTime, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToLocalDateTimeConverter.class);

    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");

    @Override
    public String targetValue(LocalDateTime sourceValue) {

        if (sourceValue != null) {
            return dateTimeFormatter.format(sourceValue);
        }
        return null;
    }

    @Override
    public LocalDateTime sourceValue(String targetValue) {

        if (StringUtils.isNotBlank(targetValue)) {
            try {
                return LocalDateTime.parse(targetValue, dateTimeFormatter);
            }
            catch (Exception ex) {
                LOGGER
                    .warn("Parse string to LocalDateTime failed, value: {}, message: {}", targetValue, ex.getMessage());
            }
        }
        return null;
    }

}
