package org.bidib.wizard.mvc.main.view.panel.nodetree;

import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.DefaultExpandableRow;

public class JideNodeTreeNode extends DefaultExpandableRow {

    private static final Logger LOGGER = LoggerFactory.getLogger(JideNodeTreeNode.class);

    private NodeInterface node;

    public JideNodeTreeNode(NodeInterface node) {
        this.node = node;
    }

    public NodeInterface getNode() {
        return node;
    }

    /**
     * @return the identifyState
     */
    public IdentifyState getIdentifyState() {
        if (node != null) {
            return node.getIdentifyState();
        }
        return null;
    }

    /**
     * @return the error state
     */
    public SysErrorEnum getErrorState() {
        if (node != null) {
            return node.getErrorState();
        }
        return null;
    }

    @Override
    public Object getValueAt(int column) {
        NodeInterface node = getNode();
        LOGGER.trace("Get value for column: {}", column);
        switch (column) {
            case 0:
                return node;
            case 1:
                return ByteUtils.formatHexUniqueId(node.getUniqueId());
            case 2:
                return NodeUtils.formatAddressLong(node.getAddr());
            default:
                break;
        }

        return null;
    }

}
