package org.bidib.wizard.mvc.main.view.panel.nodetree;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TreeTableModel;

public class JideNodeTreeTableModel extends TreeTableModel<DefaultExpandableRow> implements StyleModel {

    private static final long serialVersionUID = 1L;

    public static final int COLUMN_NAME = 0;

    public static final int COLUMN_UNIQUE = 1;

    public static final int COLUMN_ADDRESS = 2;

    private final String[] columnNames;

    private CellStyle styleDefault = new CellStyle();

    public JideNodeTreeTableModel() {
        super();

        this.columnNames =
            new String[] { //
                Resources.getString(getClass(), "column.name"), //
                Resources.getString(getClass(), "column.uniqueId"), //
                Resources.getString(getClass(), "column.address") //
            };
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Class<?> getCellClassAt(int rowIndex, int columnIndex) {

        if (columnIndex == COLUMN_NAME) {
            return JideNodeTreeNode.class;
        }
        return super.getCellClassAt(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellStyleOn() {
        return true;
    }

    @Override
    public CellStyle getCellStyleAt(int row, int column) {
        Row rowAt = getRowAt(row);
        CellStyle style = styleDefault;

        if (rowAt instanceof JideNodeTreeNode) {

            final JideNodeTreeNode jideNodeTreeNode = (JideNodeTreeNode) rowAt;
            final NodeInterface node = jideNodeTreeNode.getNode();

            switch (column) {
                case COLUMN_NAME:
                    style = new CellStyle(style);
                    // style.setIcon(null);
                    break;
                default:
                    break;
            }
        }
        return style;
    }

}
