package org.bidib.wizard.mvc.pom.model;

import java.util.LinkedList;
import java.util.List;

import javax.swing.SwingUtilities;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.wizard.mvc.pom.model.listener.ConfigVariableListener;
import org.bidib.wizard.mvc.pom.model.listener.ProgCommandListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;

public class PomProgrammerModel extends Model {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PomProgrammerModel.class);

    public static final String PROPERTYNAME_COMMANDSTATIONSTATE = "commandStationState";

    public static final String PROPERTYNAME_POMPROGSTATE = "pomProgState";

    public static final String PROPERTYNAME_CVNUMBER = "cvNumber";

    public static final String PROPERTYNAME_CVVALUE = "cvValue";

    private final List<ConfigVariableListener> listeners = new LinkedList<ConfigVariableListener>();

    private final List<ProgCommandListener> progCommandListeners = new LinkedList<ProgCommandListener>();

    private Integer cvNumber;

    private Integer cvValue;

    private CommandStationState commandStationState;

    private PomProgState pomProgState;

    public void addConfigVariableListener(ConfigVariableListener l) {
        listeners.add(l);
    }

    public void removeConfigVariableListener(ConfigVariableListener l) {
        listeners.remove(l);
    }

    public void addProgCommandListener(ProgCommandListener l) {
        progCommandListeners.add(l);
    }

    public void removeProgCommandListener(ProgCommandListener l) {
        progCommandListeners.remove(l);
    }

    /**
     * @return the CV number
     */
    public Integer getCvNumber() {
        return cvNumber;
    }

    /**
     * @param cvNumber
     *            the CV number to set
     */
    public void setCvNumber(Integer cvNumber) {
        LOGGER.info("Set the CV number: {}", cvNumber);
        Integer oldNumber = this.cvNumber;
        this.cvNumber = cvNumber;
        firePropertyChange(PROPERTYNAME_CVNUMBER, oldNumber, cvNumber);
    }

    public Integer getCvValue() {
        return cvValue;
    }

    public void setCvValue(Integer value) {
        LOGGER.info("Set the CV value: {}", value);

        Integer oldValue = cvValue;
        this.cvValue = value;
        firePropertyChange(PROPERTYNAME_CVVALUE, oldValue, cvValue);
    }

    public void clearCvValue() {
        LOGGER.debug("Clear the CV value.");
        Integer oldValue = cvValue;
        cvValue = null;
        firePropertyChange(PROPERTYNAME_CVVALUE, oldValue, cvValue);
    }

    /**
     * @return the commandStationState
     */
    public CommandStationState getCommandStationState() {
        return commandStationState;
    }

    /**
     * @param commandStationState
     *            the commandStationState to set
     */
    public void setCommandStationState(CommandStationState commandStationState) {
        LOGGER.info("Set the new command station state: {}", commandStationState);
        CommandStationState oldCommandStationState = this.commandStationState;
        this.commandStationState = commandStationState;

        firePropertyChange(PROPERTYNAME_COMMANDSTATIONSTATE, oldCommandStationState, commandStationState);
    }

    /**
     * @return the pomProgState
     */
    public PomProgState getPomProgState() {
        return pomProgState;
    }

    /**
     * @param pomProgState
     *            the pomProgState to set
     */
    public void setPomProgState(PomProgState pomProgState) {
        PomProgState oldValue = this.pomProgState;

        LOGGER.info("Set the POM prog state: {}, oldValue: {}", pomProgState, oldValue);
        this.pomProgState = pomProgState;

        firePropertyChange(PROPERTYNAME_POMPROGSTATE, oldValue, pomProgState);
    }

    public void updatePomProgResult(
        final PomProgState pomProgState, final PomAddressData decoderAddress, final int cvNumber, final int cvValue) {
        LOGGER
            .info("update the POM prog result: {}, decoderAddress: {}, cvNumber: {}, cvValue: {}", pomProgState,
                decoderAddress, cvNumber, cvValue);

        if (SwingUtilities.isEventDispatchThread()) {
            notifyPomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
        }
        else {
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    notifyPomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
                }
            });
        }
    }

    private void notifyPomProgResult(
        final PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {

        if (this.cvNumber != null && cvNumber == this.cvNumber) {
            if (PomProgState.POM_PROG_OKAY.equals(pomProgState)) {
                // TODO do something with the decoder address and cv number

                LOGGER.info("The POM prog was successful, cvNumber: {}, cvValue: {}", cvNumber, cvValue);

                setCvValue(cvValue);
            }

            setPomProgState(pomProgState);

            // TODO signal that all values returned from the new state are set ...

            fireProgCommandFinished(pomProgState);
        }
        else {
            LOGGER
                .warn("The provided CV number ({}) does not match the processing cvNumber: {}", cvNumber,
                    this.cvNumber);
        }
    }

    private void fireProgCommandFinished(PomProgState pomProgState) {
        for (ProgCommandListener l : progCommandListeners) {
            l.progPomFinished(pomProgState);
        }
    }
}
