package org.bidib.wizard.mvc.preferences.view.panel;

import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;

import com.jgoodies.binding.value.BindingConverter;

public class StringToNetBidibUniqueIdConverter implements BindingConverter<Long, String> {

    private final byte vid;

    private final byte pidLow;

    private final byte pidHigh;

    public StringToNetBidibUniqueIdConverter(int vid, int pid) {
        this.vid = ByteUtils.getLowByte(vid);
        this.pidLow = ByteUtils.getLowByte(pid);
        this.pidHigh = ByteUtils.getHighByte(pid);
    }

    @Override
    public String targetValue(Long sourceValue) {
        if (sourceValue != null) {

            String uniqueIdValue = Long.toString(sourceValue, 16);
            return StringUtils.leftPad(StringUtils.right(uniqueIdValue, 4), 4, '0').toUpperCase();
        }
        return null;
    }

    @Override
    public Long sourceValue(String targetValue) {

        if (targetValue != null) {
            Long value = Long.valueOf(StringUtils.leftPad(targetValue, 4, '0'), 16);
            byte[] uniqueId = new byte[] { 0x00, 0x00, vid, pidLow, pidHigh, 0x00, 0x00 };
            long basicUniqueId = ByteUtils.convertUniqueIdToLong(uniqueId);
            value = basicUniqueId | value.longValue();
            return value;
        }
        return null;
    }

}
