package org.bidib.wizard.mvc.stepcontrol.view.wizard;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.bidib.wizard.mvc.stepcontrol.model.TurnTableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class TableTypePanel extends AbstractWizardPanel {

    private static final Logger LOGGER = LoggerFactory.getLogger(TableTypePanel.class);

    private ConfigurationWizardModel configurationWizardModel;

    private ValueModel turnTableTypeModel;

    private JComponent[] turnTableTypeButtons;

    public TableTypePanel(final JWizardComponents wizardComponents,
        final ConfigurationWizardModel configurationWizardModel) {
        super(wizardComponents);

        this.configurationWizardModel = configurationWizardModel;
    }

    @Override
    protected void initPanel() {
        super.initPanel();

        boolean debug = false;
        FormBuilder builder =
            FormBuilder
                .create().columns("p, 3dlu, p:g").rows("p, 3dlu, p").panel(debug ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.TABBED_DIALOG);

        builder.add(Resources.getString(getClass(), "message")).xyw(1, 1, 3);

        // add the components
        turnTableTypeModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_TURNTABLE_TYPE, true);
        turnTableTypeButtons = new JComponent[TurnTableType.values().length];
        int index = 0;

        FormBuilder turnTableTypeBuilder = FormBuilder.create().columns("pref").rows("p, 3dlu, p");

        int line = 1;
        for (TurnTableType turnTableType : TurnTableType.values()) {

            if (turnTableType == TurnTableType.unknown || turnTableType.getKey() == null) {
                continue;
            }
            String iconKey = Resources.getString(TurnTableType.class, turnTableType.getKey() + ".icon");
            ImageIcon radioIcon = ImageUtils.createImageIcon(getClass(), "/icons/stepcontrol/" + iconKey);

            JRadioButton radio =
                createRadioButton(turnTableTypeModel, turnTableType,
                    Resources.getString(TurnTableType.class, turnTableType.getKey()), radioIcon.toString());
            turnTableTypeButtons[index++] = radio;

            // add radio button
            turnTableTypeBuilder.add(radio).xy(1, line);
            line += 2;
        }

        builder.add(turnTableTypeBuilder.build()).xyw(1, 3, 3);

        this.panel = builder.build();

        LOGGER.info("initPanel finished.");
    }

    public static JRadioButton createRadioButton(ValueModel model, Object choice, String markedText, String iconPath) {

        JRadioButton radioButton = null;
        if (StringUtils.isNotBlank(iconPath)) {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("<div style=\"valign=\"middle\">");
            sb.append("<table><tr><td>");
            sb.append("<img src='").append(iconPath).append("'>");
            sb.append("</td>");
            sb.append("<td>");
            sb.append(markedText);
            sb.append("</td>");
            sb.append("</tr></table>");
            sb.append("</div></html>");
            LOGGER.info("Create button with html: {}", sb.toString());
            radioButton = new JRadioButton();
            radioButton.setContentAreaFilled(false);
            Bindings.bind(radioButton, model, choice);
            MnemonicUtils.configure(radioButton, markedText);

            radioButton.setText(sb.toString());

        }
        else {
            radioButton = new JRadioButton();
            radioButton.setContentAreaFilled(false);
            Bindings.bind(radioButton, model, choice);
            MnemonicUtils.configure(radioButton, markedText);
        }
        return radioButton;
    }

    @Override
    public void next() {
        // update the model

        super.next();
    }
}
