/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.debug.view;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.mvc.debug.view.FileTransferProgressDialog;
import org.bidib.wizard.mvc.debug.view.listener.DebugInterfaceViewListener;
import org.bidib.wizard.mvc.debug.view.listener.ProgressStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferProgressDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTransferProgressDialog.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, min(300dlu;pref)";
    private int result = 2;
    private final AtomicBoolean continueTransmit = new AtomicBoolean(true);
    private final ProgressStatusCallback callback;
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private final ScheduledExecutorService worker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("fileTransferProgressWorkers-thread-%d").build());

    public FileTransferProgressDialog(Component parent, boolean modal, Collection<DebugInterfaceViewListener> listeners) {
        super(JOptionPane.getFrameForComponent(parent), Resources.getString(FileTransferProgressDialog.class, (String)"title"), modal);
        this.getContentPane().setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("p, 3dlu, p", new Object[0]);
        builder.border((Border)Paddings.DIALOG);
        builder.add(Resources.getString(this.getClass(), (String)"progress"), new Object[0]).xy(1, 1);
        builder.add((Component)this.progressBar).xy(3, 1);
        this.progressBar.setStringPainted(true);
        JButton cancel = new JButton(Resources.getString(this.getClass(), (String)"cancel"));
        cancel.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton((JComponent)cancel).build();
        builder.add((Component)buttons).xyw(1, 3, 3);
        this.getContentPane().add(builder.build());
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setMinimumSize(this.getSize());
        this.callback = new /* Unavailable Anonymous Inner Class!! */;
        3 runnable = new /* Unavailable Anonymous Inner Class!! */;
        this.worker.execute((Runnable)runnable);
        this.setVisible(true);
    }

    private void fireCancel() {
        this.continueTransmit.set(false);
        this.fireClose();
    }

    private void fireClose() {
        LOGGER.info("Close the dialog.");
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                this.worker.shutdown();
                this.worker.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for termination of worker was interrupted.", (Throwable)ex);
            }
            this.setVisible(false);
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public int getResult() {
        return this.result;
    }
}

