/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.scenery;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.mvc.dmx.view.scenery.DmxChannelNode;

public class DmxChannelNodeTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DmxChannelNode) {
            DmxChannelNode dmxChannelTreeNode = (DmxChannelNode)value;
            DmxChannel dmxChannel = (DmxChannel)dmxChannelTreeNode.getUserObject();
            Color lineColor = dmxChannel.getLineColor();
            if (lineColor == null) {
                lineColor = Color.MAGENTA;
            }
            BufferedImage bufImg = new BufferedImage(16, 16, 2);
            Graphics2D g2 = bufImg.createGraphics();
            g2.setColor(lineColor);
            g2.fillOval(2, 2, 12, 12);
            g2.dispose();
            ImageIcon imic = new ImageIcon(bufImg);
            this.setIcon((Icon)imic);
        } else {
            this.setIcon(null);
        }
        return this;
    }
}

