/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.simulation.nodes.Simulation;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.RfBasisNodeInterface;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.event.BidibConnectionEvent;
import org.bidib.wizard.client.common.event.MainControllerBoosterOnEvent;
import org.bidib.wizard.client.common.event.MainControllerEvent;
import org.bidib.wizard.client.common.event.MenuEvent;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.config.BackupControllerFactory;
import org.bidib.wizard.config.ComparisonControllerFactory;
import org.bidib.wizard.config.DccAdvControllerFactory;
import org.bidib.wizard.config.DebugConsoleControllerFactory;
import org.bidib.wizard.config.DebugInterfaceControllerFactory;
import org.bidib.wizard.config.FeedbackPositionControllerFactory;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.NetDebugControllerFactory;
import org.bidib.wizard.config.SimulationControllerFactory;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.dialog.AboutDialog;
import org.bidib.wizard.firmwarerepo.client.controller.FirmwareRepoController;
import org.bidib.wizard.localhost.client.controller.LocalHostClientController;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.backup.controller.BackupController;
import org.bidib.wizard.mvc.booster.controller.BoosterTableController;
import org.bidib.wizard.mvc.comparison.controller.ComparisonController;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.debug.controller.DebugInterfaceController;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.logger.controller.LogPanelController;
import org.bidib.wizard.mvc.main.controller.DefaultMainMenuListener;
import org.bidib.wizard.mvc.main.controller.exception.CloseAbortedException;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.component.BoosterOnConfirmDialog;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.netdebug.controller.NetDebugController;
import org.bidib.wizard.mvc.nodedebug.controller.DebugConsoleController;
import org.bidib.wizard.mvc.ping.controller.PingTableController;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.preferences.controller.PreferencesController;
import org.bidib.wizard.nodes.client.controller.NodesClientController;
import org.bidib.wizard.nodescript.client.controller.NodeScriptController;
import org.bidib.wizard.script.client.controller.ScriptClientController;
import org.bidib.wizard.simulation.client.controller.SimulationController;
import org.bidib.wizard.tracer.client.controller.TracerClientController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class DefaultMainMenuListener
implements MainMenuListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMainMenuListener.class);
    private final MainView viewSupplier;
    private final DockingDesktop dockingDesktop;
    private final MainModel mainModel;
    private final SettingsService settingsService;
    private final ApplicationContext applicationContext;
    private static final String WORKING_DIR_LOGFILES_COLLECT_KEY = "logfilesCollect";
    private static final String WORKING_DIR_SIMULATION_KEY = "simulation";
    private static final String WORKING_DIR_COMPARISON_KEY = "comparison";
    private static final String SUFFIX_COMPARISON = "xml";

    public DefaultMainMenuListener(MainView viewSupplier, DockingDesktop dockingDesktop, MainModel mainModel, SettingsService settingsService, ApplicationContext applicationContext) {
        this.viewSupplier = viewSupplier;
        this.dockingDesktop = dockingDesktop;
        this.mainModel = mainModel;
        this.settingsService = settingsService;
        this.applicationContext = applicationContext;
    }

    public void about() {
        try {
            new AboutDialog((Component)this.viewSupplier.getFrame());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void exit() {
        this.applicationContext.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.stop));
    }

    public void preferences() {
        PreferencesController preferencesController = (PreferencesController)this.applicationContext.getBean(PreferencesController.class);
        try {
            preferencesController.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Start preferences controller failed.", (Throwable)ex);
        }
    }

    public void connect() {
        LOGGER.info("Let the mainController open the connection.");
        this.applicationContext.publishEvent((Object)new BidibConnectionEvent("main", BidibConnectionEvent.Action.connect));
    }

    public void disconnect() {
        LOGGER.info("Let the mainController close the connection.");
        try {
            this.applicationContext.publishEvent((Object)new BidibConnectionEvent("main", BidibConnectionEvent.Action.disconnect));
        }
        catch (CloseAbortedException ex) {
            LOGGER.warn("Close connection was aborted.");
        }
    }

    public void listenNetBidib() {
        LOGGER.info("Let the mainController listen for incoming netBidib connections.");
        this.applicationContext.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.listenNetBidib));
    }

    public void allBoosterOff() {
        LOGGER.info("Switch all boosters off!");
        this.applicationContext.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.allBoosterOff));
    }

    public void allBoosterOn() {
        LOGGER.info("Switch all boosters on!");
        int result = 2;
        CommandStationStatus requestedCommandStationState = CommandStationStatus.GO;
        if (!this.settingsService.getWizardSettings().isAllBoosterOnDoNotConfirmSwitch()) {
            BoosterOnConfirmDialog allBoosterOnConfirmDialog = new BoosterOnConfirmDialog((JFrame)JOptionPane.getFrameForComponent((Component)this.viewSupplier.getFrame()), this.settingsService);
            result = allBoosterOnConfirmDialog.getResult();
            requestedCommandStationState = allBoosterOnConfirmDialog.getCommandStationStatus();
        } else {
            result = this.settingsService.getWizardSettings().getAllBoosterOnSavedAction();
            requestedCommandStationState = this.settingsService.getWizardSettings().getAllBoosterOnRequestedCommandStationState();
            LOGGER.info("Fetched action for all booster on from preferences: {}", (Object)result);
        }
        if (2 == result) {
            LOGGER.info("User cancelled allBoosterOnConfirmDialog.");
            return;
        }
        this.applicationContext.publishEvent((Object)new MainControllerBoosterOnEvent(result == 3, requestedCommandStationState));
    }

    public void collectLogFiles() {
        LOGGER.info("Collect the logfiles.");
        String logFilePath = this.settingsService.getMiscSettings().getLogFilePath();
        if (StringUtils.isNotBlank((CharSequence)logFilePath)) {
            File logfile = new File(new File(logFilePath), "BiDiBWizard2.log");
            if (logfile.exists()) {
                LOGGER.info("Found logfile to copy: {}", (Object)logfile);
                WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_LOGFILES_COLLECT_KEY);
                FileFilter[] ff = null;
                1 dialog = new /* Unavailable Anonymous Inner Class!! */;
                dialog.setApproveButtonText(Resources.getString(DefaultMainMenuListener.class, (String)"save-under"));
                dialog.showDialog();
            } else {
                JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"copy-logfiles-not-found", (Object[])new Object[]{logFilePath}), Resources.getString(DefaultMainMenuListener.class, (String)"title-error"), 0);
            }
        } else {
            LOGGER.warn("No logFilePath available.");
        }
    }

    public void logPanel() {
        LOGGER.info("Open the log panel.");
        LogPanelController logPanelController = (LogPanelController)this.applicationContext.getBean(LogPanelController.class);
        logPanelController.start();
    }

    public void boosterTable() {
        LOGGER.info("Open the booster table.");
        BoosterTableController boosterTableController = (BoosterTableController)this.applicationContext.getBean(BoosterTableController.class);
        boosterTableController.start();
    }

    public void feedbackPositionTable() {
        LOGGER.info("Open the feedbackPosition table.");
        FeedbackPositionControllerFactory feedbackPositionControllerFactory = (FeedbackPositionControllerFactory)this.applicationContext.getBean(FeedbackPositionControllerFactory.class);
        FeedbackPositionController feedbackPositionController = feedbackPositionControllerFactory.createController(this.dockingDesktop, this.mainModel);
        feedbackPositionController.start();
    }

    public void pingTable() {
        LOGGER.info("Open the ping table.");
        PingTableController pingTableController = (PingTableController)this.applicationContext.getBean(PingTableController.class);
        pingTableController.start(this.dockingDesktop);
    }

    public void console() {
        LOGGER.info("Open the console.");
        ConsoleController.ensureConsoleVisible();
    }

    public void nodeScriptView() {
        LOGGER.info("Open the nodeScript editor.");
        NodeScriptController nodeScriptController = (NodeScriptController)this.applicationContext.getBean(NodeScriptController.class);
        nodeScriptController.showView(this.dockingDesktop, (NodeSelectionProvider)this.mainModel);
    }

    public void debugInterface() {
        LOGGER.info("Open the debug interface panel.");
        DebugInterfaceControllerFactory debugInterfaceControllerFactory = (DebugInterfaceControllerFactory)this.applicationContext.getBean(DebugInterfaceControllerFactory.class);
        DebugInterfaceController debugInterfaceController = debugInterfaceControllerFactory.createController(this.dockingDesktop);
        debugInterfaceController.start();
    }

    public void netDebug() {
        LOGGER.info("Open the netDebug panel.");
        NetDebugControllerFactory netDebugControllerFactory = (NetDebugControllerFactory)this.applicationContext.getBean(NetDebugControllerFactory.class);
        NetDebugController netDebugController = netDebugControllerFactory.createController(this.dockingDesktop);
        netDebugController.start();
    }

    public void debugConsole() {
        LOGGER.info("Open the debug console panel.");
        DebugConsoleControllerFactory debugConsoleControllerFactory = (DebugConsoleControllerFactory)this.applicationContext.getBean(DebugConsoleControllerFactory.class);
        DebugConsoleController debugConsoleController = debugConsoleControllerFactory.createController();
        debugConsoleController.start();
    }

    public void saveNodeTreeForSimulation() {
        LOGGER.info("Save the node tree for simulation.");
        try {
            SimulationControllerFactory simulationControllerFactory = (SimulationControllerFactory)this.applicationContext.getBean(SimulationControllerFactory.class);
            SimulationController simulationController = simulationControllerFactory.createController(this.dockingDesktop);
            WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
            String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_SIMULATION_KEY);
            Simulation simulation = simulationController.exportNodeTreeToSimulation();
            FileNameExtensionFilter ff = new FileNameExtensionFilter("Simulation", SUFFIX_COMPARISON);
            2 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.showDialog();
        }
        catch (Exception ex) {
            LOGGER.warn("Save node tree for simulation failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-simulation.failed"), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-simulation.title"), 0);
        }
    }

    public void backupAllNodes() {
        LOGGER.info("Backup all nodes.");
        try {
            BackupControllerFactory backupControllerFactory = (BackupControllerFactory)this.applicationContext.getBean(BackupControllerFactory.class);
            BackupController backupController = backupControllerFactory.createController(this.dockingDesktop, this.mainModel);
            backupController.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Backup node tree failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"backup-all-nodes.failed"), Resources.getString(DefaultMainMenuListener.class, (String)"backup-all-nodes.title"), 0);
        }
    }

    public void dccAdv() {
        LOGGER.info("Open the DCC-A panel.");
        DccAdvControllerFactory dccAdvControllerFactory = (DccAdvControllerFactory)this.applicationContext.getBean(DccAdvControllerFactory.class);
        DccAdvController dccAdvController = dccAdvControllerFactory.createController(this.mainModel.getSelectedNode(), this.dockingDesktop);
        dccAdvController.start();
    }

    public void showNodeScriptWizard() {
        LOGGER.info("Open the nodeScript wizard.");
        NodeScriptController nodeScriptController = (NodeScriptController)this.applicationContext.getBean(NodeScriptController.class);
        nodeScriptController.showWizard(this.dockingDesktop, (NodeSelectionProvider)this.mainModel);
    }

    public void showFirmwareRepo() {
        LOGGER.info("Open the firmware repo view.");
        FirmwareRepoController firmwareRepoController = (FirmwareRepoController)this.applicationContext.getBean(FirmwareRepoController.class);
        firmwareRepoController.start();
    }

    public void showNodesClient() {
        LOGGER.info("Open the nodes client view.");
        NodesClientController nodesClientController = (NodesClientController)this.applicationContext.getBean(NodesClientController.class);
        nodesClientController.start();
    }

    public void showScriptClient() {
        LOGGER.info("Open the script client view.");
        ScriptClientController scriptClientController = (ScriptClientController)this.applicationContext.getBean(ScriptClientController.class);
        scriptClientController.start();
    }

    public void showTracerClient() {
        LOGGER.info("Open the tracer client view.");
        TracerClientController tracerClientController = (TracerClientController)this.applicationContext.getBean(TracerClientController.class);
        tracerClientController.start();
    }

    public void showLocalHostClient() {
        LOGGER.info("Open the localHost client view.");
        LocalHostClientController localHostClientController = (LocalHostClientController)this.applicationContext.getBean(LocalHostClientController.class);
        localHostClientController.start();
    }

    public void showLocoDialog() {
        LOGGER.info("Open the loco controller dialog.");
        CommandStationNodeInterface node = NodeUtils.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)this.applicationContext.getBean(LocoControllerFactory.class);
            LocoController locoController = locoControllerFactory.createLocoController(node, (JFrame)this.viewSupplier.getFrame(), this.mainModel.getNodeProvider());
            AddressData initialAddress = null;
            locoController.start(initialAddress);
        }
    }

    public void showCarDialog() {
        LOGGER.info("Open the car controller dialog.");
        RfBasisNodeInterface node = NodeUtils.findFirstRfBasisMasterNode((Collection)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)this.applicationContext.getBean(LocoControllerFactory.class);
            LocoController locoController = locoControllerFactory.createLocoController(node.getNode().getCommandStationNode(), (JFrame)this.viewSupplier.getFrame(), this.mainModel.getNodeProvider());
            AddressData initialAddress = null;
            locoController.start(initialAddress);
        } else {
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"open-car-dialog.failed-no-basis"), Resources.getString(DefaultMainMenuListener.class, (String)"open-car-dialog.title"), 0);
        }
    }

    @EventListener
    public void handleMenuEvent(MenuEvent event) {
        LOGGER.info("Handle the menu event: {}", (Object)event);
        SwingUtilities.invokeLater(() -> {
            switch (4.$SwitchMap$org$bidib$wizard$client$common$event$MenuEvent$Action[event.getAction().ordinal()]) {
                case 1: {
                    this.showNodeScriptWizard();
                    break;
                }
                case 2: {
                    this.boosterTable();
                    break;
                }
                default: {
                    LOGGER.warn("Unhandled MenuEvent detected: {}", (Object)event);
                }
            }
        });
    }

    public void saveNodeTreeForComparison() {
        LOGGER.info("Save the node tree for comparison.");
        try {
            ComparisonControllerFactory comparisonControllerFactory = (ComparisonControllerFactory)this.applicationContext.getBean(ComparisonControllerFactory.class);
            ComparisonController comparisonController = comparisonControllerFactory.createController(this.dockingDesktop);
            WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
            String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_COMPARISON_KEY);
            BiDiB bidib = comparisonController.exportNodeTreeToComparison();
            FileNameExtensionFilter ff = new FileNameExtensionFilter("Comparison", SUFFIX_COMPARISON);
            3 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.showDialog();
        }
        catch (Exception ex) {
            LOGGER.warn("Save node tree for comparison failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-comparison.failed"), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-comparison.title"), 0);
        }
    }
}

