/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel.nodetree;

import com.jidesoft.grid.AutoResizePopupMenuCustomizer;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TreeTable;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.model.settings.WizardSettings;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.utils.AopUtils;
import org.bidib.wizard.mvc.main.view.component.LabeledDisplayItems;
import org.bidib.wizard.mvc.main.view.panel.BidibNodeRenderer;
import org.bidib.wizard.mvc.main.view.panel.nodetree.JideNodeTree;
import org.bidib.wizard.mvc.main.view.panel.nodetree.JideNodeTreeNode;
import org.bidib.wizard.mvc.main.view.panel.nodetree.JideNodeTreeTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JideNodeTree
extends TreeTable
implements LabeledDisplayItems<NodeInterface> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JideNodeTree.class);
    public static final String PROPERTYNAME_SELECTED_NODE = "selectedNode";
    private int prevSelectedIndex = -1;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final PropertyChangeListener pclNode;
    private final Set<ListSelectionListener> listSelectionListeners = new LinkedHashSet();

    public JideNodeTree(SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper) {
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setDoubleClickEnabled(false);
        this.setModel((TableModel)new JideNodeTreeTableModel());
        this.initialize(this.settingsService, this.wizardLabelWrapper);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)this);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AutoResizePopupMenuCustomizer());
        1 tableColumnChooserPopupMenuCustomizer = new /* Unavailable Anonymous Inner Class!! */;
        tableColumnChooserPopupMenuCustomizer.setFixedColumns(new int[]{0});
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)tableColumnChooserPopupMenuCustomizer);
        this.setShowHorizontalLines(false);
        this.hideOptionalColumns();
        this.getSortableTableModel().sortColumn(0, true, true);
        this.setRowHeight(this.getRowHeight() + 6);
        this.pclNode = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void customizePopupMenu(JTableHeader header, JPopupMenu popup, int clickingColumn) {
        for (int i = 0; i < popup.getComponentCount(); ++i) {
            LOGGER.info("name: {}", (Object)popup.getComponent(i).getName());
            if (!"TableColumnChooser.resetColumns".equals(popup.getComponent(i).getName())) continue;
            JMenuItem item = (JMenuItem)popup.getComponent(i);
            item.setAction((Action)new /* Unavailable Anonymous Inner Class!! */);
            break;
        }
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        popup.add(separator);
        boolean isAlwaysShowProductNameInTree = this.settingsService.getWizardSettings().isAlwaysShowProductNameInTree();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(Resources.getString(JideNodeTree.class, (String)"columnChooserPopup.showProductName"));
        item.setSelected(isAlwaysShowProductNameInTree);
        item.addActionListener(evt -> this.settingsService.getWizardSettings().setAlwaysShowProductNameInTree(!isAlwaysShowProductNameInTree));
        popup.add(item);
    }

    private String getResourceString(String key) {
        return GridResource.getResourceBundle((Locale)Locale.getDefault()).getString(key);
    }

    private void hideOptionalColumns() {
        TableColumnChooser.hideColumns((JTable)this, (int[])new int[]{1, 2});
    }

    protected void initialize(SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper) {
        ImageIcon bidibLeafIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/green-leaf.png", (int)16, (int)16);
        ImageIcon bidibNodeIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/green-node.png", (int)16, (int)16);
        ImageIcon bidibIdentifyIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/red-leaf.png", (int)16, (int)16);
        ImageIcon bidibErrorIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/error-leaf.png", (int)16, (int)16);
        ImageIcon bidibRestartIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/restart-pending.png", (int)16, (int)16);
        ImageIcon bidibLeafWarnIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/green-leaf-warn.png", (int)16, (int)16);
        ImageIcon bidibNodeWarnIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/green-node-warn.png", (int)16, (int)16);
        ImageIcon bidibNodeDetachedIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/green-node-detached.png", (int)16, (int)16);
        ImageIcon bidibNodeConfigPendingIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/orange-node.png", (int)16, (int)16);
        String messageUnsupportedProtocol = Resources.getString(JideNodeTree.class, (String)"unsupported-protocol-version");
        if (bidibNodeIcon != null) {
            BidibNodeRenderer renderer = new BidibNodeRenderer(wizardLabelWrapper, (Icon)bidibLeafIcon, (Icon)bidibNodeIcon, (Icon)bidibIdentifyIcon, (Icon)bidibErrorIcon, (Icon)bidibRestartIcon, (Icon)bidibLeafWarnIcon, (Icon)bidibNodeWarnIcon, (Icon)bidibNodeDetachedIcon, (Icon)bidibNodeConfigPendingIcon, messageUnsupportedProtocol);
            boolean alwaysShowProductNameInTree = settingsService.getWizardSettings().isAlwaysShowProductNameInTree();
            LOGGER.info("alwaysShowProductNameInTree: {}", (Object)alwaysShowProductNameInTree);
            renderer.setAlwaysShowProductNameInTree(alwaysShowProductNameInTree);
            try {
                WizardSettings ws = (WizardSettings)AopUtils.getTargetObject((Object)settingsService.getWizardSettings());
                ws.addPropertyChangeListener("alwaysShowProductNameInTree", evt -> {
                    Object newValue = evt.getNewValue();
                    if (newValue instanceof Boolean) {
                        boolean alwaysShowProductNameInTree1 = (Boolean)newValue;
                        renderer.setAlwaysShowProductNameInTree(alwaysShowProductNameInTree1);
                        LOGGER.info("Refresh the tree because alwaysShowProductNameInTree has changed: {}", (Object)alwaysShowProductNameInTree1);
                        SortableTreeTableModel sortableTreeModel = (SortableTreeTableModel)this.getModel();
                        JideNodeTreeTableModel model = (JideNodeTreeTableModel)sortableTreeModel.getActualModel();
                        model.fireTableDataChanged();
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
            }
            CellRendererManager.registerRenderer(JideNodeTreeNode.class, (TableCellRenderer)renderer);
        } else {
            LOGGER.warn("BidibNode icon missing; using default.");
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.add(listener);
    }

    public int getIndex(Point point) {
        return this.rowAtPoint(point);
    }

    public int getItemSize() {
        return this.getRowCount();
    }

    public int getRowForLocation(int x, int y) {
        return this.rowAtPoint(new Point(x, y));
    }

    public int getSelectedIndex() {
        return this.getSelectedRow();
    }

    public NodeInterface getSelectedItem() {
        int index = this.getSelectedRow();
        if (index > -1) {
            JideNodeTreeNode row = (JideNodeTreeNode)this.getRowAt(index);
            return row.getNode();
        }
        return null;
    }

    public Point indexToLocation(int index) {
        return this.getCellRect(index, 0, false).getLocation();
    }

    public void refreshView() {
    }

    public NodeInterface selectElement(Point point) {
        int row = this.rowAtPoint(point);
        return (NodeInterface)this.getModel().getValueAt(row, 0);
    }

    public void setItems(NodeInterface[] items) {
        LOGGER.info("Set the new items: {}", new Object[]{items});
        SortableTreeTableModel sortableTreeModel = (SortableTreeTableModel)this.getModel();
        JideNodeTreeTableModel model = (JideNodeTreeTableModel)sortableTreeModel.getActualModel();
        for (DefaultExpandableRow treeNode : model.getOriginalRows()) {
            this.removeListenerFromNode(treeNode);
        }
        LinkedList<NodeInterface> newNodeItems = new LinkedList<NodeInterface>();
        if (items != null && items.length > 0) {
            newNodeItems.addAll(Arrays.asList(items));
        } else {
            LOGGER.info("No tree items to set available.");
        }
        LinkedList<JideNodeTreeNode> originalRows = new LinkedList<JideNodeTreeNode>();
        JideNodeTreeNode interfaceNode = null;
        for (NodeInterface itemNode : newNodeItems) {
            if (NodeUtils.convertAddress((byte[])itemNode.getNode().getAddr()) != 0) continue;
            LOGGER.debug("Adding interface node: {}", (Object)itemNode);
            interfaceNode = new JideNodeTreeNode(itemNode);
            if (interfaceNode.getNode() instanceof NodeInterface) {
                LOGGER.info("Add pclNode to node: {}", (Object)itemNode);
                interfaceNode.getNode().addPropertyChangeListener(this.pclNode);
            } else {
                LOGGER.warn("The current interface node is not of type Node. No PropertyChangeListener added!");
            }
            originalRows.add(interfaceNode);
            newNodeItems.remove(itemNode);
            break;
        }
        model.setOriginalRows(originalRows);
        if (interfaceNode != null && CollectionUtils.isNotEmpty(newNodeItems)) {
            this.addNodesOfLevel(interfaceNode, newNodeItems);
        }
        model.refresh();
        this.expandAll();
    }

    private void addNodesOfLevel(JideNodeTreeNode parentNode, List<NodeInterface> newNodeItems) {
        LOGGER.debug("Add children to node: {}", (Object)parentNode);
        LinkedList<NodeInterface> toRemove = new LinkedList<NodeInterface>();
        for (NodeInterface itemNode : newNodeItems) {
            if (!this.isChildOfNode(parentNode, itemNode)) continue;
            LOGGER.debug("Adding new node: {}, address: {}", (Object)itemNode, (Object)itemNode.getNode().getAddr());
            JideNodeTreeNode nodeTreeNode = new JideNodeTreeNode(itemNode);
            if (nodeTreeNode.getNode() instanceof NodeInterface) {
                LOGGER.info("Add pclNode to node: {}", (Object)itemNode);
                nodeTreeNode.getNode().addPropertyChangeListener(this.pclNode);
            } else {
                LOGGER.warn("The current node is not of type Node. No PropertyChangeListener added!");
            }
            parentNode.addChild((Object)nodeTreeNode);
            toRemove.add(itemNode);
        }
        LOGGER.trace("Remove inserted nodes from original list of nodeItems: {}", toRemove);
        newNodeItems.removeAll(toRemove);
        if (newNodeItems.size() == 0) {
            LOGGER.trace("No more node items to add.");
            return;
        }
        List children = parentNode.getChildren();
        if (children != null) {
            for (JideNodeTreeNode childNode : children) {
                this.addNodesOfLevel(childNode, newNodeItems);
            }
        }
    }

    protected boolean isChildOfNode(JideNodeTreeNode parentTreeNode, NodeInterface node) {
        int index;
        NodeInterface parentNode = parentTreeNode.getNode();
        byte[] parentAddr = parentNode.getNode().getAddr();
        byte[] nodeAddr = node.getNode().getAddr();
        int parentLen = 0;
        for (int index2 = 0; index2 < parentAddr.length; ++index2) {
            if (parentAddr[index2] == 0) continue;
            ++parentLen;
        }
        LOGGER.debug("Length of parent address: {}", (Object)parentLen);
        int nodeLen = 0;
        for (index = 0; index < nodeAddr.length; ++index) {
            if (nodeAddr[index] == 0) continue;
            ++nodeLen;
        }
        LOGGER.debug("Length of node address: {}", (Object)nodeLen);
        if (nodeLen != parentLen + 1) {
            LOGGER.debug("Node is not a child of the provided parent because length of address does not match.");
            return false;
        }
        for (index = 0; index < nodeLen - 1; ++index) {
            LOGGER.debug("Comparing at index: {}, nodeAddr: {}, parentAddr: {}", new Object[]{index, nodeAddr[index], parentAddr[index]});
            if (nodeAddr[index] == parentAddr[index]) continue;
            return false;
        }
        return true;
    }

    private void removeListenerFromNode(DefaultExpandableRow treeNode) {
        for (int i = treeNode.getChildrenCount(); i > 0; --i) {
            LOGGER.trace("remove child at index: {}", (Object)(i - 1));
            try {
                Object child = treeNode.getChildAt(i - 1);
                if (child instanceof JideNodeTreeNode) {
                    JideNodeTreeNode childNode = (JideNodeTreeNode)child;
                    if (childNode.getNode() instanceof NodeInterface) {
                        NodeInterface node = childNode.getNode();
                        LOGGER.info("Remove pclNode from node: {}", (Object)node);
                        node.removePropertyChangeListener(this.pclNode);
                    } else {
                        LOGGER.warn("The current child node is not of type Node. No PropertyChangeListener removed!");
                    }
                    this.removeListenerFromNode((DefaultExpandableRow)childNode);
                }
                treeNode.removeChild(child);
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("Remove node failed, index: " + (i - 1), (Throwable)ex);
            }
        }
    }

    public void setSelectedItem(NodeInterface node) {
        LOGGER.info("Select the node in the tree: {}", (Object)node);
        int currentlySelectedIndex = this.prevSelectedIndex;
        int index = this.getSelectedIndex();
        try {
            this.fireVetoableChange(PROPERTYNAME_SELECTED_NODE, (Object)currentlySelectedIndex, (Object)index);
            LOGGER.info("The change of the selected node was not vetoed, perform the change.");
            for (ListSelectionListener listSelListener : this.listSelectionListeners) {
                listSelListener.valueChanged(new ListSelectionEvent(this, index, index, false));
            }
            this.prevSelectedIndex = index;
        }
        catch (PropertyVetoException ex) {
            LOGGER.warn("The selectedNode change was vetoed.", (Throwable)ex);
        }
    }

    public void selectedValueChanged(int index) {
    }

    private void labelChanged(NodeInterface node) {
        LOGGER.info("The label was changed on node: {}", (Object)node);
        SortableTreeTableModel sortableTreeModel = (SortableTreeTableModel)this.getModel();
        JideNodeTreeTableModel model = (JideNodeTreeTableModel)sortableTreeModel.getActualModel();
        if (SwingUtilities.isEventDispatchThread()) {
            model.refresh();
        } else {
            SwingUtilities.invokeLater(() -> model.refresh());
        }
    }
}

