/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.status.InputPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortTableStatusCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortTableStatusCellRenderer.class);
    private JPanel panel = new JPanel();
    private JLabel label;

    public InputPortTableStatusCellRenderer() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 10;
        this.panel.setLayout(layout);
        this.label = new JLabel();
        Border b = BorderFactory.createRaisedBevelBorder();
        this.label.setBorder(b);
        this.label.setOpaque(true);
        this.label.setPreferredSize(new Dimension(15, 15));
        this.panel.add((Component)this.label, c);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        InputPortStatus status = null;
        boolean enabled = false;
        if (value instanceof InputPort) {
            InputPort inputPort = (InputPort)value;
            enabled = inputPort.isEnabled();
            this.setEnabled(enabled);
            this.label.setEnabled(enabled);
            this.panel.setEnabled(enabled);
            if (enabled) {
                status = (InputPortStatus)inputPort.getStatus();
            }
        } else {
            LOGGER.warn("Found invalid configuration.");
            this.setEnabled(enabled);
            this.label.setEnabled(false);
            this.panel.setEnabled(false);
        }
        if (enabled && InputPortStatus.ON.equals(status)) {
            this.label.setBackground(Color.RED);
        } else {
            this.label.setBackground(Color.LIGHT_GRAY);
        }
        if (isSelected) {
            this.panel.setForeground(table.getSelectionForeground());
            this.panel.setBackground(table.getSelectionBackground());
        } else {
            this.panel.setForeground(table.getForeground());
            this.panel.setBackground(table.getBackground());
        }
        return this.panel;
    }
}

