package org.bidib.wizard.mvc.loco.model;

public enum RfBasisMode {

    // @formatter:off
    SINGLE(null, null, "single"), 
    MULTI_1(1, 512, "multi1"), MULTI_2(2, 513, "multi2"), MULTI_3(3, 514, "multi3"), MULTI_4(4, 515, "multi4"), 
    MULTI_5(6, 516, "multi5"), MULTI_6(6, 517, "multi6"), MULTI_7(7, 518, "multi7"), MULTI_8(8, 519, "multi8");
    // @formatter:on

    private final String key;

    private final Integer functionIndex;

    private final Integer baseNumber;

    private RfBasisMode(Integer baseNumber, Integer functionIndex, String key) {
        this.baseNumber = baseNumber;
        this.functionIndex = functionIndex;
        this.key = key;
    }

    /**
     * @return the baseNumber
     */
    public Integer getBaseNumber() {
        return baseNumber;
    }

    public Integer getFunctionIndex() {
        return functionIndex;
    }

    public String getKey() {
        return key;
    }
}
