package org.bidib.wizard.mvc.main.model;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.MacroRef;

public class AccessoryAspectMacro implements AccessoryAspect {

    private MacroRef macroRef;

    private final int index;

    private String label;

    private boolean immutableAccessory;

    public AccessoryAspectMacro(int index, MacroRef macroRef) {
        this.index = index;
        this.macroRef = macroRef;
    }

    /**
     * @return the index
     */
    public int getIndex() {
        return index;
    }

    /**
     * @return the macro
     */
    public MacroRef getMacroRef() {
        return macroRef;
    }

    /**
     * @return the label
     */
    @Override
    public String getLabel() {
        return label;
    }

    /**
     * @param label
     *            the label to set
     */
    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * @return the immutableAccessory
     */
    public boolean isImmutableAccessory() {
        return immutableAccessory;
    }

    /**
     * @param immutableAccessory
     *            the immutableAccessory to set
     */
    public void setImmutableAccessory(boolean immutableAccessory) {
        this.immutableAccessory = immutableAccessory;
    }

    @Override
    public String toString() {
        if (label != null) {
            return label;
        }

        return Resources.getString(AccessoryTableModel.class, "aspect") + "_" + index;
    }
}
