package org.bidib.wizard.utils;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;

public interface User32Ext extends StdCallLibrary, WinUser, WinNT {

    /** The instance. */
    User32Ext INSTANCE = Native.load("user32", User32Ext.class, W32APIOptions.DEFAULT_OPTIONS);

    /**
     * Activates a window. The window must be attached to the calling thread's message queue.
     * 
     * @param hWnd
     *            A handle to the top-level window to be activated.
     * @return If the function succeeds, the return value is the handle to the window that was previously active. If the
     *         function fails, the return value is NULL. To get extended error information, call GetLastError.
     */
    HWND SetActiveWindow(HWND hWnd);
}
