/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.editor;

import java.awt.Component;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.bidib.wizard.api.locale.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerEditor
extends DefaultCellEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegerEditor.class);
    private static final long serialVersionUID = 1L;
    JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    NumberFormat integerFormat;
    private Integer minimum;
    private Integer maximum;

    public IntegerEditor(int min, int max) {
        super(new JFormattedTextField());
        this.minimum = min;
        this.maximum = max;
        this.integerFormat = new DecimalFormat("#");
        NumberFormatter intFormatter = new NumberFormatter(this.integerFormat);
        intFormatter.setFormat(this.integerFormat);
        intFormatter.setMinimum(this.minimum);
        intFormatter.setMaximum(this.maximum);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(intFormatter));
        this.ftf.setValue(this.minimum);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", (Action)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        LOGGER.debug("getCellEditorValue: o isn't a Number");
        try {
            return this.integerFormat.parseObject(o.toString());
        }
        catch (ParseException exc) {
            LOGGER.warn("getCellEditorValue: can't parse o: " + o);
            return null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{Resources.getString(IntegerEditor.class, (String)"edit"), Resources.getString(IntegerEditor.class, (String)"revert")};
        String message = String.format(Resources.getString(IntegerEditor.class, (String)"revertMessage"), this.minimum, this.maximum);
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), message, Resources.getString(IntegerEditor.class, (String)"revertTitle"), 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        return false;
    }
}

