/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.console.model;

import com.jgoodies.binding.beans.Model;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleModel;
import org.bidib.wizard.mvc.console.model.DefaultConsoleModel;

public class DefaultConsoleModel
extends Model
implements ConsoleModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CONSOLE_CONTENT = "consoleContent";
    public static final String PROPERTY_CONSOLE_CONTENT_SIZE = "consoleContentSize";
    private List<ConsoleLine> consoleMessages = new LinkedList();

    public void addConsoleLine(ConsoleColor consoleColor, String line) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAddConsoleLine(consoleColor, line);
        } else {
            SwingUtilities.invokeLater(() -> this.internalAddConsoleLine(consoleColor, line));
        }
    }

    private void internalAddConsoleLine(ConsoleColor consoleColor, String line) {
        ConsoleLine consoleLine = new ConsoleLine(consoleColor, line);
        if (this.consoleMessages.size() > 250) {
            this.consoleMessages.remove(0);
        }
        this.consoleMessages.add(consoleLine);
        int index = this.consoleMessages.size() - 1;
        this.fireIndexedPropertyChange(PROPERTY_CONSOLE_CONTENT, index, null, (Object)consoleLine);
    }

    public void clear() {
        int oldSize = this.consoleMessages.size();
        this.consoleMessages.clear();
        this.firePropertyChange(PROPERTY_CONSOLE_CONTENT_SIZE, oldSize, this.consoleMessages.size());
    }
}

