/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import org.bidib.wizard.mvc.dmx.view.panel.axis.LabeledNumberTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.RangeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRangeLimitedValueAxis
extends NumberAxis {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoRangeLimitedValueAxis.class);
    private static final long serialVersionUID = 1L;
    private boolean isFixedZoomAxis;

    public AutoRangeLimitedValueAxis() {
    }

    public AutoRangeLimitedValueAxis(String label) {
        super(label);
    }

    public boolean isFixedZoomAxis() {
        return this.isFixedZoomAxis;
    }

    public void setFixedZoomAxis(boolean isFixedZoomAxis) {
        this.isFixedZoomAxis = isFixedZoomAxis;
    }

    protected Range calcAutoRange() {
        LOGGER.info("calcAutoRange, label: {}, range: {}", (Object)this.getLabel(), (Object)this.getRange());
        Plot plot = this.getPlot();
        if (plot == null) {
            return this.getDefaultAutoRange();
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot vap = (ValueAxisPlot)plot;
            Range r = vap.getDataRange((ValueAxis)this);
            LOGGER.info("Fetched dataRange: {}", (Object)r);
            if (r == null) {
                r = this.getDefaultAutoRange();
            }
            double upper = r.getUpperBound();
            double lower = r.getLowerBound();
            if (this.getRangeType() == RangeType.POSITIVE) {
                lower = Math.max(0.0, lower);
                upper = Math.max(0.0, upper);
            } else if (this.getRangeType() == RangeType.NEGATIVE) {
                lower = Math.min(0.0, lower);
                upper = Math.min(0.0, upper);
            }
            if (this.getAutoRangeIncludesZero()) {
                lower = Math.min(lower, 0.0);
                upper = Math.max(upper, 0.0);
            }
            double range = upper - lower;
            double fixedAutoRange = this.getFixedAutoRange();
            if (fixedAutoRange < 0.0) {
                lower = upper + fixedAutoRange;
                LOGGER.info("fixedAutoRange: {}, lower: {}, upper: {}", new Object[]{fixedAutoRange, lower, upper});
            } else {
                double minRange = this.getAutoRangeMinimumSize();
                LOGGER.info("Calculated minRange: {}, range: {}", (Object)minRange, (Object)range);
                if (range < minRange) {
                    double expand = (minRange - range) / 2.0;
                    if ((lower -= expand) == (upper += expand)) {
                        double adjust = Math.abs(lower) / 10.0;
                        lower -= adjust;
                        upper += adjust;
                    }
                    if (this.getRangeType() == RangeType.POSITIVE) {
                        if (lower < 0.0) {
                            upper -= lower;
                            lower = 0.0;
                        }
                    } else if (this.getRangeType() == RangeType.NEGATIVE && upper > 0.0) {
                        lower -= upper;
                        upper = 0.0;
                    }
                }
                if (this.getAutoRangeStickyZero()) {
                    upper = upper <= 0.0 ? Math.min(0.0, upper + this.getUpperMargin() * range) : (upper += this.getUpperMargin() * range);
                    lower = lower >= 0.0 ? Math.max(0.0, lower - this.getLowerMargin() * range) : (lower -= this.getLowerMargin() * range);
                } else {
                    upper += this.getUpperMargin() * range;
                    lower -= this.getLowerMargin() * range;
                }
            }
            LOGGER.info("calcAutoRange, return lower: {}, upper: {}", (Object)lower, (Object)upper);
            return new Range(lower, upper);
        }
        return this.getDefaultAutoRange();
    }

    public void zoomRange(double lowerPercent, double upperPercent) {
        double upper;
        double lower;
        LOGGER.info("zoomRange, lowerPercent: {}, upperPercent: {}", (Object)lowerPercent, (Object)upperPercent);
        if (this.isFixedZoomAxis()) {
            LOGGER.info("Current axis has fixed zoom, no calculation is needed.");
            return;
        }
        Range r = this.getRange();
        double start = r.getLowerBound();
        double length = r.getLength();
        if (this.isInverted()) {
            lower = start + length * (1.0 - upperPercent);
            upper = start + length * (1.0 - lowerPercent);
        } else {
            lower = start + length * lowerPercent;
            upper = start + length * upperPercent;
        }
        LOGGER.info("zoomRange, set new range, calculated lower: {}, upper: {}", (Object)lower, (Object)upper);
        this.setRange(lower, upper);
    }

    public void resizeRange(double percent, double anchorValue) {
        LOGGER.info("resizeRange, label: {}, percent: {}, anchorValue: {}", new Object[]{this.getLabel(), percent, anchorValue});
        if (this.isFixedZoomAxis()) {
            LOGGER.info("Current axis has fixed zoom, no calculation is needed.");
            return;
        }
        if (percent > 0.0) {
            double halfLength = this.getRange().getLength() * percent / 2.0;
            Range adjusted = new Range(anchorValue - halfLength, anchorValue + halfLength);
            if (adjusted.getLowerBound() < 0.0) {
                LOGGER.debug("Lower bound is below zero, ignore resize below zero.");
                adjusted = new Range(0.0, 2.0 * halfLength);
            }
            this.setRange(adjusted.getLowerBound(), adjusted.getUpperBound());
        } else if (this.isAutoRange()) {
            this.setAutoRange(true);
        } else {
            this.setRange(new Range(0.0, -1.0 * this.getFixedAutoRange()));
        }
    }

    public void pan(double percent) {
        LOGGER.debug("pan, percent: {}, label: {}, range: {}", new Object[]{percent, this.getLabel(), this.getRange()});
        if (percent == 0.0) {
            return;
        }
        Range r = this.getRange();
        double length = r.getLength();
        double adj = length * percent;
        double lower = r.getLowerBound() + adj;
        double upper = r.getUpperBound() + adj;
        LOGGER.debug("pan 1, lower: {}, upper: {}, length: {}, adj: {}", new Object[]{lower, upper, length, adj});
        if (lower < 0.0) {
            lower = 0.0;
            upper = lower + length;
        }
        LOGGER.debug("pan 2, lower: {}, upper: {}", (Object)lower, (Object)upper);
        this.setRange(lower, upper);
    }

    public String getLabel() {
        NumberTickUnit unit = this.getTickUnit();
        if (unit instanceof LabeledNumberTickUnit) {
            return ((LabeledNumberTickUnit)unit).getAxisLabel();
        }
        return super.getLabel();
    }
}

