/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.firmware.controller;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JFrame;
import org.bidib.jbidibc.messages.FirmwareUpdateStat;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateState;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.core.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.mvc.firmware.controller.listener.FirmwareControllerListener;
import org.bidib.wizard.mvc.firmware.model.FirmwareModel;
import org.bidib.wizard.mvc.firmware.view.FirmwareView;
import org.bidib.wizard.mvc.firmware.view.listener.FirmwareViewListener;
import org.bidib.wizard.utils.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FirmwareController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareController.class);
    private final Collection<FirmwareControllerListener> listeners = new LinkedList();
    private final NodeInterface node;
    private final JFrame parent;
    private final FirmwareModel firmwareModel = new FirmwareModel();
    private final NodeListProvider nodeListProvider;
    private NodeListListener nodeListListener;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private ConnectionRegistry connectionRegistry;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private DefaultWizardLabelFactory wizardLabelFactory;
    @Autowired
    private ConsoleService consoleService;
    private final ScheduledExecutorService firmwareUpdateWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("firmwareUpdateWorkers-thread-%d").build());

    public FirmwareController(NodeInterface node, NodeListProvider nodeListProvider, JFrame parent) {
        this.parent = parent;
        this.node = node;
        this.nodeListProvider = nodeListProvider;
    }

    public void addFirmwareControllerListener(FirmwareControllerListener l) {
        this.listeners.add(l);
    }

    private void fireClose() {
        LOGGER.info("Close the firmware controller.");
        if (this.nodeListListener != null) {
            LOGGER.info("Remove the nodelist listener.");
            this.nodeListProvider.removeNodeListListener(this.nodeListListener);
            this.nodeListListener = null;
        }
        for (FirmwareControllerListener l : this.listeners) {
            l.close();
        }
    }

    private String prepareProductName(NodeInterface node) {
        Object productName = node.getNode().getStoredString(0);
        if (ProductUtils.isLightControl((long)node.getUniqueId())) {
            productName = this.firmwareModel.getNode().getStorableMacroCount() != 40 ? (String)productName + " (SIGNALS)" : (String)productName + " (STANDARD)";
        }
        return productName;
    }

    public void start() {
        this.firmwareModel.setNode(this.node);
        this.firmwareModel.setNodeName(this.node.getLabel() != null ? this.node.getLabel() : NodeUtils.prepareNodeLabel((Node)this.node.getNode()));
        this.firmwareModel.setProductName(this.prepareProductName(this.node));
        long uniqueId = this.node.getNode().getUniqueId();
        this.firmwareModel.setUniqueId(ByteUtils.getUniqueIdAsString((long)uniqueId));
        SoftwareVersion swVersion = this.node.getNode().getSoftwareVersion();
        this.firmwareModel.setNodeCurrentVersion(swVersion != null ? swVersion.toString() : "unknown");
        boolean isBootloaderRootNode = false;
        isBootloaderRootNode = this.node.isUpdatable() && Arrays.equals(this.node.getNode().getAddr(), Node.ROOTNODE_ADDR);
        LOGGER.info("The current node is a bootloader rootnode: {}", (Object)isBootloaderRootNode);
        this.firmwareModel.setBootloaderRootNode(isBootloaderRootNode);
        this.nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.nodeListProvider.addNodeListListener(this.nodeListListener);
        FirmwareView view = new FirmwareView(this.parent, this.firmwareModel, this.settingsService);
        WindowUtils.centerOnCurrentScreen((Component)this.parent, (Component)view);
        BidibConnection connection = this.connectionRegistry.getConnection("main");
        this.firmwareModel.addPropertyChangeListener("cvDefinitionFiles", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.firmwareModel.addPropertyChangeListener("vendorImageFiles", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.firmwareModel.addPropertyChangeListener("defaultLabelsFiles", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        view.addFirmwareViewListener((FirmwareViewListener)new /* Unavailable Anonymous Inner Class!! */);
        view.setVisible(true);
    }

    private boolean sendCommand(BidibConnection connection, FirmwareUpdateOperation operation, byte ... data) throws InterruptedException {
        boolean result = false;
        FirmwareUpdateStat updateStat = null;
        try {
            updateStat = connection.sendFirmwareUpdateOperation(this.node, operation, data);
        }
        catch (NoAnswerException ex) {
            switch (6.$SwitchMap$org$bidib$jbidibc$messages$enums$FirmwareUpdateOperation[operation.ordinal()]) {
                case 1: {
                    LOGGER.warn("No answer received during enter firmware update mode.", (Throwable)ex);
                    break;
                }
                case 2: {
                    LOGGER.warn("No answer received during exit firmware update mode.", (Throwable)ex);
                    break;
                }
                default: {
                    LOGGER.warn("No answer received during firmware update, try send data again.", (Throwable)ex);
                    this.traceTimeout(operation, true);
                }
            }
        }
        if (updateStat == null && FirmwareUpdateOperation.DATA == operation) {
            LOGGER.warn("Try to retransfer the data block.");
            try {
                updateStat = connection.sendFirmwareUpdateOperation(this.node, operation, data);
            }
            catch (NoAnswerException ex) {
                LOGGER.warn("No answer received during firmware update when retry send data. Firmware update process will be aborted.", (Throwable)ex);
                this.traceTimeout(operation, false);
            }
        }
        if (updateStat != null) {
            LOGGER.info("Received update stat, timeout: {}, state: {}, last operation: {}", new Object[]{updateStat.getTimeout(), updateStat.getState(), operation});
            if (updateStat.getTimeout() > 0) {
                int extendedTime = updateStat.getTimeout() * 10;
                LOGGER.warn("The node requested a wait to complete: {} ms", (Object)extendedTime);
                this.traceMoreTimeRequested(extendedTime);
                Thread.sleep(extendedTime);
                this.traceContinueAfterMoreTimeRequested(extendedTime);
            }
            FirmwareUpdateState state = updateStat.getState();
            if (operation == FirmwareUpdateOperation.ENTER && state == FirmwareUpdateState.READY || operation == FirmwareUpdateOperation.DONE && state == FirmwareUpdateState.READY || operation == FirmwareUpdateOperation.EXIT && state == FirmwareUpdateState.EXIT || operation == FirmwareUpdateOperation.SETDEST && state == FirmwareUpdateState.DATA || operation == FirmwareUpdateOperation.DATA && state == FirmwareUpdateState.DATA) {
                result = true;
            } else {
                LOGGER.warn("The firmware update state ({}) returned from the node does not match the firmware operation ({}).", (Object)state, (Object)operation);
                ConsoleController.ensureConsoleVisible();
                this.consoleService.addConsoleLine(ConsoleColor.red, String.format("The firmware update state (%s) returned from the node does not match the firmware operation (%s).", state != null ? state.name() : "unknown", operation != null ? operation.name() : "unknown"));
                this.traceInvalidAnswer(state, operation);
            }
        } else {
            LOGGER.warn("No updateStat received for operation: {}", (Object)operation);
            ConsoleController.ensureConsoleVisible();
            this.consoleService.addConsoleLine(ConsoleColor.red, String.format("No firmware update state returned from the node after send the firmware operation (%s).", operation != null ? operation.name() : "unknown"));
            this.traceInvalidAnswer(operation);
        }
        LOGGER.debug("sendCommand return result: {}", (Object)result);
        return result;
    }

    private void traceTimeout(FirmwareUpdateOperation operation, boolean retry) {
        if (retry) {
            this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-timeout-retry"), 1, new Object[]{operation});
        } else {
            this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-timeout"), 1, new Object[]{operation});
        }
    }

    private void traceMoreTimeRequested(int extendedTime) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-more-time-requested"), 1, new Object[]{extendedTime});
    }

    private void traceContinueAfterMoreTimeRequested(int extendedTime) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-continue-after-more-time-wait"), 1, new Object[]{extendedTime});
    }

    private void traceInvalidAnswer(FirmwareUpdateState state, FirmwareUpdateOperation operation) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-invalid-answer"), 1, new Object[]{state != null ? state.name() : "unknown", operation != null ? operation.name() : "unknown"});
    }

    private void traceInvalidAnswer(FirmwareUpdateOperation operation) {
        this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareController.class, (String)"status.transfer-firmware-no-answer"), 1, new Object[]{operation != null ? operation.name() : "unknown"});
    }
}

