/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.TreeTableModel;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.exchange.vendorcv.DataType;
import org.bidib.jbidibc.exchange.vendorcv.ModeType;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.ButtonUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.cvdef.AbstractNode;
import org.bidib.wizard.client.common.view.cvdef.CvBitfieldValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvByteValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvDccLongAddrValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvIntegerValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvLongValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.CvRadioValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvSignedCharValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueNumberEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueStringEditor;
import org.bidib.wizard.client.common.view.cvdef.DccAccAddrEditor;
import org.bidib.wizard.client.common.view.cvdef.DccAddrRGEditor;
import org.bidib.wizard.client.common.view.cvdef.DeviceNode;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserEditor;
import org.bidib.wizard.client.common.view.cvdef.NodeNode;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.mvc.common.exception.NodeChangeVetoException;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionPanel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionRequestListenerAware;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabStatusListener;
import org.bidib.wizard.mvc.main.view.table.CvDefinitionJideTreeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvDefinitionPanel
extends JPanel
implements TabSelectionListener,
CvDefinitionPanelProvider,
CvDefinitionRequestListenerAware,
TabPanelProvider,
TabComponentCreator,
PortListenerProvider<FeedbackPort>,
NodeListListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CvDefinitionPanel.class);
    private static final String NONE = "none";
    private final SettingsService settingsService;
    private final CvDefinitionPanelControllerInterface cvDefinitionPanelController;
    private Map<String, ConfigurationVariable> configVariables;
    private CvDefinitionTreeTableModel treeModel;
    private JTextField textXmlFileName;
    private JTextField textVersion;
    private JTextField textLastUpdate;
    private JTextField textAuthor;
    private JTextField textDescription;
    private final CvDefinitionJideTreeTable cvTreeTable;
    private JButton saveButton;
    private CardLayout cardLayout;
    private EditorPanels editorPanels;
    private Map<String, CvNode> cvNumberToNodeMap;
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final String LOAD = "loadFromFile";
    private static final String SAVE = "saveToFile";
    private JButton readButton;
    private JButton writeButton;
    private JButton loadFromFileButton;
    private JButton saveToFileButton;
    private JButton exportToExcelButton;
    private VLToolBar toolbarCvDefinition;
    private final TabStatusListener tabStatusListener;
    private final MainModel mainModel;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private final Map<DataType, CvValueEditor> mapDataTypeToEditor = new HashMap();
    private List<CvDefinitionRequestListener> cvDefinitionRequestListeners = new LinkedList();
    private JButton copyToUserDirCvDefinitionButton;
    protected ValidationResultModel cvValidationModel;
    private CvDefinitionFileValueBean definitionFileValueBean = new CvDefinitionFileValueBean();
    private ImageIcon userDefinedImportIcon;
    private GBM16TReverserEditor gbm16TReverserEditor;
    private DccAccAddrEditor dccAccAddrEditor;
    private DccAddrRGEditor dccAddrRGEditor;
    private CvValueNumberEditor<Byte> byteEditor;
    private CvValueNumberEditor<Byte> bitfieldEditor;
    private CvValueNumberEditor<Byte> radioEditor;
    private CvValueNumberEditor<Integer> integerEditor;
    private CvValueNumberEditor<Long> longEditor;
    private CvValueNumberEditor<Integer> dccLongAddrEditor;
    private CvSignedCharValueEditor signedCharEditor;
    private CvValueStringEditor stringEditor;
    private static FileFilter cvExchangeFilter;
    private static final String CV_EXCHANGE_EXTENSION = "xml";
    private static final String WORKING_DIR_CV_DEFINITION_KEY = "cvDefinition";
    public static final String PATTERN_CV_FILENAME = "^BiDiBCV-([0-9]{1,3})-.+\\.xml$";

    public CvDefinitionPanel(CvDefinitionPanelControllerInterface cvDefinitionPanelController, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, MainModel mainModel, TabStatusListener tabStatusListener, SettingsService settingsService) {
        this.settingsService = settingsService;
        this.cvDefinitionPanelController = cvDefinitionPanelController;
        this.tabStatusListener = tabStatusListener;
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.setLayout((LayoutManager)new BorderLayout());
        this.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.setOpaque(false);
        LOGGER.debug("Create the CV tree.");
        this.cvTreeTable = new CvDefinitionJideTreeTable();
        this.cvTreeTable.setSelectionMode(0);
        this.cvTreeTable.getTableHeader().setReorderingAllowed(false);
        this.cvTreeTable.setRowHeight(this.cvTreeTable.getRowHeight() + 6);
        ListSelectionModel listSelectionModel = this.cvTreeTable.getSelectionModel();
        listSelectionModel.addListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvTreeTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        mainModel.addCvDefinitionListener((CvDefinitionListener)new /* Unavailable Anonymous Inner Class!! */);
        JSplitPane splitPane = new JSplitPane(1);
        JScrollPane scrollTree = new JScrollPane((Component)this.cvTreeTable);
        splitPane.add(scrollTree);
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)this.createXmFileInfoPanel(), "North");
        westPanel.add((Component)this.createCvEditorPanel(mainModel), "Center");
        JScrollPane scrollCvEditors = new JScrollPane(westPanel);
        splitPane.add(scrollCvEditors);
        this.add((Component)splitPane, (Object)"Center");
        splitPane.setDividerLocation(800);
        this.toolbarCvDefinition = new VLToolBar(WORKING_DIR_CV_DEFINITION_KEY);
        this.addButtons(this.toolbarCvDefinition);
        this.addToolBar(this.toolbarCvDefinition, new ToolBarConstraints(0, 2));
        this.toolbarCvDefinition.setVisible(false);
    }

    protected void clearAllEditors() {
        ArrayList editors = new ArrayList();
        editors.addAll(this.mapDataTypeToEditor.values());
        for (CvValueEditor editor : editors) {
            editor.setValue(null, this.cvNumberToNodeMap);
        }
    }

    public void resetPendingChanges() {
        if (this.treeModel != null) {
            LOGGER.info("Reset pending changes on root node.");
            DefaultExpandableRow root = (DefaultExpandableRow)this.treeModel.getRoot();
            this.resetPendingChanges(root);
        }
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof CvDefinitionPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void addToolBar(VLToolBar toolBar, ToolBarConstraints constraints) {
        ToolBarPanel topToolBarPanel = (ToolBarPanel)DefaultApplicationContext.getInstance().get("topToolBarPanel");
        topToolBarPanel.add(toolBar, constraints);
    }

    private void removeToolBar(VLToolBar toolBar) {
        ToolBarPanel topToolBarPanel = (ToolBarPanel)DefaultApplicationContext.getInstance().get("topToolBarPanel");
        topToolBarPanel.remove((Component)toolBar);
    }

    private JPanel createXmFileInfoPanel() {
        boolean formDebugPanel = false;
        FormBuilder builder = FormBuilder.create().columns("pref, 3dlu, min(30dlu;pref), 3dlu, pref, 3dlu, max(30dlu;pref), 3dlu, pref", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(formDebugPanel ? new FormDebugPanel() : new JPanel()));
        builder.border((Border)Paddings.DIALOG);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.definitionFileValueBean, "fileName", true);
        this.textXmlFileName = WizardComponentFactory.createTextField((ValueModel)modeModel, (boolean)false);
        this.textXmlFileName.setColumns(20);
        this.textXmlFileName.setEditable(false);
        this.textVersion = new JTextField(7);
        this.textVersion.setEditable(false);
        this.textLastUpdate = new JTextField(20);
        this.textLastUpdate.setEditable(false);
        this.textAuthor = new JTextField(20);
        this.textAuthor.setEditable(false);
        this.textDescription = new JTextField(30);
        this.textDescription.setEditable(false);
        this.userDefinedImportIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, (String)"/icons/16x16/user-defined.png");
        ImageIcon copyToUserDirIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, (String)"/icons/16x16/copy.png");
        JButton importCvDefinitionButton = new JButton(this.userDefinedImportIcon);
        importCvDefinitionButton.setToolTipText(Resources.getString(this.getClass(), (String)"import.tooltip"));
        importCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Import user-defined CV definition.");
            this.importUserDefinedCvDefinition();
        });
        this.copyToUserDirCvDefinitionButton = new JButton(copyToUserDirIcon);
        this.copyToUserDirCvDefinitionButton.setToolTipText(Resources.getString(this.getClass(), (String)"copy-to-user-dir.tooltip"));
        this.copyToUserDirCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Copy CV definition to user directory.");
            this.copyToUserDirCvDefinition();
        });
        builder.addSeparator(Resources.getString(this.getClass(), (String)"fileinfo.title"), new Object[0]).xyw(1, 1, 9);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.xmlfile"), new Object[0]).xy(1, 3);
        builder.add((Component)this.textXmlFileName).xyw(3, 3, 3);
        builder.add((Component)importCvDefinitionButton).xy(7, 3);
        builder.add((Component)this.copyToUserDirCvDefinitionButton).xy(9, 3);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.version"), new Object[0]).xy(1, 5);
        builder.add((Component)this.textVersion).xy(3, 5);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.lastchange"), new Object[0]).xy(5, 5);
        builder.add((Component)this.textLastUpdate).xyw(7, 5, 3);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.author"), new Object[0]).xy(1, 7);
        builder.add((Component)this.textAuthor).xyw(3, 7, 7);
        builder.add(Resources.getString(this.getClass(), (String)"fileinfo.description"), new Object[0]).xy(1, 9);
        builder.add((Component)this.textDescription).xyw(3, 9, 7);
        ValidationComponentUtils.setMandatory((JComponent)this.textXmlFileName, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.textXmlFileName, (Object)"validation.xmlFileName_key");
        this.cvValidationModel = new DefaultValidationResultModel();
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.definitionFileValueBean, "validation");
        this.cvValidationModel.setResult(support.getResult());
        IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.cvValidationModel, (JComponent)builder.getPanel());
        FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("p", new Object[0]);
        feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
        feedbackBuilder.border((Border)new EmptyBorder(10, 0, 0, 0));
        return feedbackBuilder.getPanel();
    }

    private JPanel createCvEditorPanel(MainModel mainModel) {
        JPanel editorContainer = new JPanel(new BorderLayout());
        editorContainer.setBorder((Border)Paddings.DIALOG);
        editorContainer.add((Component)DefaultComponentFactory.getInstance().createSeparator(Resources.getString(this.getClass(), (String)"editor.cveditor")), "North");
        this.cardLayout = new CardLayout();
        this.saveButton = new JButton(Resources.getString(this.getClass(), (String)"editor.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton resetButton = new JButton(Resources.getString(this.getClass(), (String)"editor.reset"));
        resetButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttonBar = new ButtonBarBuilder().addButton(new JComponent[]{this.saveButton, resetButton}).build();
        editorContainer.add((Component)buttonBar, "North");
        this.editorPanels = new EditorPanels(this, this.cardLayout);
        editorContainer.add((Component)this.editorPanels, "Center");
        this.editorPanels.add((Component)new JPanel(), (Object)NONE);
        this.editorPanels.add((Component)this.createBitfieldEditor(), (Object)DataType.BIT.name());
        this.editorPanels.add((Component)this.createByteEditor(), (Object)DataType.BYTE.name());
        this.editorPanels.add((Component)this.createIntegerEditor(), (Object)DataType.INT.name());
        this.editorPanels.add((Component)this.createSignedCharEditor(), (Object)DataType.SIGNED_CHAR.name());
        this.editorPanels.add((Component)this.createRadioEditor(), (Object)DataType.RADIO.name());
        this.editorPanels.add((Component)this.createLongEditor(), (Object)DataType.LONG.name());
        this.editorPanels.add((Component)this.createDccLongAddrEditor(), (Object)DataType.DCC_LONG_ADDR.name());
        this.editorPanels.add((Component)this.createStringEditor(), (Object)DataType.STRING.name());
        this.editorPanels.add((Component)this.createDccAccAddrEditor(), (Object)DataType.DCC_ACC_ADDR.name());
        this.editorPanels.add((Component)this.createDccAddrRGEditor(), (Object)DataType.DCC_ADDR_RG.name());
        this.editorPanels.add((Component)this.createGBM16TReverserEditor(), (Object)DataType.GBM_16_T_REVERSER.name());
        return editorContainer;
    }

    private Trigger getTrigger() {
        JPanel currentEditor = this.editorPanels.getCurrentPanel();
        if (currentEditor instanceof CvValueEditor) {
            return ((CvValueEditor)currentEditor).getTrigger();
        }
        return null;
    }

    private GBM16TReverserEditor createGBM16TReverserEditor() {
        this.gbm16TReverserEditor = new GBM16TReverserEditor(this.feedbackPortStatusChangeProvider, new Trigger(), null, new String[]{"/icons/GBM16TReverser.png"});
        this.mapDataTypeToEditor.put(DataType.GBM_16_T_REVERSER, this.gbm16TReverserEditor);
        return this.gbm16TReverserEditor;
    }

    private JPanel createDccAccAddrEditor() {
        this.dccAccAddrEditor = new DccAccAddrEditor();
        this.dccAccAddrEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.DCC_ACC_ADDR, this.dccAccAddrEditor);
        return this.dccAccAddrEditor;
    }

    private JPanel createDccAddrRGEditor() {
        this.dccAddrRGEditor = new DccAddrRGEditor();
        this.dccAddrRGEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.DCC_ADDR_RG, this.dccAddrRGEditor);
        return this.dccAddrRGEditor;
    }

    private JPanel createByteEditor() {
        this.byteEditor = new CvByteValueEditor();
        this.byteEditor.setValueLabelPrefix("Byte");
        this.byteEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.BYTE, this.byteEditor);
        return this.byteEditor;
    }

    private JPanel createBitfieldEditor() {
        this.bitfieldEditor = new CvBitfieldValueEditor();
        this.bitfieldEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.BIT, this.bitfieldEditor);
        return this.bitfieldEditor;
    }

    private JPanel createRadioEditor() {
        this.radioEditor = new CvRadioValueEditor();
        this.radioEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.RADIO, this.radioEditor);
        return this.radioEditor;
    }

    private JPanel createIntegerEditor() {
        this.integerEditor = new CvIntegerValueEditor();
        this.integerEditor.setValueLabelPrefix("Integer");
        this.integerEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.INT, this.integerEditor);
        return this.integerEditor;
    }

    private JPanel createLongEditor() {
        this.longEditor = new CvLongValueEditor();
        this.longEditor.setValueLabelPrefix("Long");
        this.longEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.LONG, this.longEditor);
        return this.longEditor;
    }

    private JPanel createDccLongAddrEditor() {
        this.dccLongAddrEditor = new CvDccLongAddrValueEditor();
        this.dccLongAddrEditor.setValueLabelPrefix("DccLongAddr");
        this.dccLongAddrEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.DCC_LONG_ADDR, this.dccLongAddrEditor);
        return this.dccLongAddrEditor;
    }

    private JPanel createSignedCharEditor() {
        this.signedCharEditor = new CvSignedCharValueEditor();
        this.signedCharEditor.setValueLabelPrefix("Signed Char");
        this.signedCharEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.SIGNED_CHAR, this.signedCharEditor);
        return this.signedCharEditor;
    }

    private JPanel createStringEditor() {
        this.stringEditor = new CvValueStringEditor();
        this.stringEditor.setValueLabelPrefix("String");
        this.stringEditor.create(new Trigger());
        this.mapDataTypeToEditor.put(DataType.STRING, this.stringEditor);
        return this.stringEditor;
    }

    @Override
    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    private void readCvValues() {
        LOGGER.debug("Read all configured CV values.");
        LinkedList configVars = new LinkedList();
        configVars.addAll(this.configVariables.values());
        this.readCvValues(configVars);
    }

    private void readCvValues(List<ConfigurationVariable> configVariables) {
        LOGGER.debug("Read the CV values.");
        if (configVariables != null && configVariables.size() > 0) {
            LOGGER.info("Get the CV values for configuration variables, count: {}", (Object)configVariables.size());
            this.fireLoadConfigVariables(configVariables);
        } else {
            LOGGER.warn("No configuration variables available.");
        }
    }

    public void checkPendingChanges() {
        boolean hasPendingChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)this.treeModel);
        if (!hasPendingChanges) {
            this.tabStatusListener.updatePendingChanges((JPanel)this, false);
        }
    }

    private void resetPendingChanges(DefaultExpandableRow node) {
        if (node == null) {
            return;
        }
        for (int childIndex = 0; childIndex < node.getChildrenCount(); ++childIndex) {
            DefaultExpandableRow child = (DefaultExpandableRow)node.getChildAt(childIndex);
            if (child instanceof CvNode) {
                CvNode cvNode = (CvNode)child;
                if (cvNode.getNewValue() == null) continue;
                LOGGER.debug("Reset the pending changes on node: {}", (Object)cvNode);
                cvNode.resetNewValue();
                continue;
            }
            this.resetPendingChanges(child);
        }
    }

    private void addNewValueToList(CvNode cvNode, List<ConfigurationVariable> cvList) {
        if (cvNode.getNewValue() != null) {
            String cvNumber = cvNode.getConfigVar().getName();
            String cvValue = Objects.toString(cvNode.getNewValue(), null);
            ConfigurationVariable cv = new ConfigurationVariable(cvNumber, cvValue);
            cvList.add(cv);
        }
    }

    private void addButtons(VLToolBar toolBar) {
        this.readButton = ButtonUtils.makeNavigationButton((String)"loadfromnode.png", (String)"/32x32", (String)READ, (String)Resources.getString(this.getClass(), (String)"toolbar.readallcv"), (String)Resources.getString(this.getClass(), (String)"toolbar.readallcv.alttext"));
        this.readButton.setEnabled(false);
        toolBar.add(this.readButton);
        this.readButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeButton = ButtonUtils.makeNavigationButton((String)"savetonode.png", (String)"/32x32", (String)WRITE, (String)Resources.getString(this.getClass(), (String)"toolbar.writeallcv"), (String)Resources.getString(this.getClass(), (String)"toolbar.writeallcv.alttext"));
        toolBar.add(this.writeButton);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.loadFromFileButton = ButtonUtils.makeNavigationButton((String)"loadfromfile.png", (String)"/32x32", (String)LOAD, (String)Resources.getString(this.getClass(), (String)"toolbar.loadfromfile"), (String)Resources.getString(this.getClass(), (String)"toolbar.loadfromfile.alttext"));
        toolBar.add(this.loadFromFileButton);
        this.loadFromFileButton.setEnabled(false);
        this.loadFromFileButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.saveToFileButton = ButtonUtils.makeNavigationButton((String)"savetofile.png", (String)"/32x32", (String)SAVE.toLowerCase(), (String)Resources.getString(this.getClass(), (String)"toolbar.savetofile"), (String)Resources.getString(this.getClass(), (String)"toolbar.savetofile.alttext"));
        toolBar.add(this.saveToFileButton);
        this.saveToFileButton.setEnabled(false);
        this.saveToFileButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.exportToExcelButton = ButtonUtils.makeNavigationButton((String)"exportToExcel.png", (String)"/32x32", (String)SAVE.toLowerCase(), (String)Resources.getString(this.getClass(), (String)"toolbar.exportToExcel"), (String)Resources.getString(this.getClass(), (String)"toolbar.exportToExcel.alttext"));
        toolBar.add(this.exportToExcelButton);
        this.exportToExcelButton.setEnabled(false);
        this.exportToExcelButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.cvDefinitionRequestListeners.add(l);
    }

    private void fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.loadCvValues(configVariables);
        }
    }

    public void writeConfigVariables(List<ConfigurationVariable> cvList) {
        this.fireWriteConfigVariables(cvList);
    }

    private void fireWriteConfigVariables(List<ConfigurationVariable> cvList) {
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.writeCvValues(cvList);
        }
    }

    private void potentiallyShowPopup(MouseEvent e) {
        DefaultExpandableRow row;
        int index;
        JPopupMenu popupMenu = null;
        if (e.isPopupTrigger() && (index = this.cvTreeTable.getSelectedRow()) > -1 && (popupMenu = this.buildPopup(row = (DefaultExpandableRow)this.cvTreeTable.getRowAt(index))).getComponentCount() > 0) {
            popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private JPopupMenu buildPopup(DefaultExpandableRow selectedComponent) {
        JPopupMenu pm = new JPopupMenu();
        if (selectedComponent instanceof CvNode) {
            CvNode cvNode = (CvNode)selectedComponent;
            JMenuItem readCv = new JMenuItem((Action)new CvAction(this, ActionType.READ, Resources.getString(this.getClass(), (String)"menu.readcv"), cvNode));
            pm.add(readCv);
            if (!ModeType.RO.equals((Object)cvNode.getCV().getMode()) && !ModeType.H.equals((Object)cvNode.getCV().getMode())) {
                JMenuItem writeCv = new JMenuItem((Action)new CvAction(this, ActionType.WRITE, Resources.getString(this.getClass(), (String)"menu.writecv"), cvNode));
                pm.add(writeCv);
            }
        } else if (selectedComponent instanceof NodeNode) {
            NodeNode nodeNode = (NodeNode)selectedComponent;
            JMenuItem readCv = new JMenuItem((Action)new NodeCvAction(this, ActionType.READ, Resources.getString(this.getClass(), (String)"menu.readcvs"), (AbstractNode)nodeNode));
            pm.add(readCv);
            JMenuItem writeCv = new JMenuItem((Action)new NodeCvAction(this, ActionType.WRITE, Resources.getString(this.getClass(), (String)"menu.writecvs"), (AbstractNode)nodeNode));
            pm.add(writeCv);
        } else if (selectedComponent instanceof DeviceNode) {
            DeviceNode deviceNode = (DeviceNode)selectedComponent;
            JMenuItem readCv = new JMenuItem((Action)new NodeCvAction(this, ActionType.READ, Resources.getString(this.getClass(), (String)"menu.readcvs"), (AbstractNode)deviceNode));
            pm.add(readCv);
            JMenuItem writeCv = new JMenuItem((Action)new NodeCvAction(this, ActionType.WRITE, Resources.getString(this.getClass(), (String)"menu.writecvs"), (AbstractNode)deviceNode));
            pm.add(writeCv);
        }
        return pm;
    }

    private void loadFromFileCvValues() {
        String savedCvDescription = Resources.getString(CvDefinitionPanel.class, (String)"savedCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(savedCvDescription, CV_EXCHANGE_EXTENSION);
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        11 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void setCV(String cvNumber, String cvValue) {
        if ("---".equals(cvValue)) {
            LOGGER.debug("Skip invalid value.");
            return;
        }
        ConfigurationVariable cv = (ConfigurationVariable)IterableUtils.find(this.configVariables.values(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        if (cv != null) {
            cv.setValue(cvValue);
        } else {
            LOGGER.warn("No CV found to update with cvNumber: {}, cvValue: {}", (Object)cvNumber, (Object)cvValue);
        }
    }

    private void saveToFileCvValues() {
        String saveCvDescription = Resources.getString(CvDefinitionPanel.class, (String)"saveCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(saveCvDescription, CV_EXCHANGE_EXTENSION);
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        13 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void exportCvDatatoExcel() {
        String saveCvDescription = Resources.getString(CvDefinitionPanel.class, (String)"saveCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(saveCvDescription, "xlsx");
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        14 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}", (Object)selected);
        this.toolbarCvDefinition.setVisible(selected);
    }

    private void importUserDefinedCvDefinition() {
        XmlFileFilter ff = new XmlFileFilter(this);
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);
        CvDefinitionPanel parentComponent = this;
        15 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void copyToUserDirCvDefinition() {
        int result = JOptionPane.showConfirmDialog((Component)this, Resources.getString(this.getClass(), (String)"copy-to-user-dir.message"), Resources.getString(this.getClass(), (String)"copy-to-user-dir.title"), 2, 3);
        if (result == 0) {
            LOGGER.info("Copy cv definition to user dir.");
            NodeInterface node = this.mainModel.getSelectedNode();
            DefaultContext context = new DefaultContext();
            try {
                this.cvDefinitionPanelController.copyCvDefinitionToUserDir((Context)context, node);
                LOGGER.info("Copy finished, reload the CV definition.");
                this.cvDefinitionPanelController.reloadCvDefinition((Context)context, node);
            }
            catch (Exception ex) {
                LOGGER.warn("Copy CV definition to user dir failed.");
                JOptionPane.showMessageDialog((Component)this, Resources.getString(CvDefinitionPanel.class, (String)"copy-to-user-dir.failed"), Resources.getString(CvDefinitionPanel.class, (String)"copy-to-user-dir.title"), 1);
            }
        } else {
            LOGGER.info("User canceled copy cv definition to user dir.");
        }
    }

    public PortListener<FeedbackPort> getPortListener() {
        return this.gbm16TReverserEditor.getPortListener();
    }

    public void listChanged() {
    }

    public void nodeWillChange(NodeInterface node) {
        boolean pendingChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)this.treeModel);
        if (pendingChanges) {
            throw new NodeChangeVetoException("Pending changes in CV definition detected.");
        }
    }

    public void nodeChanged(NodeInterface node) {
        LOGGER.info("The selected node has changed, reset the pending changes.");
        this.resetPendingChanges();
    }

    public void nodeStateChanged(NodeInterface node) {
    }

    public void listNodeAdded(NodeInterface node) {
    }

    public void listNodeRemoved(NodeInterface node) {
    }
}

