/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelListener;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimplePortListPanel<S extends BidibStatus, P extends Port<S>, L extends PortListener<P>, M extends PortModelListener<P>>
extends JPanel
implements PortListListener,
ChangeLabelSupport,
PortListenerProvider<P> {
    private static final long serialVersionUID = 1L;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected SimplePortTableModel<S, P, M> tableModel;
    protected PortTable table;
    protected L portListener;

    public SimplePortListPanel(SimplePortTableModel<S, P, M> tableModel, String emptyTableText) {
        this.tableModel = tableModel;
        this.setLayout((LayoutManager)new BorderLayout());
        this.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.createTable(tableModel, emptyTableText);
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.table));
        this.table.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.table.getEmptyTableText() + ":f:gray}")));
        this.add((Component)overlayTable, (Object)"Center");
    }

    protected SimplePortTableModel<S, P, M> getTableModel() {
        return this.tableModel;
    }

    protected void createTable(SimplePortTableModel<S, P, M> tableModel, String emptyTableText) {
        this.table = this.createPortTable(tableModel, emptyTableText);
        this.table.adjustRowHeight();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.setSortable(false);
        this.table.setSelectionMode(0);
    }

    protected PortTable createPortTable(SimplePortTableModel<S, P, M> tableModel, String emptyTableText) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setPortListener(L listener) {
        this.portListener = listener;
    }

    @Override
    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged() {
        if (this.tableModel == null) {
            return;
        }
        this.LOGGER.info("The port list has changed in SimplePortListPanel.");
        this.tableModel.setRowCount(0);
        LinkedList ports = new LinkedList();
        ports.addAll(this.getPorts());
        LinkedList linkedList = ports;
        synchronized (linkedList) {
            for (Port port : ports) {
                this.LOGGER.info("Adding row for port: {}", (Object)port);
                this.tableModel.addRow(port);
            }
        }
        this.LOGGER.info("The port list has changed has finished in SimplePortListPanel.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLabel(TargetType portType) {
        List ports;
        int portNum = portType.getPortNum();
        String label = portType.getLabel();
        Port port = null;
        List list = ports = this.getPorts();
        synchronized (list) {
            port = PortListUtils.findPortByPortNumber((List)ports, (int)portNum);
        }
        if (port != null) {
            this.LOGGER.info("Set the port label: {}", (Object)label);
            port.setLabel(label);
            try {
                this.portListener.labelChanged(port, label);
            }
            catch (Exception ex) {
                this.LOGGER.warn("Change port label failed.", (Throwable)ex);
            }
        }
    }

    protected abstract List<P> getPorts();

    public PortListener<P> getPortListener() {
        return this.portListener;
    }
}

