/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.SwitchPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.controller.SwitchPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SwitchPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SwitchPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.SwitchPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.SwitchPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortListPanel
extends SimpleHierarchicalPortListPanel<SwitchPortTableModel, SwitchPortStatus, SwitchPort, SwitchPortListener, SwitchPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortListPanel.class);
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public SwitchPortListPanel(SwitchPortPanelController controller, SwitchPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super((SimpleHierarchicalPortTableModel)tableModel, Resources.getString(SwitchPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, (NodeSelectionProvider)mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    protected AbstractPortHierarchicalTable<SwitchPort> createPortTable(SwitchPortTableModel tableModel, String emptyTableText) {
        return new SwitchPortTable(tableModel, emptyTableText);
    }

    protected void createTable(SwitchPortTableModel tableModel, String emptyTableText, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable((SimpleHierarchicalPortTableModel)tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table);
        this.table.setPortListMenuListener(portListMenuListener);
    }

    private PortListMenuListener createPortListMenuListener(AbstractPortHierarchicalTable<SwitchPort> portTable) {
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        return listener;
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof SwitchPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged() {
        LOGGER.info("The port list has changed.");
        super.listChanged();
        boolean hasPortIdentifiers = false;
        LinkedList ports = new LinkedList();
        ports.addAll(this.getPorts());
        LinkedList linkedList = ports;
        synchronized (linkedList) {
            for (SwitchPort port : ports) {
                if (!port.isRemappingEnabled()) continue;
                hasPortIdentifiers = true;
                break;
            }
        }
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LOGGER.info("A node is selected.");
            boolean hasSwitchPortConfigIo = false;
            boolean hasSwitchPortConfigTicks = false;
            boolean hasSwitchPortConfigLoadType = false;
            if (node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)node.getSwitchPorts())) {
                LOGGER.info("Check if at least one switch port has the switch port config available.");
                for (SwitchPort port : node.getSwitchPorts()) {
                    if (!hasSwitchPortConfigIo) {
                        hasSwitchPortConfigIo = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL));
                    }
                    if (!hasSwitchPortConfigTicks) {
                        hasSwitchPortConfigTicks = port.isPortConfigKeySupported(Byte.valueOf((byte)11));
                    }
                    if (!hasSwitchPortConfigLoadType) {
                        hasSwitchPortConfigLoadType = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE));
                    }
                    if (!hasSwitchPortConfigIo || !hasSwitchPortConfigTicks || !hasSwitchPortConfigLoadType) continue;
                    break;
                }
            } else {
                Feature switchPortConfigAvailable = Feature.findFeature((Collection)node.getNode().getFeatures(), (int)67);
                if (switchPortConfigAvailable != null) {
                    hasSwitchPortConfigTicks = hasSwitchPortConfigIo = switchPortConfigAvailable.getValue() > 0;
                }
                for (SwitchPort port : node.getSwitchPorts()) {
                    if (!hasSwitchPortConfigIo) {
                        hasSwitchPortConfigIo = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL));
                    }
                    if (!hasSwitchPortConfigTicks) {
                        hasSwitchPortConfigTicks = port.isPortConfigKeySupported(Byte.valueOf((byte)11));
                    }
                    if (!hasSwitchPortConfigLoadType) {
                        hasSwitchPortConfigLoadType = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE));
                    }
                    if (!hasSwitchPortConfigIo || !hasSwitchPortConfigTicks || !hasSwitchPortConfigLoadType) continue;
                    break;
                }
            }
            LOGGER.info("List has changed, hasPortIdentifiers: {}, hasSwitchPortConfigIo: {}, hasSwitchPortConfigTicks: {}", new Object[]{hasPortIdentifiers, hasSwitchPortConfigIo, hasSwitchPortConfigTicks});
            int viewColumnIndex = 1;
            viewColumnIndex = this.table.setColumnVisible(1, viewColumnIndex, hasSwitchPortConfigIo);
            viewColumnIndex = this.table.setColumnVisible(2, viewColumnIndex, hasSwitchPortConfigTicks);
            viewColumnIndex = this.table.setColumnVisible(3, viewColumnIndex, hasSwitchPortConfigLoadType);
            viewColumnIndex = this.table.setColumnVisible(4, viewColumnIndex, hasPortIdentifiers);
        }
        this.tabVisibilityListener.setTabVisible((Component)this, this.isTabVisible());
    }

    public Class<?> getPortClass() {
        return SwitchPort.class;
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasSwitchPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    protected List<SwitchPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LinkedList<SwitchPort> ports = new LinkedList<SwitchPort>();
            ports.addAll(node.getSwitchPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

