/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.view;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTableTableModel
extends AbstractTableAdapter<NodePingModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_UNIQUE_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_PING_INTERVAL = 3;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(PingTableTableModel.class, (String)"uniqueId"), Resources.getString(PingTableTableModel.class, (String)"description"), Resources.getString(PingTableTableModel.class, (String)"status"), Resources.getString(PingTableTableModel.class, (String)"interval")};

    public PingTableTableModel(SelectionInList<NodePingModel> nodeList) {
        super(nodeList, COLUMNNAMES);
        LOGGER.info("Current listModel: {}", (Object)this.getListModel());
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                break;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        NodePingModel nodePingModel = (NodePingModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ByteUtils.getUniqueIdAsString((long)nodePingModel.getNode().getUniqueId());
            }
            case 1: {
                return nodePingModel.getNodeLabel();
            }
            case 2: {
                return nodePingModel.getNodePingState() != NodePingState.OFF;
            }
            case 3: {
                return nodePingModel.getPingInterval();
            }
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        LOGGER.info("Set the value: {}, rowIndex: {}", value, (Object)rowIndex);
        NodePingModel nodePingModel = (NodePingModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 2: {
                if (!(value instanceof Boolean)) break;
                Boolean val = (Boolean)value;
                nodePingModel.setNodePingState(val != false ? NodePingState.ON : NodePingState.OFF);
                break;
            }
            case 3: {
                if (!(value instanceof Integer)) break;
                Integer pingInterval = (Integer)value;
                nodePingModel.setPingInterval(pingInterval);
                break;
            }
        }
    }
}

