/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.view.OperationAbortedException;
import org.bidib.wizard.mvc.pom.view.PomProgrammerView;
import org.bidib.wizard.mvc.pom.view.listener.PomProgrammerViewListener;
import org.bidib.wizard.mvc.pom.view.panel.AddressPanel;
import org.bidib.wizard.mvc.pom.view.panel.DirectAccessPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;
import org.bidib.wizard.mvc.pom.view.panel.RailcomPanel;
import org.bidib.wizard.mvc.pom.view.panel.ResetDecoderPanel;
import org.bidib.wizard.mvc.pom.view.panel.listener.PomRequestListener;
import org.bidib.wizard.mvc.pom.view.panel.listener.PomResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PomProgrammerView
implements Dockable,
RegisteredDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomProgrammerView.class);
    private final DockKey DOCKKEY = new DockKey("PomProgrammerView");
    private final Collection<PomProgrammerViewListener> listeners = new LinkedList();
    private final PomProgrammerModel cvProgrammerModel;
    private Timer switchToRunningModeController;
    private final JButton clearButton = new JButton(Resources.getString(this.getClass(), (String)"clearLogArea"));
    private final JButton closeButton = new JButton(Resources.getString(this.getClass(), (String)"close"));
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu";
    private DirectAccessPanel directAccessPanel;
    private AddressPanel addressPanel;
    private RailcomPanel railcomPanel;
    private ResetDecoderPanel resetDecoderPanel;
    private List<PomResultListener> pomResultListeners = new LinkedList();
    private final JTabbedPane tabbedPane;
    private final JPanel contentPanel;
    private static final String ENCODED_LOCAL_COLUMN_SPECS = "pref, 3dlu, max(50dlu;pref), 3dlu, pref, 3dlu, pref, 3dlu, pref:grow";
    private static final String ENCODED_LOCAL_ROW_SPECS = "p, 3dlu, p";
    private ValueModel currentDccAddressValueModel;
    private JTextField currentAddress;
    private InputValidationDocument currentAddressDocument;
    private final CurrentAddressBeanModel currentAddressBeanModel;
    private PomValidationResultModel currentAddressValidationModel;
    private static final int MIN_ADDRESS = 1;
    private static final int MAX_ADDRESS = 10239;
    private JDialog dialog;

    public PomProgrammerView(PomProgrammerModel pomProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        Object panel;
        this.cvProgrammerModel = pomProgrammerModel;
        this.currentAddressBeanModel = currentAddressBeanModel;
        this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title"));
        this.DOCKKEY.setFloatEnabled(true);
        this.DOCKKEY.setAutoHideEnabled(false);
        this.currentAddressValidationModel = new PomValidationResultModel();
        this.tabbedPane = new JTabbedPane();
        1 pomRequestListener = new /* Unavailable Anonymous Inner Class!! */;
        this.directAccessPanel = new DirectAccessPanel(this.cvProgrammerModel, currentAddressBeanModel);
        this.directAccessPanel.addPomRequestListener((PomRequestListener)pomRequestListener);
        this.pomResultListeners.add(this.directAccessPanel);
        this.addressPanel = new AddressPanel(this.cvProgrammerModel, currentAddressBeanModel);
        this.addressPanel.addPomRequestListener((PomRequestListener)pomRequestListener);
        this.pomResultListeners.add(this.addressPanel);
        this.railcomPanel = new RailcomPanel(this.cvProgrammerModel, currentAddressBeanModel);
        this.railcomPanel.addPomRequestListener((PomRequestListener)pomRequestListener);
        this.pomResultListeners.add(this.railcomPanel);
        this.resetDecoderPanel = new ResetDecoderPanel(this.cvProgrammerModel, currentAddressBeanModel);
        this.resetDecoderPanel.addPomRequestListener((PomRequestListener)pomRequestListener);
        this.pomResultListeners.add(this.resetDecoderPanel);
        this.closeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.clearButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttons = new ButtonBarBuilder().addButton((JComponent)this.clearButton).addGlue().addButton((JComponent)this.closeButton).build();
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns("pref, 3dlu, fill:50dlu:grow", new Object[0]).rows("p, 3dlu", new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns("pref, 3dlu, fill:50dlu:grow", new Object[0]).rows("p, 3dlu", new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.currentDccAddressValueModel = new PropertyAdapter((Object)currentAddressBeanModel, "dccAddress", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.currentDccAddressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        FormBuilder localBuilder = FormBuilder.create().columns("pref, 3dlu, max(50dlu;pref), 3dlu, pref, 3dlu, pref, 3dlu, pref:grow", new Object[0]).rows("p, 3dlu, p", new Object[0]);
        SelectionInList addressTypeSelection = new SelectionInList((Object[])new PomAddressTypeEnum[]{PomAddressTypeEnum.LOCOMOTIVE, PomAddressTypeEnum.ACCESSORY, PomAddressTypeEnum.EXTENDED_ACCESSORY});
        PropertyAdapter addressTypeModel = new PropertyAdapter((Object)currentAddressBeanModel, "addressType", true);
        ComboBoxAdapter comboBoxAdapterAddressType = new ComboBoxAdapter((ListModel)addressTypeSelection, (ValueModel)addressTypeModel);
        JComboBox comboAddressType = new JComboBox();
        comboAddressType.setModel(comboBoxAdapterAddressType);
        comboAddressType.setRenderer(new AddressTypeCellRenderer(this));
        localBuilder.add(Resources.getString(this.getClass(), (String)"addressType"), new Object[0]).xy(1, 1);
        localBuilder.add(comboAddressType).xy(3, 1);
        this.currentAddress = new JTextField();
        this.currentAddressDocument = new InputValidationDocument(5, "0123456789");
        this.currentAddress.setDocument((Document)this.currentAddressDocument);
        Bindings.bind((JTextField)this.currentAddress, (ValueModel)addressConverterModel, (boolean)false);
        localBuilder.add(Resources.getString(this.getClass(), (String)"current-address"), new Object[0]).xy(1, 3);
        localBuilder.add((Component)this.currentAddress).xy(3, 3);
        JLabel rcn123Label = new JLabel("(RCN-123)");
        localBuilder.add((Component)rcn123Label).xy(5, 3);
        rcn123Label.setVisible(false);
        JButton addressChangedAcknButton = new JButton(Resources.getString(this.getClass(), (String)"ackn-address-changed"));
        localBuilder.add((Component)addressChangedAcknButton).xy(7, 3);
        addressChangedAcknButton.setVisible(false);
        PropertyConnector.connect((Object)currentAddressBeanModel, (String)"addressChanged", (Object)addressChangedAcknButton, (String)"visible");
        ValidationComponentUtils.setMandatory((JComponent)this.currentAddress, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.currentAddress, (Object[])new Object[]{"validation.current_address_key"});
        localBuilder.appendRows(FormSpecs.LINE_GAP_ROWSPEC.encode(), new Object[0]);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.getValidationResultModel(), (JComponent)localBuilder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:max(20dlu;p):grow", new Object[0]);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            JPanel panel2 = feedbackBuilder.build();
            dialogBuilder.add((Component)panel2).xyw(1, 1, 3);
        } else {
            dialogBuilder.add((Component)localBuilder.build()).xyw(1, 1, 3);
        }
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-address"), null, this.addressPanel.createPanel(this.currentAddressValidationModel), Resources.getString(this.getClass(), (String)"tab-address.tooltip"));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-railcom"), null, this.railcomPanel.createPanel(this.currentAddressValidationModel), Resources.getString(this.getClass(), (String)"tab-railcom.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-direct-access"), null, this.directAccessPanel.createPanel(this.currentAddressValidationModel), Resources.getString(this.getClass(), (String)"tab-direct-access.tooltip"));
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-reset"), null, this.resetDecoderPanel.createPanel(this.currentAddressValidationModel), Resources.getString(this.getClass(), (String)"tab-reset.tooltip"));
        this.tabbedPane.setMnemonicAt(2, 52);
        dialogBuilder.appendRows("fill:p:grow", new Object[0]);
        dialogBuilder.add((Component)this.tabbedPane).xyw(1, 3, 3);
        dialogBuilder.appendRows("3dlu, p", new Object[0]);
        dialogBuilder.add((Component)buttons).xyw(1, 5, 3);
        this.contentPanel = dialogBuilder.build();
        DisabledPanel.disable((Container)this.contentPanel);
        this.closeButton.setEnabled(true);
        this.cvProgrammerModel.addPropertyChangeListener("commandStationState", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvProgrammerModel.addPropertyChangeListener("pomProgState", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        currentAddressBeanModel.addPropertyChangeListener("dccAddress", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        currentAddressBeanModel.addPropertyChangeListener("addressChanged", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        currentAddressBeanModel.addPropertyChangeListener("addressType", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        addressChangedAcknButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.triggerValidation();
    }

    public static String prepareKey(Integer address) {
        if (address != null) {
            return PomProgrammerView.class.getSimpleName() + "-" + address;
        }
        return PomProgrammerView.class.getSimpleName() + "-";
    }

    public String getKey() {
        LOGGER.info("Prepare the key: {}", (Object)this.currentAddressBeanModel);
        Integer address = this.currentAddressBeanModel.getDccAddress();
        return PomProgrammerView.prepareKey((Integer)address);
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    private void triggerValidation() {
        LOGGER.info("Trigger the validation.");
        ValidationResult validationResult = this.validate();
        this.currentAddressValidationModel.setResult(validationResult);
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.currentAddressBeanModel, "validation");
        if (this.currentAddressBeanModel.getDccAddress() == null) {
            support.addError("current_address_key", "not_empty");
        } else if (this.currentAddressBeanModel.getDccAddress() < 1 || this.currentAddressBeanModel.getDccAddress() > 10239) {
            support.addError("current_address_key", "invalid_value;min=1,max=10239");
        }
        if (Boolean.TRUE.equals(this.currentAddressBeanModel.getAddressChanged())) {
            support.add(Severity.WARNING, "current_address_key", "address_changed_automatically");
        }
        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    private ValidationResultModel getValidationResultModel() {
        return this.currentAddressValidationModel;
    }

    public void prepareDockable(DockingDesktop desktop, int x, int y) {
        desktop.addDockable((Dockable)this);
        this.initialize();
    }

    public Window getWindow() {
        return this.dialog;
    }

    public void showDialog(JFrame parent, int x, int y) {
        this.dialog = new JDialog((Frame)parent, false);
        this.dialog.setTitle(Resources.getString(this.getClass(), (String)"title"));
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setContentPane(this.contentPanel);
        this.dialog.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        this.dialog.setMinimumSize(new Dimension((int)this.contentPanel.getPreferredSize().getWidth() + 10, (int)this.contentPanel.getPreferredSize().getHeight() + 35));
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        this.initialize();
    }

    public void initialize() {
        LOGGER.info("Switch CS to running mode.");
        this.switchToRunningModeController = new Timer(5000, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.switchToRunningModeController.setRepeats(false);
        try {
            boolean activateControlTimer = this.fireSetRunningMode(true);
            if (activateControlTimer) {
                LOGGER.info("Start control timer for switch to running mode is started.");
                if (this.switchToRunningModeController != null) {
                    this.switchToRunningModeController.start();
                } else {
                    LOGGER.warn("The control timer is no longer needed!");
                }
            } else {
                LOGGER.info("Start control timer for switch to running mode is NOT started.");
            }
        }
        catch (OperationAbortedException ex) {
            LOGGER.warn("The user has aborted the POM operation dialog: {}", (Object)ex.getMessage());
            this.close();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Switch command station to running state failed.");
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(PomProgrammerView.class, (String)"switch-to-running-mode-failed.message"), Resources.getString(PomProgrammerView.class, (String)"switch-to-running-mode-failed.title"), 0);
            this.close();
        }
    }

    public void addPomProgrammerViewListener(PomProgrammerViewListener l) {
        this.listeners.add(l);
    }

    private void addLogText(String logLine, Object ... args) {
        for (PomResultListener listener : this.pomResultListeners) {
            listener.addLogText(logLine, args);
        }
    }

    private void signalCommandStationStateChanged(CommandStationState commandStationState) {
        if (CommandStationState.GO.equals((Object)commandStationState) || CommandStationState.GO_IGN_WD.equals((Object)commandStationState)) {
            if (this.switchToRunningModeController != null) {
                LOGGER.info("The command station has switched to running mode. Stop the control timer.");
                this.switchToRunningModeController.stop();
                this.switchToRunningModeController = null;
                this.addLogText("Switched to programming mode passed.", new Object[0]);
                DisabledPanel.enable((Container)this.contentPanel);
            } else {
                LOGGER.info("No control timer available.");
            }
        }
    }

    private void signalPomProgStateChanged(PomProgState pomProgState) {
        switch (12.$SwitchMap$org$bidib$jbidibc$messages$enums$PomProgState[pomProgState.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                LOGGER.info("Enable the tabs");
                for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
                    this.tabbedPane.setEnabledAt(index, true);
                }
            }
        }
        for (PomResultListener listener : this.pomResultListeners) {
            listener.signalPomProgStateChanged(pomProgState);
        }
    }

    public void close() {
        this.contentPanel.setVisible(false);
        if (this.switchToRunningModeController != null) {
            LOGGER.info("Stop the control timer for the command station has switched to running mode.");
            this.switchToRunningModeController.stop();
            this.switchToRunningModeController = null;
        }
        LOGGER.info("Close the dialog.");
        this.fireClose();
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private void fireClose() {
        for (PomProgrammerViewListener l : this.listeners) {
            l.close();
        }
    }

    private boolean fireSetRunningMode(boolean activateProgMode) {
        boolean startControlTimer = false;
        for (PomProgrammerViewListener l : this.listeners) {
            LOGGER.info("+++ Send the command station state request: {}", (Object)activateProgMode);
            boolean messageSent = l.sendCommandStationStateRequest(activateProgMode);
            if (startControlTimer) continue;
            startControlTimer = messageSent;
        }
        return startControlTimer;
    }

    public void closeDialog() {
        LOGGER.info("Close the dialog is requested.");
        this.close();
    }
}

