package org.bidib.wizard.mvc.accessory.view.panel.listener;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;

public interface DccAccessoryRequestListener {

    /**
     * Send the DCC accessory request.
     * 
     * @param accessoryResultListener
     *            the accessory result listener
     * @param dccAddress
     *            the DCC address to switch
     * @param aspect
     *            the aspect to set
     * @param switchTime
     *            the switch time
     * @param timeBaseUnit
     *            the time base unit (100ms or 1s)
     * @param timingControl
     *            the timing control
     */
    void sendRequest(
        AccessoryResultListener accessoryResultListener, AddressData dccAddress, Integer aspect, Integer switchTime,
        TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl);
}
