package org.bidib.wizard.mvc.loco.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedometerProgBeanModel extends ProgCommandAwareBeanModel {
    private static final long serialVersionUID = 1L;

    private final Logger LOGGER = LoggerFactory.getLogger(getClass());

    public static final String PROPERTYNAME_CV2_VMIN = "cv2Vmin";

    public static final String PROPERTYNAME_CV5_VMAX = "cv5Vmax";

    public static final String PROPERTYNAME_CV35 = "cv35";

    public static final String PROPERTYNAME_CV36 = "cv36";

    public static final String PROPERTYNAME_CV37_SCALE = "cv37Scale";

    public static final String PROPERTYNAME_CV59 = "cv59";

    public static final String PROPERTYNAME_CV61 = "cv61";

    public static final String PROPERTYNAME_CV62 = "cv62";

    public static final String PROPERTYNAME_CV63 = "cv63";

    public static final String PROPERTYNAME_CV111 = "cv111";

    public static final String PROPERTYNAME_CV7 = "cv7";

    public static final String PROPERTYNAME_CV109 = "cv109";

    public static final String PROPERTYNAME_CV110 = "cv110";

    public static final String PROPERTYNAME_FIRMWARE = "firmware";

    private Integer cv2Vmin;

    private Integer cv5Vmax;

    private Integer cv35;

    private Integer cv36;

    private Integer cv37Scale;

    // if car decoder v3: the load control is bit 7
    private Integer cv59;

    private Integer cv61;

    private Integer cv62;

    private Integer cv63;

    private Integer cv111;

    private Integer cv7; // firmware main

    private Integer cv109; // firmware minor

    private Integer cv110; // firmware micro

    private String firmware;

    /**
     * @return the cv2Vmin
     */
    public Integer getCv2Vmin() {
        return cv2Vmin;
    }

    /**
     * @param cv2Vmin
     *            the cv2Vmin to set
     */
    public void setCv2Vmin(Integer cv2Vmin) {
        LOGGER.debug("Set CV2Vmin value: {}", cv2Vmin);
        Integer oldValue = this.cv2Vmin;
        this.cv2Vmin = cv2Vmin;

        firePropertyChange(PROPERTYNAME_CV2_VMIN, oldValue, cv2Vmin);
    }

    /**
     * @return the cv5Vmax
     */
    public Integer getCv5Vmax() {
        return cv5Vmax;
    }

    /**
     * @param cv5Vmax
     *            the cv5Vmax to set
     */
    public void setCv5Vmax(Integer cv5Vmax) {
        LOGGER.debug("Set CV5Vmax value: {}", cv5Vmax);
        Integer oldValue = this.cv5Vmax;
        this.cv5Vmax = cv5Vmax;

        firePropertyChange(PROPERTYNAME_CV5_VMAX, oldValue, cv5Vmax);
    }

    /**
     * @return the cv35
     */
    public Integer getCv35() {
        return cv35;
    }

    /**
     * @param cv35
     *            the cv35 to set
     */
    public void setCv35(Integer cv35) {
        LOGGER.debug("Set CV35 value: {}", cv35);

        Integer oldValue = this.cv35;
        this.cv35 = cv35;

        firePropertyChange(PROPERTYNAME_CV35, oldValue, cv35);
    }

    /**
     * @return the cv36
     */
    public Integer getCv36() {
        return cv36;
    }

    /**
     * @param cv36
     *            the cv36 to set
     */
    public void setCv36(Integer cv36) {
        LOGGER.debug("Set CV36 value: {}", cv36);

        Integer oldValue = this.cv36;
        this.cv36 = cv36;

        firePropertyChange(PROPERTYNAME_CV36, oldValue, cv36);
    }

    /**
     * @return the cv37Scale
     */
    public Integer getCv37Scale() {
        return cv37Scale;
    }

    /**
     * @param cv37Scale
     *            the cv37Scale to set
     */
    public void setCv37Scale(Integer cv37Scale) {
        Integer oldValue = this.cv37Scale;
        this.cv37Scale = cv37Scale;

        firePropertyChange(PROPERTYNAME_CV37_SCALE, oldValue, cv37Scale);
    }

    /**
     * @return the cv59
     */
    public Integer getCv59() {
        return cv59;
    }

    /**
     * @param cv59
     *            the cv59 to set
     */
    public void setCv59(Integer cv59) {
        LOGGER.debug("Set CV59: {}", cv59);

        Integer oldValue = this.cv59;
        this.cv59 = cv59;

        firePropertyChange(PROPERTYNAME_CV59, oldValue, cv59);
    }

    /**
     * @return the cv61
     */
    public Integer getCv61() {
        return cv61;
    }

    /**
     * @param cv61
     *            the cv61 to set
     */
    public void setCv61(Integer cv61) {
        LOGGER.debug("Set CV61: {}", cv61);

        Integer oldValue = this.cv61;
        this.cv61 = cv61;

        firePropertyChange(PROPERTYNAME_CV61, oldValue, cv61);
    }

    /**
     * @return the cv62
     */
    public Integer getCv62() {
        return cv62;
    }

    /**
     * @param cv62
     *            the cv62 to set
     */
    public void setCv62(Integer cv62) {
        LOGGER.debug("Set CV62: {}", cv62);

        Integer oldValue = this.cv62;
        this.cv62 = cv62;

        firePropertyChange(PROPERTYNAME_CV62, oldValue, cv62);
    }

    /**
     * @return the cv63
     */
    public Integer getCv63() {
        return cv63;
    }

    /**
     * @param cv63
     *            the cv63 to set
     */
    public void setCv63(Integer cv63) {
        LOGGER.debug("Set CV63: {}", cv63);

        Integer oldValue = this.cv63;
        this.cv63 = cv63;

        firePropertyChange(PROPERTYNAME_CV63, oldValue, cv63);
    }

    /**
     * @return the cv111
     */
    public Integer getCv111() {
        return cv111;
    }

    /**
     * @param cv111
     *            the cv111 to set
     */
    public void setCv111(Integer cv111) {

        LOGGER.debug("Set CV111: {}", cv111);

        Integer oldValue = this.cv111;
        this.cv111 = cv111;

        firePropertyChange(PROPERTYNAME_CV111, oldValue, cv111);

        // check if V3 decoder
        if (cv111 != null && (cv111 / 10 == 3)) {
            // check if the load control is active
            if (cv59 != null && ((cv59.intValue() & 0x80) == 0x00)) {
                LOGGER.warn("Load control is off!");
            }
        }
    }

    /**
     * @return the cv7
     */
    public Integer getCv7() {
        return cv7;
    }

    /**
     * @param cv7
     *            the cv7 to set
     */
    public void setCv7(Integer cv7) {
        Integer oldValue = this.cv7;
        this.cv7 = cv7;

        firePropertyChange(PROPERTYNAME_CV7, oldValue, cv7);

        updateFirmware();
    }

    /**
     * @return the cv109
     */
    public Integer getCv109() {
        return cv109;
    }

    /**
     * @param cv109
     *            the cv109 to set
     */
    public void setCv109(Integer cv109) {
        Integer oldValue = this.cv109;
        this.cv109 = cv109;

        firePropertyChange(PROPERTYNAME_CV109, oldValue, cv109);

        updateFirmware();
    }

    /**
     * @return the cv110
     */
    public Integer getCv110() {
        return cv110;
    }

    /**
     * @param cv110
     *            the cv110 to set
     */
    public void setCv110(Integer cv110) {
        Integer oldValue = this.cv110;
        this.cv110 = cv110;

        firePropertyChange(PROPERTYNAME_CV110, oldValue, cv110);

        updateFirmware();
    }

    public String getFirmware() {
        return firmware;
    }

    public void setFirmware(String firmware) {
        String oldValue = this.firmware;
        this.firmware = firmware;

        firePropertyChange(PROPERTYNAME_FIRMWARE, oldValue, firmware);
    }

    private void updateFirmware() {
        LOGGER.debug("Update the firmware.");
        if (cv7 != null && cv109 != null && cv110 != null) {
            String firmware = String.format("%1$d.%2$02d.%3$02d", cv7, cv109, cv110);
            setFirmware(firmware);
        }
        else {
            setFirmware(null);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
