package org.bidib.wizard.mvc.main.model.listener;

import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.SwitchPortStatus;

public interface SwitchPortModelListener extends PortModelListener<SwitchPort> {

    /**
     * Change the port type.
     * 
     * @param portType
     *            the requested port type
     * @param port
     *            the port
     */
    void changePortType(LcOutputType portType, SwitchPort port);

    /**
     * The test button was pressed.
     * 
     * @param port
     *            the port
     * @param requestedStatus
     *            the requested port status
     */
    void testButtonPressed(SwitchPort port, SwitchPortStatus requestedStatus);

}
