package org.bidib.wizard.mvc.main.view.menu.listener;

public interface MainMenuListener {
    /**
     * Show about dialog.
     */
    void about();

    /**
     * Disconnect to BiDiB.
     */
    void connect();

    /**
     * Disconnect from BiDiB.
     */
    void disconnect();

    /**
     * Listen for netBiDiB.
     */
    void listenNetBidib();

    /**
     * Switch all booster off.
     */
    void allBoosterOff();

    /**
     * Switch all booster on.
     */
    void allBoosterOn();

    /**
     * Exit the application.
     */
    void exit();

    /**
     * Open the preferences.
     */
    void preferences();

    /**
     * Collect the logfiles
     */
    void collectLogFiles();

    /**
     * Open the log panel.
     */
    void logPanel();

    /**
     * Open the booster table.
     */
    void boosterTable();

    /**
     * Open the ping table.
     */
    void pingTable();

    /**
     * Open the console.
     */
    void console();

    /**
     * Open the node script editor.
     */
    void nodeScriptView();

    /**
     * Open the debug interface panel.
     */
    void debugInterface();

    /**
     * Open the netDebug panel.
     */
    void netDebug();

    /**
     * Open the debug console panel.
     */
    void debugConsole();

    /**
     * Open the DCC-A panel.
     */
    void dccAdv();

    /**
     * Show the node script wizard.
     */
    void showNodeScriptWizard();

    /**
     * Open the feedback position table.
     */
    void feedbackPositionTable();

    /**
     * Show the firmware repo.
     */
    void showFirmwareRepo();

    /**
     * Show the nodes client.
     */
    void showNodesClient();

    /**
     * Show the script client.
     */
    void showScriptClient();

    /**
     * Show the tracer client.
     */
    void showTracerClient();

    /**
     * Show the localHost client.
     */
    void showLocalHostClient();

    /**
     * Show the loco dialog.
     */
    void showLocoDialog();

    /**
     * Show the car dialog.
     */
    void showCarDialog();

    /**
     * Save the current node tree as simulation.
     */
    void saveNodeTreeForSimulation();

    /**
     * Backup all nodes.
     */
    void backupAllNodes();

    /**
     * Save the current node tree for comparison purposes.
     */
    void saveNodeTreeForComparison();
}
