package org.bidib.wizard.mvc.main.view.statusbar;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.listener.DefaultStatusListener;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.panel.listener.StatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.status.ButtonStatusBarItem;
import com.jidesoft.swing.JideToggleButton;

public class StatusButtonStatusBarItem extends ButtonStatusBarItem {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(StatusButtonStatusBarItem.class);

    private Collection<StatusListener> statusListeners = new LinkedList<StatusListener>();

    private JideToggleButton onButton;

    private final StatusModel model;

    public StatusButtonStatusBarItem(StatusModel model) {
        super();

        this.model = model;

        onButton.setSelected(model.isRunning());
        updateButton(model.isRunning());

        this.model.addStatusListener(new DefaultStatusListener() {
            @Override
            public void runningChanged(boolean running) {
                updateButton(running);
            }
        });

    }

    @Override
    protected AbstractButton createButton() {
        onButton = new JideToggleButton();

        onButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JideToggleButton button = (JideToggleButton) e.getSource();

                if (button.isSelected()) {
                    fireSwitchedOn();
                }
                else {
                    fireSwitchedOff();
                }
            }
        });

        return onButton;
    }

    @Override
    public String getItemName() {
        return "StatusButtonPanel";
    }

    private void updateButton(boolean running) {
        if (running) {
            onButton.setText(Resources.getString(StatusButtonStatusBarItem.class, "on"));
            onButton.setToolTipText(Resources.getString(StatusButtonStatusBarItem.class, "on-tooltip"));
        }
        else {
            onButton.setText(Resources.getString(StatusButtonStatusBarItem.class, "off"));
            onButton.setToolTipText(Resources.getString(StatusButtonStatusBarItem.class, "off-tooltip"));
        }
    }

    public void setTitleBorder() {
        setBorder(BorderFactory
            .createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(getClass(), "title") + ":"));
    }

    public void setButtonHeight(int height) {
        LOGGER.info("Set the button height: {}", height);

        onButton.setPreferredSize(new Dimension(60, height));
    }

    public JideToggleButton getButton() {
        return onButton;
    }

    public void addStatusListener(StatusListener l) {
        statusListeners.add(l);
    }

    private void fireSwitchedOff() {
        LOGGER.info("Switch model time off");
        for (StatusListener l : statusListeners) {
            l.switchedOff();
        }
    }

    private void fireSwitchedOn() {
        LOGGER.info("Switch model time on");
        for (StatusListener l : statusListeners) {
            l.switchedOn();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        LOGGER.info("Change the button enabled: {}", enabled);
        super.setEnabled(enabled);
        onButton.setEnabled(enabled);
    }
}
