package org.bidib.wizard.mvc.preferences.view.panel;

import java.awt.BorderLayout;
import java.io.File;
import java.util.function.Consumer;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.core.model.settings.NetBidibSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class NetBidibSettingsPanel extends AbstractSettingsPanel<NetBidibSettingsInterface> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibSettingsPanel.class);

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow, 3dlu, pref";

    private static final String ENCODED_DIALOG_ROW_SPECS =
        "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";

    private final NetBidibSettingsInterface netBidibSettings;

    private JPanel contentPanel;

    public NetBidibSettingsPanel(final NetBidibSettingsInterface netBidibSettings,
        final Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.netBidibSettings = netBidibSettings;
    }

    public JPanel createPanel() {

        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            JPanel panel = new FormDebugPanel();
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        else {
            JPanel panel = new JPanel(new BorderLayout());
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        // use value model here and only update settings on focus lost

        preparePresentationModel(this.netBidibSettings);

        // netbidib uniqueid
        final BufferedValueModel bufferedUniqueIdModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_NETBIDIB_UNIQUEID);

        // TODO make the pid configurable
        final ValueModel currentUniqueIdConverterModel =
            new ConverterValueModel(bufferedUniqueIdModel, new StringToNetBidibUniqueIdConverter(
                NetBidibSettingsInterface.WIZARD_VID, NetBidibSettingsInterface.WIZARD_PID));

        dialogBuilder.add(Resources.getString(getClass(), "netBidibClientSerialNumber") + ":").xy(1, 1);
        dialogBuilder
            .add(String
                .format("V %1$02X P %2$02X%3$02X", NetBidibSettingsInterface.WIZARD_VID,
                    ByteUtils.getLowByte(NetBidibSettingsInterface.WIZARD_PID),
                    ByteUtils.getHighByte(NetBidibSettingsInterface.WIZARD_PID)))
            .xy(3, 1);
        final JTextField netBidibClientSerialNumber = new JTextField();
        netBidibClientSerialNumber.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC_HEX));

        // bind manually because we changed the document of the textfield
        Bindings.bind(netBidibClientSerialNumber, currentUniqueIdConverterModel, false);

        dialogBuilder.add(netBidibClientSerialNumber).xyw(5, 1, 3);

        // jmDnsName
        final BufferedValueModel bufferedJmDnsNameModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_JMDNSNAME);

        dialogBuilder.add(Resources.getString(getClass(), "jmDnsName") + ":").xy(1, 3);
        final JTextField jmDnsName = WizardComponentFactory.createTextField(bufferedJmDnsNameModel, false);
        dialogBuilder.add(jmDnsName).xyw(3, 3, 5);

        // interface discovery port
        final BufferedValueModel bufferedInterfaceDiscoveryPortModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_INTERFACE_PORT_DISCOVERY_NETBIDIB);
        final ValueModel interfaceDiscoveryPortConverterModel =
            new ConverterValueModel(bufferedInterfaceDiscoveryPortModel,
                new StringToIntegerConverter(Integer.valueOf(30)));

        dialogBuilder.add(Resources.getString(getClass(), "discoveryNetBidibInterfacePort") + ":").xy(1, 5);
        final JTextField interfaceDiscoveryPort = new JTextField();
        interfaceDiscoveryPort.setDocument(new InputValidationDocument(5, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(interfaceDiscoveryPort, interfaceDiscoveryPortConverterModel, false);

        dialogBuilder.add(interfaceDiscoveryPort).xyw(3, 5, 5);

        // pairing timeout
        final BufferedValueModel bufferedPairingTimeoutModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_PAIRING_TIMEOUT);
        final ValueModel pairingTimeoutConverterModel =
            new ConverterValueModel(bufferedPairingTimeoutModel, new StringToIntegerConverter(Integer.valueOf(30)));

        dialogBuilder.add(Resources.getString(getClass(), "pairingTimeout") + ":").xy(1, 7);
        final JTextField pairingTimeout = new JTextField();
        pairingTimeout.setDocument(new InputValidationDocument(4, InputValidationDocument.NUMERIC));

        // bind manually because we changed the document of the textfield
        Bindings.bind(pairingTimeout, pairingTimeoutConverterModel, false);

        dialogBuilder.add(pairingTimeout).xyw(3, 7, 5);

        // periodic search mDNS
        final BufferedValueModel periodicSearchmDnsEnabledModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_PERIODIC_SEARCH_MDNS_ENABLED);

        JCheckBox periodicSearchmDnsEnabled =
            WizardComponentFactory
                .createCheckBox(periodicSearchmDnsEnabledModel,
                    Resources.getString(getClass(), "periodicSearchmDnsEnabled"));
        dialogBuilder.add(periodicSearchmDnsEnabled).xyw(1, 9, 7);

        // discovery
        final BufferedValueModel discoveryEnabledModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_DISCOVERY_ENABLED);

        JCheckBox discoveryEnabled =
            WizardComponentFactory
                .createCheckBox(discoveryEnabledModel, Resources.getString(getClass(), "discoveryEnabled"));
        dialogBuilder.add(discoveryEnabled).xyw(1, 11, 7);

//        // discovery UPNP
//        final BufferedValueModel discoveryUpnpEnabledModel =
//            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_DISCOVERY_UPNP_ENABLED);
//
//        JCheckBox discoveryUpnpEnabled =
//            WizardComponentFactory
//                .createCheckBox(discoveryUpnpEnabledModel, Resources.getString(getClass(), "discoveryUpnpEnabled"));
//        dialogBuilder.add(discoveryUpnpEnabled).xyw(1, 13, 7);

        // discovery on all network interfaces
        final BufferedValueModel discoveryOnAllNetworkInterfacesEnabledModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_DISCOVERY_ON_ALL_NETWORK_INTERFACES_ENABLED);

        JCheckBox discoveryOnAllNetworkInterfacesEnabled =
            WizardComponentFactory
                .createCheckBox(discoveryOnAllNetworkInterfacesEnabledModel, Resources.getString(getClass(), "discoveryOnAllNetworkInterfacesEnabled"));
        dialogBuilder.add(discoveryOnAllNetworkInterfacesEnabled).xyw(1, 13, 7);

        // pairing store location
        dialogBuilder.add(Resources.getString(getClass(), "pairingStoreLocation") + ":").xy(1, 15);

        final BufferedValueModel pairingStoreLocationModel =
            presentationModel.getBufferedModel(NetBidibSettings.PROPERTY_PAIRING_STORE_LOCATION);

        final JTextField pairingStoreLocation =
            WizardComponentFactory.createTextField(pairingStoreLocationModel, false);

        dialogBuilder.add(pairingStoreLocation).xyw(3, 15, 3);

        final JButton selectDirectoyButton =
            new JButton(Resources.getString(NetBidibSettingsPanel.class, "select-directory"));
        selectDirectoyButton
            .setToolTipText(Resources.getString(NetBidibSettingsPanel.class, "select-directory.tooltip"));
        selectDirectoyButton.addActionListener(evt -> {
            // select the directory
            String storedPairingStoreDirectory = pairingStoreLocationModel.getString();

            final FileFilter[] ff = null;
            FileDialog dialog =
                new FileDialog(this.contentPanel, FileDialog.SAVE, storedPairingStoreDirectory, (String) null, ff) {
                    @Override
                    public void approve(String selectedFile) {
                        File file = new File(selectedFile);
                        if (file != null && file.isDirectory()) {

                            String pairingStoreLocationDir = file.getPath();
                            LOGGER.info("Set the pairing store location: {}", pairingStoreLocationDir);
                            pairingStoreLocation.setText(pairingStoreLocationDir);
                        }
                    }
                };
            dialog.setApproveButtonText(Resources.getString(NetBidibSettingsPanel.class, "select-directory"));
            dialog.showDialog();

        });
        dialogBuilder.add(selectDirectoyButton).xy(7, 15);

        contentPanel = dialogBuilder.build();
        contentPanel.setOpaque(false);
        return contentPanel;
    }

}
