/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.checkboxtree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class InvisibleNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    protected boolean isVisible;

    public InvisibleNode() {
        this(null);
    }

    public InvisibleNode(Object userObject) {
        this(userObject, true, true);
    }

    public InvisibleNode(Object userObject, boolean allowsChildren, boolean isVisible) {
        super(userObject, allowsChildren);
        this.isVisible = isVisible;
    }

    public TreeNode getChildAt(int index, boolean filterIsActive) {
        if (!filterIsActive) {
            return super.getChildAt(index);
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int realIndex = -1;
        int visibleIndex = -1;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            InvisibleNode node = (InvisibleNode)e.nextElement();
            if (node.isVisible()) {
                ++visibleIndex;
            }
            ++realIndex;
            if (visibleIndex != index) continue;
            return (TreeNode)this.children.elementAt(realIndex);
        }
        throw new ArrayIndexOutOfBoundsException("index unmatched");
    }

    public int getChildCount(boolean filterIsActive) {
        if (!filterIsActive) {
            return super.getChildCount();
        }
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            InvisibleNode node = (InvisibleNode)e.nextElement();
            if (!node.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }
}

