/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.scenery;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.common.collect.ObservableList;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.binding.MultiListSelectionAdapter;
import org.bidib.wizard.client.common.view.binding.MultiSelectionInList;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.mvc.dmx.view.scenery.DmxChannelSelectionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxChannelSelectionPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxChannelSelectionPanel.class);
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, fill:200dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref";
    private final JButton cancelButton = new JButton(Resources.getString(this.getClass(), (String)"cancel"));
    private final JButton applyButton = new JButton(Resources.getString(this.getClass(), (String)"apply"));
    private JList<DmxChannel> channelList;
    private MultiSelectionInList<DmxChannel> channelSelection;
    private ObservableList<DmxChannel> selectionHolder;

    private JPanel createPanel(List<DmxChannel> dmxChannels) {
        FormBuilder builder = null;
        boolean debug = false;
        builder = debug ? FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.TABBED_DIALOG);
        this.channelSelection = new MultiSelectionInList((Object[])dmxChannels.toArray(new DmxChannel[0]));
        this.selectionHolder = this.channelSelection.getSelection();
        this.channelList = new JList();
        this.channelList.setModel(this.channelSelection.getList());
        this.channelList.setSelectionMode(2);
        this.channelList.setSelectionModel((ListSelectionModel)new MultiListSelectionAdapter(this.channelSelection));
        builder.add((Component)new JScrollPane(this.channelList)).xyw(1, 1, 3);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.cancelButton, this.applyButton}).build();
        builder.add((Component)buttons).xyw(1, 3, 3);
        return builder.build();
    }

    public List<DmxChannel> showDialog(Frame frame, List<DmxChannel> dmxChannels) {
        JPanel dialogPanel = this.createPanel(dmxChannels);
        DmxChannelSelectionDialog dialog = new DmxChannelSelectionDialog(frame, Resources.getString(this.getClass(), (String)"title"), dialogPanel);
        ValueHolder selectedDmxChannels = new ValueHolder();
        this.applyButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        dialog.showDialog();
        if (selectedDmxChannels.getValue() == null) {
            selectedDmxChannels.setValue(Collections.emptyList());
        }
        LOGGER.info("Selected DMX channels: {}", selectedDmxChannels.getValue());
        return (List)selectedDmxChannels.getValue();
    }
}

