/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.jidesoft.swing.FolderChooser;
import com.vlsolutions.swing.docking.DockingContext;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Component;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.api.json.types.ConnectionPhase;
import org.bidib.jbidibc.core.BidibDistributedMessageListener;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.NetBidibSocketType;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.NodeErrorListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.NodeSelectionListener;
import org.bidib.wizard.api.notification.NodeStatusInfo;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.event.BidibConnectionEvent;
import org.bidib.wizard.client.common.event.MainControllerBoosterOnEvent;
import org.bidib.wizard.client.common.event.MainControllerEvent;
import org.bidib.wizard.client.common.event.MenuEvent;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.config.MainViewFactory;
import org.bidib.wizard.core.model.connection.exception.ConnectionException;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.dialog.PairingDialog;
import org.bidib.wizard.localhost.config.LocalHostHandlerFactory;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.main.controller.AlertController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.controller.MainCvDefinitionRequestListener;
import org.bidib.wizard.mvc.main.controller.exception.CloseAbortedException;
import org.bidib.wizard.mvc.main.controller.listener.AlertListener;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainNodeListActionListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.tips.controller.TipOfDayClosedListener;
import org.bidib.wizard.mvc.tips.controller.TipOfDayController;
import org.bidib.wizard.startup.WizardStartupParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.xml.sax.SAXException;

public class MainController
implements MainControllerInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainController.class);
    private final MainModel mainModel;
    @Autowired
    private MainViewFactory mainViewFactory;
    private MainView mainView;
    @Autowired
    private MainNodeListActionListener mainNodeListActionListener;
    private final ScheduledExecutorService selectedNodeChangeWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("selectedNodeChangeWorkers-thread-%d").build());
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private AlertController alertController;
    @Autowired
    private TipOfDayController tipOfDayController;
    @Autowired
    private MiscSettingsInterface miscSettings;
    @Autowired
    private WizardSettingsInterface wizardSettings;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private CvDefinitionPanelControllerInterface cvDefinitionPanelController;
    @Autowired
    private WizardStartupParams startupParams;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private ConsoleService consoleService;
    private final ConnectionPhaseModel connectionPhaseModel;
    private CompositeDisposable compDisposable = new CompositeDisposable();
    private CompositeDisposable compDispConnectionStatusChanges = new CompositeDisposable();
    private PairingDialog pairingDialog;
    private final String connectionId;
    @Autowired
    private DockingContext dockingContext;
    private AtomicBoolean startupPassed = new AtomicBoolean();
    private final ScheduledExecutorService openConnectionWorker;
    @Autowired(required=false)
    private LocalHostHandlerFactory localHostHandlerFactory;
    private final ScheduledExecutorService startupWorkers = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("startupWorkers-thread-%d").build());
    private final Object openThreadLock = new Object();
    private Future<?> openConnectionFuture;
    private final ScheduledExecutorService netBidibPublisherWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("netBidibPublisherWorkers-thread-%d").build());

    public MainController(MainModel model, ConnectionPhaseModel connectionPhaseModel, String connectionId) {
        LOGGER.info("Created MainController, provided connectionId: {}", (Object)connectionId);
        this.connectionId = connectionId;
        this.connectionPhaseModel = connectionPhaseModel;
        connectionPhaseModel.setConnectionId(this.connectionId);
        this.mainModel = model;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("openConnectionWorkers-thread-%d").build();
        this.openConnectionWorker = Executors.newScheduledThreadPool(1, namedThreadFactory);
    }

    @PostConstruct
    public void init() {
        LOGGER.info("Initialize the main controller.");
        1 nodeErrorListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainModel.setNodeErrorListener((NodeErrorListener)nodeErrorListener);
    }

    public boolean hasStartupPassed() {
        return this.startupPassed.get();
    }

    public void clearNodes() {
        LOGGER.info("Clear the nodes from the model.");
        this.mainModel.getStatusModel().setCd(false);
        this.mainModel.getStatusModel().setRx(false);
        this.mainModel.getStatusModel().setTx(false);
        this.mainModel.getStatusModel().setCd(false);
        this.mainModel.clearNodes();
    }

    private void loadLabels() {
        Object labelPath = this.miscSettings.getBidibConfigDir();
        LOGGER.info("Check if the directory for labels exists: {}", labelPath);
        boolean labelPathIsValid = false;
        do {
            try {
                File dir;
                block13: {
                    dir = FileUtils.getFile((String[])new String[]{labelPath});
                    if (!dir.exists()) {
                        LOGGER.info("Try to create the directory for labels: {}", labelPath);
                        try {
                            FileUtils.forceMkdir((File)dir);
                            LOGGER.info("Created new directory for labels: {}", (Object)dir);
                        }
                        catch (IOException ioex) {
                            int endIndex;
                            int beginIndex;
                            String configuredUserName;
                            String userName;
                            LOGGER.warn("Create new directory for labels failed.", (Throwable)ioex);
                            if (!SystemUtils.IS_OS_LINUX || !((String)labelPath).startsWith("/home/") || (userName = System.getProperty("user.name")).equals(configuredUserName = ((String)labelPath).substring(beginIndex = 6, endIndex = ((String)labelPath).indexOf("/", beginIndex)))) break block13;
                            LOGGER.warn("The current username '{}' does not match the configured username '{}' for the label path.", (Object)userName, (Object)configuredUserName);
                            Object[] options = new Object[]{Resources.getString(NodeExchangeHelper.class, (String)"labeldirerror.correct"), Resources.getString(NodeExchangeHelper.class, (String)"labeldirerror.ignore")};
                            int answer = JOptionPane.showOptionDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labeldirerror.message_username_mismatch", (Object[])new Object[]{userName, configuredUserName, labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labeldirerror.title"), 0, 0, null, options, options[0]);
                            if (answer != 0) break block13;
                            labelPath = "/home/" + userName + ((String)labelPath).substring(endIndex);
                            LOGGER.info("The user selected to correct the label path: {}", labelPath);
                            this.miscSettings.setBidibConfigDir((String)labelPath);
                            this.settingsService.storeSettings();
                            dir = FileUtils.getFile((String[])new String[]{labelPath});
                            if (dir.exists()) break block13;
                            LOGGER.info("Try to create the directory for labels: {}", labelPath);
                            try {
                                FileUtils.forceMkdir((File)dir);
                                LOGGER.info("Created new directory for labels: {}", (Object)dir);
                            }
                            catch (IOException ioex2) {
                                LOGGER.warn("Create new directory for labels failed.", (Throwable)ioex);
                            }
                        }
                    }
                }
                if (!dir.exists()) {
                    LOGGER.warn("The directory for labels is not available. Check permission on path: {}", labelPath);
                    throw new IllegalStateException("The directory for labels is not available. Check permission on path: " + (String)labelPath);
                }
                if (!dir.canWrite()) {
                    LOGGER.warn("The directory for labels is not write enabled. Check permission on path: {}", labelPath);
                    throw new IllegalStateException("The directory for labels is not write enabled. Check permission on path: " + (String)labelPath);
                }
                LOGGER.info("The label directory is write enabled: {}", labelPath);
                labelPathIsValid = true;
            }
            catch (Exception ex) {
                LOGGER.warn("The directory for labels is not available or is not write enabled. Check permission on path: {}", labelPath, (Object)ex);
                int choice = JOptionPane.showOptionDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labeldirerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labeldirerror.title"), 2, 0, null, null, null);
                if (choice == 2) {
                    System.exit(0);
                    continue;
                }
                FolderChooser chooser = new FolderChooser();
                String userHome = System.getProperty("user.home");
                File bidibDefaultDir = new File(userHome, ".bidib");
                chooser.setSelectedFolder(bidibDefaultDir);
                int returnVal = chooser.showOpenDialog((Component)JOptionPane.getFrameForComponent(null));
                if (returnVal == 0) {
                    LOGGER.info("You chose to open this folder: {}", (Object)chooser.getSelectedFile().getPath());
                    labelPath = chooser.getSelectedFile().getPath();
                    continue;
                }
                System.exit(0);
            }
        } while (!labelPathIsValid);
        if (!((String)labelPath).equals(this.miscSettings.getBidibConfigDir())) {
            LOGGER.info("Set the new label path: {}", labelPath);
            this.miscSettings.setBidibConfigDir((String)labelPath);
            this.settingsService.storeSettings();
        }
        this.startupWorkers.submit(() -> {
            LOGGER.info("Start load and register label factories.");
            AtomicBoolean startupPassed = new AtomicBoolean(false);
            try {
                this.reloadLabels(null);
                startupPassed.set(true);
            }
            catch (Exception ex) {
                LOGGER.warn("Load labels failed.", (Throwable)ex);
            }
            LOGGER.info("Load and register labels passed. Invoke open UI.");
            SwingUtilities.invokeLater(() -> {
                LOGGER.info("Open the UI from AWT-thread.");
                if (startupPassed.get()) {
                    this.prepareAndOpenUI();
                } else {
                    JOptionPane.showMessageDialog(null, Resources.getString(MainController.class, (String)"mandatory-directory-missing.text"), Resources.getString(MainController.class, (String)"mandatory-directory-missing.title"), 0);
                    System.exit(1);
                }
                LOGGER.info("Open the UI has finished.");
            });
        });
    }

    private void reloadLabels(Long uniqueId) {
        LOGGER.info("Reload labels for uniqueId: {}", (Object)uniqueId);
        if (uniqueId != null) {
            this.wizardLabelWrapper.loadLabels(uniqueId);
        }
    }

    private boolean setDefaultCursor() {
        LOGGER.info("Set default cursor");
        return this.mainView.setBusy(false);
    }

    private boolean setWaitCursor() {
        LOGGER.info("Set wait cursor");
        return this.mainView.setBusy(true);
    }

    public void start() {
        LOGGER.info("Start the main controller");
        DefaultApplicationContext.getInstance().register("mainController", (Object)this);
        this.loadLabels();
    }

    private void prepareAndOpenUI() {
        String startupMode;
        LOGGER.info("Open the UI.");
        this.mainView = this.mainViewFactory.create(this.settingsService, this.context);
        Disposable dispNodeStatusInfoChanges = this.connectionService.subscribeNodeStatusInfoChanges(nsi -> {
            LOGGER.info("The node status info has changed: {}", nsi);
            if (this.connectionId.equals(nsi.getConnectionId())) {
                if (nsi.getLoadStatus() == NodeStatusInfo.LoadStatus.FINISHED) {
                    LOGGER.info("The initial load of the node tree data has finished. Total number of nodes: {}", nsi.getArgs());
                    this.mainModel.signalInitialLoadFinished();
                    String statusText = null;
                    statusText = nsi.getArgs() != null && nsi.getArgs().length > 0 ? Resources.formatString((String)nsi.getResourceKey(), (Object[])nsi.getArgs()) : "The initial load of the node tree data has finished.";
                    this.statusBar.setStatusText(statusText);
                } else if (nsi.getLoadStatus() == NodeStatusInfo.LoadStatus.UNKNOWN) {
                    try {
                        String statusText = Resources.formatString((String)nsi.getResourceKey(), (Object[])nsi.getArgs());
                        this.statusBar.setStatusText(statusText);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Format and display the status bar message failed: {}", nsi, (Object)ex);
                    }
                }
            }
        }, error -> LOGGER.warn("The initial load of the node tree data has failed.", error));
        this.compDisposable.add(dispNodeStatusInfoChanges);
        Disposable dispConnectionStatus = this.connectionService.subscribeConnectionStatusChanges(ci -> {
            String connectionId = ci.getConnectionId();
            if (this.connectionId.equals(connectionId)) {
                this.publishStatus(connectionId, ci.getConnectionState().getActualPhase(), null);
            }
        }, error -> {
            LOGGER.warn("Subscription to connection status signalled an error: ", error);
            this.publishStatus(error);
        });
        this.compDisposable.add(dispConnectionStatus);
        Disposable dispConnectionAction = this.connectionService.subscribeConnectionActions(ci -> {
            String connectionId = ci.getConnectionId();
            if (this.connectionId.equals(connectionId)) {
                this.publishAction(connectionId, ci.getMessageKey(), ci.getContext());
            }
        }, error -> {
            LOGGER.warn("Subscription to connection action signalled an error: ", error);
            this.publishAction(error);
        });
        this.compDisposable.add(dispConnectionAction);
        this.mainView.createComponents();
        this.mainView.prepareFrame();
        DefaultApplicationContext.getInstance().register("mainFrame", (Object)this.mainView.getFrame());
        LOGGER.info("Fetched startup params: {}", (Object)this.startupParams);
        if (this.startupParams != null && "iconified".equalsIgnoreCase(startupMode = this.startupParams.getStartupMode())) {
            this.mainView.getFrame().setExtendedState(1);
        }
        this.mainView.setVisible(true);
        this.mainView.bringWindowToFront();
        this.mainView.setStatusText(Resources.getString(this.getClass(), (String)"connectHint"), -1);
        this.mainView.addNodeListListener((NodeListActionListener)this.mainNodeListActionListener);
        DefaultApplicationContext.getInstance().register("mainNodeListActionListener", (Object)this.mainNodeListActionListener);
        this.mainView.addNodeListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainView.addCvDefinitionRequestListener((CvDefinitionRequestListener)new MainCvDefinitionRequestListener(this.mainModel, this.nodeService, this.connectionId, this.statusBar, this.mainView.getFrame()));
        this.mainView.setWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.startupPassed.set(true);
        ConsoleController.ensureConsoleVisible();
        if (this.wizardSettings.isShowBoosterTable()) {
            LOGGER.info("Show the booster table is selected in preferences.");
            try {
                this.applicationEventPublisher.publishEvent((Object)new MenuEvent(MenuEvent.Action.boosterTable));
            }
            catch (Exception ex) {
                LOGGER.warn("Open booster table failed.", (Throwable)ex);
            }
        }
        if (this.miscSettings.isLoadWorkspaceAtStartup()) {
            String workspacePath = this.miscSettings.getWorkspacePath();
            File loadFile = null;
            try {
                loadFile = new File(workspacePath, "workspace.xml");
                LOGGER.info("Load workspace from file: {}", (Object)loadFile);
                if (!loadFile.getParentFile().exists()) {
                    throw new IllegalArgumentException("The requested file is not available: " + loadFile);
                }
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(loadFile));){
                    this.dockingContext.readXML((InputStream)in);
                    LOGGER.info("Load workspace passed.");
                }
                catch (IOException | ParserConfigurationException | SAXException ioe) {
                    LOGGER.warn("Load workspace failed.", (Throwable)ioe);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Load workspace from file failed.", (Throwable)ex);
            }
        }
        this.subscribeConnectionStatusChanges();
        boolean isAutoConnect = false;
        if (this.startupParams != null) {
            isAutoConnect = this.startupParams.isAutoConnect();
        }
        if (isAutoConnect) {
            LOGGER.info("Queue the autoConnect task.");
            SwingUtilities.invokeLater(() -> {
                try {
                    LOGGER.info("Try to autoconnect.");
                    this.applicationEventPublisher.publishEvent((Object)new BidibConnectionEvent(this.connectionId, BidibConnectionEvent.Action.connect));
                }
                catch (Exception ex) {
                    LOGGER.warn("Autoconnect failed: {}", (Throwable)ex);
                }
            });
        } else if (this.wizardSettings.isUseHotPlugController()) {
            try {
                LOGGER.info("Create and start AlertController.");
                this.alertController.start();
                LOGGER.info("Create and start AlertController has finished.");
            }
            catch (Exception ex) {
                LOGGER.warn("Start AlertController for USB devices failed.", (Throwable)ex);
            }
            catch (Error err) {
                LOGGER.warn("Start AlertController for USB devices failed.", (Throwable)err);
            }
        } else {
            LOGGER.info("The usage of hotplug controller is disabled in preferences.");
        }
        this.showTipOfDay();
    }

    private void subscribeConnectionStatusChanges() {
        LOGGER.info("Subscribe to connection status changes. Currently configured connectionId: {}", (Object)this.connectionId);
        Disposable dispConnectionStatusChanges = this.connectionService.subscribeConnectionStatusChanges(ci -> {
            LOGGER.info("The connection status has changed: {}", ci);
            if (this.connectionId.equals(ci.getConnectionId())) {
                LOGGER.info("The status of the configured connection has changed.");
                if (ci.getConnectionState().getActualPhase() == ConnectionPhase.CONNECTING) {
                    LOGGER.info("Connection is now connecting, connectionId: {}", (Object)this.connectionId);
                    BidibConnection conn = this.connectionService.find(this.connectionId);
                    if (conn != null) {
                        LOGGER.info("Set the node provider to the model.");
                        this.mainModel.setNodeProvider(conn.getNodeProvider());
                    } else {
                        LOGGER.warn("Cannot set the node provider in the model because no connection found with id: {}", (Object)this.connectionId);
                    }
                    this.compDispConnectionStatusChanges.dispose();
                    this.compDispConnectionStatusChanges.clear();
                }
            }
        }, err -> LOGGER.warn("Subscription to connection status changes caused an error: {}", err));
        this.compDispConnectionStatusChanges.add(dispConnectionStatusChanges);
    }

    private void showTipOfDay() {
        if (this.wizardSettings.isShowTipOfDay()) {
            LOGGER.info("Show tip of days.");
            LinkedList alertList = new LinkedList();
            4 alertListener = new /* Unavailable Anonymous Inner Class!! */;
            if (this.alertController != null) {
                this.alertController.addAlertListener((AlertListener)alertListener);
            }
            5 listener = new /* Unavailable Anonymous Inner Class!! */;
            try {
                this.tipOfDayController.start((TipOfDayClosedListener)listener);
            }
            catch (Exception ex) {
                LOGGER.warn("Start the tip of day controller failed.", (Throwable)ex);
            }
        } else {
            LOGGER.info("Show tip of days is disabled in settings.");
        }
    }

    public void stop() {
        LOGGER.info("Stop the main controller.");
        this.selectedNodeChangeWorker.shutdownNow();
        this.compDispConnectionStatusChanges.dispose();
        this.mainView.saveWindowPosition();
        try {
            LOGGER.info("Dispose the compDisposable: {}", (Object)this.compDisposable);
            this.compDisposable.dispose();
        }
        catch (Exception ex) {
            LOGGER.warn("Dispose the compDisposable failed.", (Throwable)ex);
        }
        if (this.alertController != null) {
            try {
                this.alertController.stopWatcher();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop usbHotPlugController failed.", (Throwable)ex);
            }
        }
        this.mainView.performShutdown();
        this.mainView.setVisible(false);
        this.mainView.getFrame().dispose();
        int exitCode = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        LOGGER.info("Exit with exitCode: {}", (Object)exitCode);
        System.exit(exitCode);
    }

    public void addNodeListListener(NodeListListener nodeListListener) {
        LOGGER.info("Add new nodeListListener: {}", (Object)nodeListListener);
        this.mainModel.addNodeListListener(nodeListListener);
    }

    public void removeNodeListListener(NodeListListener nodeListListener) {
        LOGGER.info("Remove nodeListListener: {}", (Object)nodeListListener);
        this.mainModel.removeNodeListListener(nodeListListener);
    }

    public void addNodeSelectionListListener(NodeSelectionListener l) {
        this.mainModel.addNodeSelectionListener(l);
    }

    public void removeNodeSelectionListener(NodeSelectionListener l) {
        this.mainModel.removeNodeSelectionListener(l);
    }

    @EventListener
    public void handleConnectionEvent(BidibConnectionEvent event) {
        LOGGER.info("Received connection event: {}", (Object)event);
        SwingUtilities.invokeLater(() -> {
            if (this.connectionId.equals(event.getConnectionId())) {
                switch (7.$SwitchMap$org$bidib$wizard$client$common$event$BidibConnectionEvent$Action[event.getAction().ordinal()]) {
                    case 1: {
                        this.openConnection();
                        break;
                    }
                    case 2: {
                        try {
                            this.closeConnection();
                        }
                        catch (CloseAbortedException ex) {
                            LOGGER.warn("Close connection was aborted, reason: {}", (Object)ex.getMessage());
                        }
                        break;
                    }
                }
            }
        });
    }

    public void openConnection() {
        LOGGER.info("### Open the connection to BiDiB.");
        DefaultContext context = new DefaultContext();
        this.doOpenConnection((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpenConnection(Context context) {
        if (this.connectionService.isConnected(this.connectionId)) {
            LOGGER.warn("The is opened already. Skip open connection.");
            return;
        }
        Object object = this.openThreadLock;
        synchronized (object) {
            LOGGER.info("Start a thread to open the port.");
            if (this.openConnectionFuture != null) {
                LOGGER.warn("An openThread is already running!!!!");
                return;
            }
            String openConnectionId = this.connectionId;
            Runnable openThread = () -> {
                LOGGER.info("The open thread is starting.");
                try {
                    Function<BidibConnection, BidibConnection> afterCreateOrFind = conn -> {
                        LOGGER.info("Open connection has passed, connectionId: {}", (Object)this.connectionId);
                        if (this.localHostHandlerFactory != null) {
                            LOGGER.info("Create the localHost handler.");
                            BidibDistributedMessageListener localHostHandler = this.localHostHandlerFactory.createLocalHostHandler(conn);
                            context.register(BidibDistributedMessageListener.class.getSimpleName(), (Object)localHostHandler);
                        }
                        return conn;
                    };
                    this.connectionService.connect(openConnectionId, afterCreateOrFind, afterCreateOrFind, context);
                }
                catch (ConnectionException ex) {
                    LOGGER.warn("Connect failed.", (Throwable)ex);
                    String message = ex.getMessage();
                    if (StringUtils.isNotBlank((CharSequence)ex.getUri())) {
                        StringBuilder sb = new StringBuilder(ex.getUri());
                        sb.append("\r\n").append(ex.getMessage());
                        message = sb.toString();
                    }
                    this.showErrorDialog(Resources.getString(MainController.class, (String)"open-connection.failed", (Object[])new Object[]{message}), Resources.getString(MainController.class, (String)"open-connection.title"));
                }
                LOGGER.info("+++ The openThread has finished.");
                this.openConnectionFuture = null;
            };
            LOGGER.info("Start the open thread.");
            this.openConnectionFuture = this.openConnectionWorker.submit(openThread);
        }
    }

    public void listenNetBidib() {
        LOGGER.info("### Listen for incomng netBiDiB connections.");
        DefaultContext context = new DefaultContext();
        context.register(NetBidibSocketType.class.getSimpleName(), (Object)NetBidibSocketType.serverSocket);
        this.doOpenConnection((Context)context);
    }

    public void closeConnection() {
        boolean continueClose;
        LOGGER.info("### Close the connection to BiDiB.");
        boolean isSimulation = this.connectionService.isSimulation(this.connectionId);
        LOGGER.info("The current connection is a simulation: {}", (Object)isSimulation);
        if (isSimulation && !(continueClose = this.showConfirmDialog(Resources.getString(MainController.class, (String)"close-simulation-connection.message"), Resources.getString(MainController.class, (String)"close-simulation-connection.title")))) {
            LOGGER.info("The user cancelled the disconnect.");
            throw new CloseAbortedException("The user cancelled the disconnect.");
        }
        if (this.openConnectionFuture != null && !this.openConnectionFuture.isDone()) {
            LOGGER.warn("The openThread is running!!!! Wait for termination.");
            try {
                LOGGER.info("### Interrupt the open thread.");
                boolean cancelled = this.openConnectionFuture.cancel(true);
                LOGGER.info("### The open thread was cancelled: {}", (Object)cancelled);
                LOGGER.info("### The open thread has finished.");
            }
            catch (Exception ex) {
                LOGGER.warn("### Wait for termination of openThread failed.", (Throwable)ex);
            }
        }
        this.connectionService.disconnect(this.connectionId);
        LOGGER.info("The connection service has closed the connection.");
        if (this.compDispConnectionStatusChanges.isDisposed()) {
            this.compDispConnectionStatusChanges = new CompositeDisposable();
            this.subscribeConnectionStatusChanges();
        }
    }

    private void showErrorDialog(String message, String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog((Component)this.mainView.getFrame(), message, title, 0);
        } else {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)this.mainView.getFrame(), message, title, 0));
        }
    }

    private boolean showConfirmDialog(String message, String title) {
        int result = JOptionPane.showConfirmDialog((Component)this.mainView.getFrame(), message, title, 2);
        return 0 == result;
    }

    public void allBoosterOff() {
        for (NodeInterface node : this.mainModel.getNodeProvider().getNodes()) {
            if (!NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) continue;
            LOGGER.info("Switch booster off: {}", (Object)node);
            try {
                this.boosterService.setBoosterState(this.connectionId, node.getBoosterNode(), BoosterStatus.OFF);
            }
            catch (Exception ex) {
                LOGGER.warn("Switch booster off failed for node: {}", (Object)node, (Object)ex);
            }
        }
    }

    public void allBoosterOn(boolean boosterAndCommandStation, CommandStationStatus requestedCommandStationState) {
        LOGGER.info("Switch all boosters on, boosterAndCommandStation: {}, requestedCommandStationState: {}", (Object)boosterAndCommandStation, (Object)requestedCommandStationState);
        if (boosterAndCommandStation) {
            LOGGER.info("Switch the command stations on before the boosters will be switched on.");
            for (NodeInterface node : this.mainModel.getNodeProvider().getNodes()) {
                if (node.getCommandStationNode() == null || !NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) continue;
                try {
                    LOGGER.info("Send soft-stop to command station to stop all locos: {}", (Object)node);
                    this.commandStationService.setCommandStationState(this.connectionId, node.getCommandStationNode(), CommandStationStatus.SOFTSTOP);
                    Thread.sleep(300L);
                }
                catch (Exception ex) {
                    LOGGER.warn("Switch command station to SOFTSTOP failed for node: {}", (Object)node, (Object)ex);
                }
                try {
                    LOGGER.info("Switch command station on: {}", (Object)node);
                    this.commandStationService.setCommandStationState(this.connectionId, node.getCommandStationNode(), requestedCommandStationState);
                }
                catch (Exception ex) {
                    LOGGER.warn("Switch command station on failed for node: {}", (Object)node, (Object)ex);
                }
            }
            LOGGER.info("Wait a little bit to let the command station send the DCC signal.");
            try {
                Thread.sleep(300L);
            }
            catch (Exception ex) {
                LOGGER.warn("Wait a little bit to let the command station send the DCC signal was interrupted.", (Throwable)ex);
            }
        }
        LOGGER.info("Switch all boosters on.");
        for (NodeInterface node : this.mainModel.getNodeProvider().getNodes()) {
            if (!NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) continue;
            LOGGER.info("Switch booster on: {}", (Object)node);
            try {
                this.boosterService.setBoosterState(this.connectionId, node.getBoosterNode(), BoosterStatus.ON);
            }
            catch (Exception ex) {
                LOGGER.warn("Switch booster on failed for node: {}", (Object)node, (Object)ex);
            }
        }
    }

    public void resetNode(NodeInterface node) {
        LOGGER.info("Reset the current node: {}", (Object)node);
        this.nodeService.reset(this.connectionId, node);
    }

    public void transferAccessoryToNode(NodeInterface node, Accessory accessory) {
        LOGGER.info("Transfer the accessory to the node and save permanently: {}", (Object)(accessory != null ? accessory.getDebugString() : null));
        try {
            this.switchingNodeService.saveAccessory(this.connectionId, node.getSwitchingNode(), accessory);
            LOGGER.info("Transfer and save accessory passed.");
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Transfer accessory or save accessory failed.", (Throwable)ex);
            this.mainModel.setNodeHasError(this.mainModel.getSelectedNode(), true);
            throw ex;
        }
    }

    public void replacePortConfig(TargetType portType, Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Replace the port config, portType: {}, portConfig: {}", (Object)portType, portConfig);
        try {
            NodeInterface node = this.mainModel.getSelectedNode();
            switch (7.$SwitchMap$org$bidib$wizard$common$script$node$types$ScriptingTargetType[portType.getScriptingTargetType().ordinal()]) {
                case 1: {
                    BacklightPort backlightPort = (BacklightPort)PortListUtils.findPortByPortNumber((List)node.getBacklightPorts(), (int)portType.getPortNum());
                    if (backlightPort != null) {
                        backlightPort.setPortConfigX(portConfig);
                        this.setPortParameters(node, (Port)backlightPort, portConfig);
                        break;
                    }
                    LOGGER.warn("No backlightPort available with port number: {}", (Object)portType.getPortNum());
                    break;
                }
                case 2: {
                    LightPort lightPort = (LightPort)PortListUtils.findPortByPortNumber((List)node.getLightPorts(), (int)portType.getPortNum());
                    if (lightPort != null) {
                        lightPort.setPortConfigX(portConfig);
                        this.setPortParameters(node, (Port)lightPort, portConfig);
                        break;
                    }
                    LOGGER.warn("No lightPort available with port number: {}", (Object)portType.getPortNum());
                    break;
                }
                case 3: {
                    ServoPort servoPort = (ServoPort)PortListUtils.findPortByPortNumber((List)node.getServoPorts(), (int)portType.getPortNum());
                    if (servoPort != null) {
                        servoPort.setPortConfigX(portConfig);
                        this.setPortParameters(node, (Port)servoPort, portConfig);
                        break;
                    }
                    LOGGER.warn("No servoPort available with port number: {}", (Object)portType.getPortNum());
                    break;
                }
                case 4: {
                    SwitchPort switchPort = (SwitchPort)PortListUtils.findPortByPortNumber((List)node.getEnabledSwitchPorts(), (int)portType.getPortNum());
                    if (switchPort != null) {
                        switchPort.setPortConfigX(portConfig);
                        this.setPortParameters(node, (Port)switchPort, portConfig);
                        break;
                    }
                    LOGGER.warn("No switchPort available with port number: {}", (Object)portType.getPortNum());
                    break;
                }
                case 5: {
                    SwitchPairPort switchPairPort = (SwitchPairPort)PortListUtils.findPortByPortNumber((List)node.getEnabledSwitchPairPorts(), (int)portType.getPortNum());
                    if (switchPairPort != null) {
                        switchPairPort.setPortConfigX(portConfig);
                        this.setPortParameters(node, (Port)switchPairPort, portConfig);
                        break;
                    }
                    LOGGER.warn("No switchPairPort available with port number: {}", (Object)portType.getPortNum());
                    break;
                }
                default: {
                    LOGGER.warn("Unsupported port type detected: {}", (Object)portType);
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Replace port config on node failed.", (Throwable)ex);
        }
    }

    public void mapPortType(TargetType portType) {
        LOGGER.info("Map the port to the new type, portType: {}", (Object)portType);
        NodeInterface node = this.mainModel.getSelectedNode();
        Port port = null;
        LcOutputType lcOutputType = null;
        switch (7.$SwitchMap$org$bidib$wizard$common$script$node$types$ScriptingTargetType[portType.getScriptingTargetType().ordinal()]) {
            case 1: {
                port = PortListUtils.findPortByPortNumber((List)node.getBacklightPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.BACKLIGHTPORT;
                break;
            }
            case 6: {
                port = PortListUtils.findPortByPortNumber((List)node.getInputPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.INPUTPORT;
                break;
            }
            case 2: {
                port = PortListUtils.findPortByPortNumber((List)node.getLightPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.LIGHTPORT;
                break;
            }
            case 7: {
                port = PortListUtils.findPortByPortNumber((List)node.getMotorPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.MOTORPORT;
                break;
            }
            case 3: {
                port = PortListUtils.findPortByPortNumber((List)node.getServoPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.SERVOPORT;
                break;
            }
            case 8: {
                port = PortListUtils.findPortByPortNumber((List)node.getSoundPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.SOUNDPORT;
                break;
            }
            case 4: {
                port = PortListUtils.findPortByPortNumber((List)node.getSwitchPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.SWITCHPORT;
                break;
            }
            case 5: {
                port = PortListUtils.findPortByPortNumber((List)node.getSwitchPairPorts(), (int)portType.getPortNum());
                lcOutputType = LcOutputType.SWITCHPAIRPORT;
                break;
            }
            default: {
                LOGGER.warn("Unsupported port type detected: {}", (Object)portType);
            }
        }
        if (port == null) {
            LOGGER.warn("No port found to map for portType: {}", (Object)portType);
            throw new RuntimeException("No port found to map for portType:" + portType);
        }
        LinkedHashMap portConfig = new LinkedHashMap();
        this.switchingNodeService.setPortConfig(this.connectionId, node.getSwitchingNode(), port, lcOutputType, portConfig);
    }

    private void setPortParameters(NodeInterface node, Port<?> port, Map<Byte, PortConfigValue<?>> portConfig) {
        this.switchingNodeService.setPortConfig(this.connectionId, node.getSwitchingNode(), port);
    }

    private void publishStatus(Throwable error) {
        LOGGER.error("Notify error on connectionState: {}", error);
    }

    private void publishStatus(String connectionId, ConnectionPhase connectionPhase, String error) {
        LOGGER.info("Notify new connectionState, connectionId: {}, connectionPhase: {}, error: {}", new Object[]{connectionId, connectionPhase, error});
        if (connectionId.equals(this.connectionId)) {
            ConnectionPhase prevConnectionPhase = this.connectionPhaseModel.getConnectionPhase();
            if (SwingUtilities.isEventDispatchThread()) {
                this.connectionPhaseModel.setConnectionPhase(connectionPhase);
            } else {
                SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            switch (7.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionPhase.ordinal()]) {
                case 1: {
                    LOGGER.info("Port was opened is signalled, connectionId: {}, prevConnectionPhase: {}", (Object)connectionId, (Object)prevConnectionPhase);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.mainModel.getStatusModel().setCd(true);
                        if (ConnectionPhase.STALL != prevConnectionPhase) break;
                        this.showConsoleStall(connectionId, false);
                        break;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.mainModel.getStatusModel().setCd(true);
                        if (ConnectionPhase.STALL == prevConnectionPhase) {
                            this.showConsoleStall(connectionId, false);
                        }
                    });
                    break;
                }
                case 2: {
                    LOGGER.info("Port was closed is signalled, connectionId: {}", (Object)connectionId);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.handleClosed(connectionId);
                        break;
                    }
                    SwingUtilities.invokeLater(() -> this.handleClosed(connectionId));
                    break;
                }
                case 3: {
                    SwingUtilities.invokeLater(() -> this.showConsoleStall(connectionId, true));
                    break;
                }
            }
        } else {
            LOGGER.info("The connectionId is not matching, stored: {}, provided: {}", (Object)this.connectionId, (Object)connectionId);
        }
    }

    private void showConsoleStall(String connectionId, boolean stall) {
        try {
            ConsoleController.ensureConsoleVisible();
            String consoleLineText = null;
            if (stall) {
                LOGGER.info("The stall state of the connection has been set to true, connectionId: {}", (Object)connectionId);
                consoleLineText = String.format("The stall state of the connection has been set to true, connectionId: %s", connectionId);
            } else {
                LOGGER.info("The stall state of the connection has been set to false., connectionId: {}", (Object)connectionId);
                consoleLineText = String.format("The stall state of the connection has been set to false, connectionId: %s", connectionId);
            }
            LOGGER.warn(consoleLineText);
            this.consoleService.addConsoleLine(ConsoleColor.red, consoleLineText);
        }
        catch (Exception ex) {
            LOGGER.warn("Add change of stall state of connection to console failed, connectionId: {}", (Object)connectionId, (Object)ex);
        }
    }

    private void handleClosed(String connectionId) {
        LOGGER.info("Port was closed, set the status text and clear the nodes, connectionId: {}", (Object)connectionId);
        this.mainModel.getStatusModel().setModelClockStartEnabled(false);
        this.clearNodes();
        this.mainModel.getStatusModel().setCd(false);
        this.mainModel.signalResetInitialLoadFinished();
        if (this.pairingDialog != null) {
            LOGGER.info("Close the pairing dialog on disconnect.");
            this.pairingDialog.setVisible(false);
            this.pairingDialog = null;
        }
        if (this.compDispConnectionStatusChanges.isDisposed()) {
            this.compDispConnectionStatusChanges = new CompositeDisposable();
            this.subscribeConnectionStatusChanges();
        }
        if (this.openConnectionFuture != null) {
            LOGGER.info("+++ The connection was closed. Free the openConnectionFuture.");
            this.openConnectionFuture = null;
        }
    }

    private void publishAction(String connectionId, String messageKey, Context context) {
        LOGGER.info("Notify the action, connectionId: {}, messageKey: {}, context: {}", new Object[]{connectionId, messageKey, context});
        if (connectionId.equals(this.connectionId) && messageKey.startsWith("pairing-")) {
            LOGGER.info("This is a pairing action: {}", (Object)messageKey);
            SwingUtilities.invokeLater(() -> {
                Long uniqueId = (Long)context.get("DESCRIPTOR_UID", Long.class, null);
                String connectionType = (String)context.get("CONNECTION_TYPE", String.class, null);
                switch (messageKey) {
                    case "pairing-state": {
                        if (context.get("PAIRING_STATE", PairingStateEnum.class, (Object)PairingStateEnum.Unpaired) == PairingStateEnum.Unpaired) {
                            LOGGER.info("Unpaired status was signalled. Send the pairing request to the remote partner.");
                            this.signalPairingRequest();
                            if (this.pairingDialog == null) {
                                LOGGER.info("Show the pairing dialog.");
                                this.pairingDialog = new PairingDialog((Component)this.mainView.getFrame(), PairingDialog.PairingDialogType.PairingRequired, context, true, accepted -> {
                                    if (Boolean.FALSE == accepted) {
                                        LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog.");
                                        this.closeConnection();
                                    }
                                });
                                this.pairingDialog.setAlwaysOnTop(true);
                                this.pairingDialog.setVisible(true);
                                break;
                            }
                            LOGGER.warn("Pairing dialog is already assigned.");
                            break;
                        }
                        LOGGER.info("Paired status was signalled. Hide the pairing dialog if shown, pairingDialog: {}", (Object)this.pairingDialog);
                        if (this.pairingDialog == null) break;
                        LOGGER.info("The pairing has passed. Hide the pairing dialog.");
                        this.pairingDialog.setVisible(false);
                        this.pairingDialog = null;
                        break;
                    }
                    case "pairing-required": {
                        if (this.pairingDialog == null) {
                            LOGGER.info("Show the pairing dialog.");
                            this.pairingDialog = new PairingDialog((Component)this.mainView.getFrame(), PairingDialog.PairingDialogType.PairingRequired, context, true, accepted -> {
                                if (Boolean.FALSE == accepted) {
                                    LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog.");
                                    this.closeConnection();
                                }
                            });
                            this.pairingDialog.setAlwaysOnTop(true);
                            this.pairingDialog.setVisible(true);
                            break;
                        }
                        LOGGER.warn("Pairing dialog is already assigned.");
                        break;
                    }
                    case "pairing-requested": {
                        if ("server".equals(connectionType)) {
                            if (this.pairingDialog != null) {
                                LOGGER.info("The pairing is requested. Hide the existing pairing dialog.");
                                this.pairingDialog.setVisible(false);
                                this.pairingDialog = null;
                            }
                            if (this.pairingDialog == null) {
                                LOGGER.info("Show the pairing requested dialog.");
                                this.pairingDialog = new PairingDialog((Component)this.mainView.getFrame(), PairingDialog.PairingDialogType.PairingRequested, context, true, accepted -> {
                                    if (Boolean.FALSE == accepted) {
                                        LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog.");
                                        this.signalPairingStatus(uniqueId, NetBidibLinkData.PairingStatus.UNPAIRED);
                                        this.closeConnection();
                                    } else {
                                        LOGGER.info("We accepted the pairing.");
                                        this.signalPairingStatus(uniqueId, NetBidibLinkData.PairingStatus.PAIRED);
                                    }
                                });
                                this.pairingDialog.setAlwaysOnTop(true);
                                this.pairingDialog.setVisible(true);
                                break;
                            }
                            LOGGER.warn("Pairing dialog is already assigned.");
                            LOGGER.info("We accept the pairing immediately.");
                            this.signalPairingStatus(uniqueId, NetBidibLinkData.PairingStatus.PAIRED);
                            break;
                        }
                        LOGGER.info("We accept the pairing immediately.");
                        this.signalPairingStatus(uniqueId, NetBidibLinkData.PairingStatus.PAIRED);
                        break;
                    }
                    case "pairing-passed": {
                        if (this.pairingDialog == null) break;
                        LOGGER.info("The pairing has passed. Hide the pairing dialog.");
                        this.pairingDialog.setVisible(false);
                        this.pairingDialog = null;
                        break;
                    }
                    case "pairing-failed": {
                        if (this.pairingDialog == null) break;
                        LOGGER.info("The pairing has failed. Hide the pairing dialog.");
                        this.pairingDialog.setVisible(false);
                        this.pairingDialog = null;
                        break;
                    }
                }
                String statusText = Resources.getString(MainController.class, (String)messageKey);
                this.mainView.setStatusText(statusText, -1);
            });
        }
    }

    private void signalPairingStatus(Long uniqueId, NetBidibLinkData.PairingStatus pairingStatus) {
        LOGGER.info("Signal the pairing status to the connection: {}, uniqueId: {}", (Object)pairingStatus, (Object)ByteUtils.getUniqueIdAsString((Long)uniqueId));
        this.netBidibPublisherWorker.submit(() -> this.connectionService.signalPairingStatus(this.connectionId, uniqueId, pairingStatus));
    }

    private void signalPairingRequest() {
        LOGGER.info("Signal the pairing request to the connection.");
        this.netBidibPublisherWorker.submit(() -> this.connectionService.signalPairingRequest(this.connectionId));
    }

    private void publishAction(Throwable error) {
        LOGGER.error("Notify error on action: {}", error);
    }

    @EventListener
    public void handleMenuEvent(MainControllerEvent event) {
        LOGGER.info("Handle the menu event: {}", (Object)event);
        SwingUtilities.invokeLater(() -> {
            switch (7.$SwitchMap$org$bidib$wizard$client$common$event$MainControllerEvent$Action[event.getAction().ordinal()]) {
                case 1: {
                    this.allBoosterOff();
                    break;
                }
                case 2: {
                    MainControllerBoosterOnEvent boosterOnEvent = (MainControllerBoosterOnEvent)event;
                    this.allBoosterOn(boosterOnEvent.isBoosterAndCommandStation(), boosterOnEvent.getRequestedCommandStationState());
                    break;
                }
                case 3: {
                    this.stop();
                    break;
                }
                case 4: {
                    this.listenNetBidib();
                    break;
                }
            }
        });
    }
}

